/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;

public abstract class MessageDigestSpi {
    protected int engineGetDigestLength() {
        return 0;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected void engineUpdate(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[1024];
        while (byteBuffer.hasRemaining()) {
            int n = Math.min(byteBuffer.remaining(), byArray.length);
            byteBuffer.get(byArray, 0, n);
            this.engineUpdate(byArray, 0, n);
        }
    }

    protected abstract byte[] engineDigest();

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (this.engineGetDigestLength() > n2) {
            throw new DigestException("Buffer is too small.");
        }
        byte[] byArray2 = this.engineDigest();
        if (byArray2.length > n2) {
            throw new DigestException("Buffer is too small");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

