/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.DummyMessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String MESSAGE_DIGEST = "MessageDigest";
    private String algorithm;
    Provider provider;
    private byte[] lastDigest;

    protected MessageDigest(String string) {
        this.algorithm = string;
        this.provider = null;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return MessageDigest.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return MessageDigest.getInstance(string, provider);
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        MessageDigest messageDigest;
        Object object;
        CPStringBuilder cPStringBuilder = new CPStringBuilder("MessageDigest for algorithm [").append(string).append("] from provider[").append(provider).append("] ");
        try {
            object = Engine.getInstance(MESSAGE_DIGEST, string, provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
            cPStringBuilder.append("could not be created");
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
            noSuchAlgorithmException.initCause(throwable);
            throw noSuchAlgorithmException;
        }
        if (object instanceof MessageDigestSpi) {
            messageDigest = new DummyMessageDigest((MessageDigestSpi)object, string);
        } else if (object instanceof MessageDigest) {
            messageDigest = (MessageDigest)object;
            messageDigest.algorithm = string;
        } else {
            cPStringBuilder.append("is of an unexpected Type: ").append(object.getClass().getName());
            throw new NoSuchAlgorithmException(cPStringBuilder.toString());
        }
        messageDigest.provider = provider;
        return messageDigest;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(ByteBuffer byteBuffer) {
        this.engineUpdate(byteBuffer);
    }

    public byte[] digest() {
        this.lastDigest = this.engineDigest();
        return this.lastDigest;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        return this.engineDigest(byArray, n, n2);
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return this.getClass().getName() + " Message Digest <" + this.digestToString() + ">";
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private String digestToString() {
        byte[] byArray = this.lastDigest;
        if (byArray == null) {
            return "incomplete";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (byte by : byArray) {
            byte by2 = (byte)((by & 0xFF) >>> 4);
            byte by3 = (byte)(by & 0xF);
            cPStringBuilder.append(by2 > 9 ? 87 + by2 : 48 + by2);
            cPStringBuilder.append(by3 > 9 ? 87 + by3 : 48 + by3);
        }
        return cPStringBuilder.toString();
    }
}

