/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private final URL location;
    private transient HashSet certs;

    public CodeSource(URL uRL, Certificate[] certificateArray) {
        this.location = uRL;
        if (certificateArray != null) {
            this.certs = new HashSet<Certificate>(Arrays.asList(certificateArray));
        }
    }

    public int hashCode() {
        return (this.location == null ? 0 : this.location.hashCode()) ^ (this.certs == null ? 0 : this.certs.hashCode());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CodeSource)) {
            return false;
        }
        CodeSource codeSource = (CodeSource)object;
        return (this.certs == null ? codeSource.certs == null : this.certs.equals(codeSource.certs)) && (this.location == null ? codeSource.location == null : this.location.equals(codeSource.location));
    }

    public final URL getLocation() {
        return this.location;
    }

    public final Certificate[] getCertificates() {
        if (this.certs == null) {
            return null;
        }
        Certificate[] certificateArray = new Certificate[this.certs.size()];
        this.certs.toArray(certificateArray);
        return certificateArray;
    }

    public boolean implies(CodeSource codeSource) {
        Object object;
        String string;
        if (codeSource == null) {
            return false;
        }
        if (!(this.certs == null || codeSource.certs != null && this.certs.containsAll(codeSource.certs))) {
            return false;
        }
        if (this.location == null) {
            return true;
        }
        if (codeSource.location == null || !this.location.getProtocol().equals(codeSource.location.getProtocol()) || this.location.getPort() != -1 && this.location.getPort() != codeSource.location.getPort() || this.location.getRef() != null && !this.location.getRef().equals(codeSource.location.getRef())) {
            return false;
        }
        if (this.location.getHost() != null) {
            SocketPermission socketPermission;
            string = codeSource.location.getHost();
            if (string == null) {
                return false;
            }
            object = new SocketPermission(this.location.getHost(), "accept");
            if (!((SocketPermission)object).implies(socketPermission = new SocketPermission(string, "accept"))) {
                return false;
            }
        }
        if ((string = this.location.getFile()) != null) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((object = codeSource.location.getFile()) == null || !((String)object).startsWith(string)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder("(").append(this.location);
        if (this.certs == null || this.certs.isEmpty()) {
            cPStringBuilder.append(" <no certificates>");
        } else {
            Iterator iterator = this.certs.iterator();
            int n = this.certs.size();
            while (--n >= 0) {
                cPStringBuilder.append(' ').append(iterator.next());
            }
        }
        return cPStringBuilder.append(")").toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.certs = new HashSet();
        while (--n >= 0) {
            String string = (String)objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = objectInputStream.readByte();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(string);
                this.certs.add(certificateFactory.generateCertificate(byteArrayInputStream));
            }
            catch (CertificateException certificateException) {}
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null) {
            objectOutputStream.writeInt(0);
        } else {
            int n = this.certs.size();
            objectOutputStream.writeInt(n);
            Iterator iterator = this.certs.iterator();
            while (--n >= 0) {
                byte[] byArray;
                Certificate certificate = (Certificate)iterator.next();
                objectOutputStream.writeObject(certificate.getType());
                try {
                    byArray = certificate.getEncoded();
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    byArray = null;
                }
                if (byArray == null) {
                    objectOutputStream.writeInt(0);
                    continue;
                }
                objectOutputStream.writeInt(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    objectOutputStream.writeByte(byArray[i]);
                }
            }
        }
    }
}

