/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameters {
    private static final String ALGORITHM_PARAMETERS = "AlgorithmParameters";
    private AlgorithmParametersSpi paramSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameters(AlgorithmParametersSpi algorithmParametersSpi, Provider provider, String string) {
        this.paramSpi = algorithmParametersSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameters getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return AlgorithmParameters.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static AlgorithmParameters getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return AlgorithmParameters.getInstance(string, provider);
    }

    public static AlgorithmParameters getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        CPStringBuilder cPStringBuilder = new CPStringBuilder("AlgorithmParameters for algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(ALGORITHM_PARAMETERS, string, provider);
            return new AlgorithmParameters((AlgorithmParametersSpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(algorithmParameterSpec);
    }

    public final void init(byte[] byArray) throws IOException {
        this.paramSpi.engineInit(byArray);
    }

    public final void init(byte[] byArray, String string) throws IOException {
        this.paramSpi.engineInit(byArray, string);
    }

    public final <T extends AlgorithmParameterSpec> T getParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(clazz);
    }

    public final byte[] getEncoded() throws IOException {
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String string) throws IOException {
        return this.paramSpi.engineGetEncoded(string);
    }

    public final String toString() {
        return this.paramSpi.engineToString();
    }
}

