/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.VMAccessController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessController {
    private AccessController() {
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessController.getContext().checkPermission(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        T t;
        VMAccessController.pushContext(null);
        try {
            t = privilegedAction.run();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
        T t;
        VMAccessController.pushContext(accessControlContext);
        try {
            t = privilegedAction.run();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        T t;
        VMAccessController.pushContext(null);
        try {
            try {
                t = privilegedExceptionAction.run();
                Object var3_4 = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new PrivilegedActionException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        T t;
        VMAccessController.pushContext(accessControlContext);
        try {
            try {
                t = privilegedExceptionAction.run();
                Object var4_5 = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new PrivilegedActionException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            VMAccessController.popContext();
            throw throwable;
        }
        VMAccessController.popContext();
        return t;
    }

    public static AccessControlContext getContext() {
        return VMAccessController.getContext();
    }
}

