/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;

public final class UID
implements Serializable {
    private static final long serialVersionUID = 1086053664494604050L;
    private static short uidCounter = Short.MIN_VALUE;
    private static long last;
    private static final int machineId;
    private short count;
    private int unique;
    private long time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        Class<UID> clazz = UID.class;
        synchronized (UID.class) {
            this.time = System.currentTimeMillis();
            this.unique = machineId;
            if (this.time > last) {
                last = this.time;
                uidCounter = Short.MIN_VALUE;
                this.count = Short.MIN_VALUE;
            } else {
                if (uidCounter == Short.MAX_VALUE) {
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    uidCounter = Short.MIN_VALUE;
                    this.time = last = System.currentTimeMillis();
                }
                this.count = uidCounter = (short)(uidCounter + 1);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public UID(short s) {
        this.unique = s;
    }

    public int hashCode() {
        return (int)((long)this.unique ^ this.time ^ (long)this.count);
    }

    public boolean equals(Object object) {
        if (object instanceof UID) {
            UID uID = (UID)object;
            return this.unique == uID.unique && this.time == uID.time && this.count == uID.count;
        }
        return false;
    }

    public static UID read(DataInput dataInput) throws IOException {
        UID uID = new UID();
        uID.unique = dataInput.readInt();
        uID.time = dataInput.readLong();
        uID.count = dataInput.readShort();
        return uID;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.unique);
        dataOutput.writeLong(this.time);
        dataOutput.writeShort(this.count);
    }

    static int getMachineId() {
        int n;
        try {
            String string = InetAddress.getLocalHost().toString();
            n = string.hashCode();
        }
        catch (Exception exception) {
            n = 0;
        }
        return new Object().hashCode() ^ (int)System.currentTimeMillis() ^ n;
    }

    public String toString() {
        int n = 36;
        long l = this.count - Short.MIN_VALUE & 0xFFFF;
        return Long.toString(this.unique, n) + ":" + Long.toString(this.time, n) + "." + Long.toString(l, n);
    }

    static {
        machineId = UID.getMachineId();
    }
}

