/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.server.ActivatableServerRef;
import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.lang.reflect.Field;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activatable
extends RemoteServer {
    static final long serialVersionUID = -3120617863591563455L;
    final ActivationID id;

    protected Activatable(String string, MarshalledObject<?> marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(this.getClass().getName(), string, marshalledObject, bl);
        this.id = Activatable.obtainId(activationDesc);
        Activatable.exportObject((Remote)this, this.id, n);
    }

    protected Activatable(String string, MarshalledObject<?> marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(this.getClass().getName(), string, marshalledObject, bl);
        this.id = Activatable.obtainId(activationDesc);
        Activatable.exportObject((Remote)this, this.id, n);
    }

    protected Activatable(ActivationID activationID, int n) throws RemoteException {
        this.id = activationID;
        try {
            Activatable.exportObject((Remote)this, activationID, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RemoteException remoteException = new RemoteException("cannot export Activatable", exception);
            throw remoteException;
        }
    }

    protected Activatable(ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.id = activationID;
        try {
            Activatable.exportObject((Remote)this, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException();
            remoteException.initCause(exception);
            throw remoteException;
        }
    }

    protected ActivationID getID() {
        return this.id;
    }

    static ActivationID obtainId(ActivationDesc activationDesc) throws RemoteException, UnknownGroupException, ActivationException {
        ActivationGroupID activationGroupID = activationDesc.getGroupID();
        ActivationSystem activationSystem = activationGroupID != null ? activationGroupID.getSystem() : ActivationGroup.currentGroupID().getSystem();
        return activationSystem.registerObject(activationDesc);
    }

    public static Remote register(ActivationDesc activationDesc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID activationID = Activatable.obtainId(activationDesc);
        try {
            return Activatable.toStub(activationID, Thread.currentThread().getContextClassLoader().loadClass(activationDesc.getClassName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ActivationException("Class not found: " + activationDesc.getClassName());
        }
    }

    public static boolean inactive(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        if (activationID.group != null) {
            activationID.group.inactiveObject(activationID);
        }
        return UnicastRemoteObject.unexportObject(activationID.activate(false), false);
    }

    public static void unregister(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.currentGroupId.getSystem().unregisterObject(activationID);
        UnicastServer.unregisterActivatable(activationID);
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject<?> marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationID activationID = Activatable.obtainId(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n);
        return activationID;
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationID activationID = Activatable.obtainId(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
        return activationID;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n) throws RemoteException {
        Remote remote2 = Activatable.export(activationID, remote, n, null);
        return remote2;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        Remote remote2 = Activatable.export(activationID, remote, n, rMIServerSocketFactory);
        return remote2;
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        UnicastServerRef unicastServerRef = UnicastServer.getExportedRef(remote);
        if (unicastServerRef instanceof ActivatableServerRef) {
            ActivatableServerRef activatableServerRef = (ActivatableServerRef)unicastServerRef;
            UnicastServer.unregisterActivatable(activatableServerRef.actId);
        }
        return UnicastRemoteObject.unexportObject(remote, bl);
    }

    static Remote exportObject(Remote remote, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        UnicastServerRef unicastServerRef = null;
        if (remote instanceof RemoteObject) {
            unicastServerRef = (UnicastServerRef)((RemoteObject)remote).getRef();
        }
        if (unicastServerRef == null) {
            unicastServerRef = new UnicastServerRef(new ObjID(), n, rMIServerSocketFactory);
        }
        Remote remote2 = unicastServerRef.exportObject(remote);
        return remote2;
    }

    private static Remote export(ActivationID activationID, Remote remote, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        ActivatableServerRef activatableServerRef = null;
        activatableServerRef = new ActivatableServerRef(Activatable.makeId(activationID), activationID, n, rMIServerSocketFactory);
        return activatableServerRef.exportObject(remote);
    }

    private static ObjID makeId(ActivationID activationID) {
        ObjID objID = new ObjID(0);
        try {
            Field field = ObjID.class.getDeclaredField("space");
            Field field2 = ActivationID.class.getDeclaredField("uid");
            field2.setAccessible(true);
            field.setAccessible(true);
            field.set(objID, field2.get(activationID));
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to set UID field");
            internalError.initCause(exception);
            throw internalError;
        }
        return objID;
    }

    static Remote toStub(ActivationID activationID, Class clazz) {
        try {
            ActivatableServerRef activatableServerRef = new ActivatableServerRef(Activatable.makeId(activationID), activationID, 0, null);
            UnicastServer.exportActivatableObject(activatableServerRef);
            return activatableServerRef.exportClass(clazz);
        }
        catch (RemoteException remoteException) {
            InternalError internalError = new InternalError("Failed to obtain activatable stub");
            internalError.initCause(remoteException);
            throw internalError;
        }
    }
}

