/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import gnu.classpath.ServiceFactory;
import gnu.classpath.SystemProperties;
import gnu.java.nio.charset.Provider;
import gnu.java.nio.charset.iconv.IconvProvider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Charset
implements Comparable<Charset> {
    private CharsetEncoder cachedEncoder;
    private CharsetDecoder cachedDecoder;
    private static CharsetProvider[] providers;
    private final String canonicalName;
    private final String[] aliases;

    protected Charset(String string, String[] stringArray) {
        Charset.checkName(string);
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Charset.checkName(stringArray[i]);
            }
        }
        this.cachedEncoder = null;
        this.cachedDecoder = null;
        this.canonicalName = string;
        this.aliases = stringArray;
    }

    private static void checkName(String string) {
        int n = string.length();
        if (n == 0) {
            throw new IllegalCharsetNameException(string);
        }
        char c = string.charAt(0);
        if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
            throw new IllegalCharsetNameException(string);
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '.' || c == ':' || c == '_') continue;
            throw new IllegalCharsetNameException(string);
        }
    }

    public static Charset defaultCharset() {
        String string;
        try {
            string = SystemProperties.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            string = "ISO-8859-1";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "ISO-8859-1";
        }
        try {
            return Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalStateException("Can't get default charset!");
    }

    public static boolean isSupported(String string) {
        return Charset.charsetForName(string) != null;
    }

    public static Charset forName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Charset name must not be null.");
        }
        Charset charset = Charset.charsetForName(string);
        if (charset == null) {
            throw new UnsupportedCharsetException(string);
        }
        return charset;
    }

    private static Charset charsetForName(String string) {
        Charset.checkName(string);
        Charset charset = Charset.provider().charsetForName(string);
        if (charset == null) {
            CharsetProvider[] charsetProviderArray = Charset.providers2();
            for (int i = 0; i < charsetProviderArray.length && (charset = charsetProviderArray[i].charsetForName(string)) == null; ++i) {
            }
        }
        return charset;
    }

    public static SortedMap<String, Charset> availableCharsets() {
        TreeMap<String, Charset> treeMap = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        CharsetProvider[] charsetProviderArray = Charset.provider().charsets();
        while (charsetProviderArray.hasNext()) {
            Charset charset = charsetProviderArray.next();
            treeMap.put(charset.name(), charset);
        }
        charsetProviderArray = Charset.providers2();
        for (int i = 0; i < charsetProviderArray.length; ++i) {
            Iterator<Charset> iterator = charsetProviderArray[i].charsets();
            while (iterator.hasNext()) {
                Charset charset = iterator.next();
                treeMap.put(charset.name(), charset);
            }
        }
        return Collections.unmodifiableSortedMap(treeMap);
    }

    private static CharsetProvider provider() {
        String string = SystemProperties.getProperty("gnu.classpath.nio.charset.provider.iconv");
        if (string != null) {
            return IconvProvider.provider();
        }
        return Provider.provider();
    }

    private static CharsetProvider[] providers2() {
        if (providers == null) {
            try {
                Iterator<CharsetProvider> iterator = ServiceFactory.lookupProviders(CharsetProvider.class);
                LinkedHashSet<CharsetProvider> linkedHashSet = new LinkedHashSet<CharsetProvider>();
                while (iterator.hasNext()) {
                    linkedHashSet.add(iterator.next());
                }
                providers = new CharsetProvider[linkedHashSet.size()];
                linkedHashSet.toArray(providers);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return providers;
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set<String> aliases() {
        if (this.aliases == null) {
            return Collections.emptySet();
        }
        int n = this.aliases.length;
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(this.aliases[i]);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String displayName() {
        return this.canonicalName;
    }

    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return !this.canonicalName.startsWith("x-") && !this.canonicalName.startsWith("X-");
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final synchronized ByteBuffer encode(CharBuffer charBuffer) {
        try {
            if (this.cachedEncoder == null) {
                this.cachedEncoder = this.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                this.cachedEncoder.reset();
            }
            return this.cachedEncoder.encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new AssertionError((Object)characterCodingException);
        }
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    public final synchronized CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            if (this.cachedDecoder == null) {
                this.cachedDecoder = this.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            } else {
                this.cachedDecoder.reset();
            }
            return this.cachedDecoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new AssertionError((Object)characterCodingException);
        }
    }

    @Override
    public final int compareTo(Charset charset) {
        return this.canonicalName.compareToIgnoreCase(charset.canonicalName);
    }

    public final int hashCode() {
        return this.canonicalName.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof Charset) {
            return this.canonicalName.equalsIgnoreCase(((Charset)object).canonicalName);
        }
        return false;
    }

    public final String toString() {
        return this.canonicalName;
    }
}

