/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.java.nio.ChannelInputStream;
import gnu.java.nio.ChannelOutputStream;
import gnu.java.nio.FileChannelImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

final class VMChannels {
    private VMChannels() {
    }

    private static Object createStream(Class clazz, Channel channel) {
        try {
            Class[] classArray = new Class[]{FileChannelImpl.class};
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            constructor.setAccessible(true);
            Object[] objectArray = new Object[]{channel};
            return constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        if (readableByteChannel instanceof FileChannelImpl) {
            return (FileInputStream)VMChannels.createStream(FileInputStream.class, readableByteChannel);
        }
        return new ChannelInputStream(readableByteChannel);
    }

    static OutputStream newOutputStream(WritableByteChannel writableByteChannel) {
        if (writableByteChannel instanceof FileChannelImpl) {
            return (FileOutputStream)VMChannels.createStream(FileOutputStream.class, writableByteChannel);
        }
        return new ChannelOutputStream(writableByteChannel);
    }
}

