/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.nio.channels.FileChannel;

public abstract class FileLock {
    private final FileChannel channel;
    private final long position;
    private final long size;
    private final boolean shared;

    protected FileLock(FileChannel fileChannel, long l, long l2, boolean bl) {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.channel = fileChannel;
        this.position = l;
        this.size = l2;
        this.shared = bl;
    }

    public abstract boolean isValid();

    public abstract void release() throws IOException;

    public final FileChannel channel() {
        return this.channel;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public final boolean overlaps(long l, long l2) {
        if (l > this.position + this.size) {
            return false;
        }
        return l + l2 >= this.position;
    }

    public final long position() {
        return this.position;
    }

    public final long size() {
        return this.size;
    }

    public final String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.getClass().getName());
        cPStringBuilder.append("[");
        cPStringBuilder.append(this.position);
        cPStringBuilder.append(":");
        cPStringBuilder.append(this.size);
        if (this.shared) {
            cPStringBuilder.append(" shared");
        } else {
            cPStringBuilder.append(" exclusive");
        }
        if (this.isValid()) {
            cPStringBuilder.append(" valid]");
        } else {
            cPStringBuilder.append(" invalid]");
        }
        return cPStringBuilder.toString();
    }
}

