/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.VMDirectByteBuffer;

final class ShortViewBufferImpl
extends ShortBuffer {
    private final int offset;
    private final ByteBuffer bb;
    private final boolean readOnly;
    private final ByteOrder endian;

    ShortViewBufferImpl(ByteBuffer byteBuffer, int n) {
        super(n, n, 0, -1, byteBuffer.isDirect() ? VMDirectByteBuffer.adjustAddress(byteBuffer.address, byteBuffer.position()) : null, null, 0);
        this.bb = byteBuffer;
        this.offset = byteBuffer.position();
        this.readOnly = byteBuffer.isReadOnly();
        this.endian = byteBuffer.order();
    }

    public ShortViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, ByteOrder byteOrder) {
        super(n2, n3, n4, n5, byteBuffer.isDirect() ? VMDirectByteBuffer.adjustAddress(byteBuffer.address, n) : null, null, 0);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteOrder;
    }

    public short get() {
        int n = this.position();
        short s = ByteBufferHelper.getShort(this.bb, (n << 1) + this.offset, this.endian);
        this.position(n + 1);
        return s;
    }

    public short get(int n) {
        return ByteBufferHelper.getShort(this.bb, (n << 1) + this.offset, this.endian);
    }

    public ShortBuffer put(short s) {
        int n = this.position();
        ByteBufferHelper.putShort(this.bb, (n << 1) + this.offset, s, this.endian);
        this.position(n + 1);
        return this;
    }

    public ShortBuffer put(int n, short s) {
        ByteBufferHelper.putShort(this.bb, (n << 1) + this.offset, s, this.endian);
        return this;
    }

    public ShortBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 2 * this.position(), 2 * n);
            this.position(n);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public ShortBuffer slice() {
        return new ShortViewBufferImpl(this.bb, (this.position() << 1) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    ShortBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        return new ShortViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), n, n2, bl, this.endian);
    }

    public ShortBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

