/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.ShortBuffer;

final class ShortBufferImpl
extends ShortBuffer {
    private final boolean readOnly;

    ShortBufferImpl(int n) {
        this(new short[n], 0, n, n, 0, -1, false);
    }

    ShortBufferImpl(short[] sArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5, null, sArray, n);
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ShortBuffer slice() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public ShortBuffer duplicate() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public ShortBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        int n2 = this.limit() - n;
        if (n2 > 0) {
            System.arraycopy(this.backing_buffer, this.array_offset + n, this.backing_buffer, this.array_offset, n2);
        }
        this.position(n2);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public short get() {
        this.checkForUnderflow();
        short s = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return s;
    }

    public ShortBuffer put(short s) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = s;
        this.position(this.position() + 1);
        return this;
    }

    public short get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public ShortBuffer put(int n, short s) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = s;
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

