/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharSequenceBuffer
extends CharBuffer {
    private final CharSequence charSequence;

    CharSequenceBuffer(CharSequence charSequence, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, null, null, n5);
        this.charSequence = charSequence;
    }

    CharSequenceBuffer(CharSequence charSequence, int n, int n2) {
        this(charSequence, charSequence.length(), n2, n, -1, 0);
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer duplicate() {
        return new CharSequenceBuffer(this.charSequence, this.capacity(), this.limit, this.pos, this.mark, 0);
    }

    public char get() {
        if (this.pos >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.charSequence.charAt(this.array_offset + this.pos++);
    }

    public char get(int n) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.charSequence.charAt(this.array_offset + n);
    }

    public boolean isDirect() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer put(int n, char c) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer slice() {
        int n = this.limit - this.pos;
        return new CharSequenceBuffer(this.charSequence, n, n, 0, -1, this.pos);
    }

    public CharSequence subSequence(int n, int n2) {
        int n3 = this.array_offset + n + this.pos;
        return this.charSequence.subSequence(n3, n3 + n2);
    }

    public boolean isReadOnly() {
        return true;
    }
}

