/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.lang.CPStringBuilder;
import gnu.java.net.loader.FileURLLoader;
import gnu.java.net.loader.JarURLLoader;
import gnu.java.net.loader.RemoteURLLoader;
import gnu.java.net.loader.Resource;
import gnu.java.net.loader.URLLoader;
import gnu.java.net.loader.URLStreamHandlerCache;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends SecureClassLoader {
    private static URLStreamHandlerCache factoryCache = new URLStreamHandlerCache();
    private static final String URL_LOADER_PREFIX = "gnu.java.net.loader.Load_";
    private final Vector<URL> urls = new Vector();
    private final Vector<URLLoader> urlinfos = new Vector();
    private final URLStreamHandlerFactory factory;
    private final AccessControlContext securityContext;
    private String thisString;

    public URLClassLoader(URL[] uRLArray) throws SecurityException {
        this.factory = null;
        this.securityContext = null;
        this.addURLs(uRLArray);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) throws SecurityException {
        super(classLoader);
        this.factory = null;
        this.securityContext = null;
        this.addURLs(uRLArray);
    }

    URLClassLoader(ClassLoader classLoader, AccessControlContext accessControlContext) {
        super(classLoader);
        this.factory = null;
        this.securityContext = accessControlContext;
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws SecurityException {
        super(classLoader);
        this.securityContext = null;
        this.factory = uRLStreamHandlerFactory;
        factoryCache.add(uRLStreamHandlerFactory);
        this.addURLs(uRLArray);
    }

    protected void addURL(URL uRL) {
        this.urls.add(uRL);
        this.addURLImpl(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addURLImpl(URL uRL) {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            URL uRL2;
            Serializable serializable;
            if (uRL == null) {
                return;
            }
            this.thisString = null;
            URLLoader uRLLoader = null;
            String string = uRL.getFile();
            String string2 = uRL.getProtocol();
            if ("file".equals(string2)) {
                serializable = new File(string);
                try {
                    uRL2 = ((File)serializable).getCanonicalFile().toURL();
                }
                catch (IOException iOException) {
                    try {
                        uRL2 = ((File)serializable).getAbsoluteFile().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL2 = uRL;
                    }
                }
            } else {
                uRL2 = uRL;
            }
            try {
                serializable = Class.forName(URL_LOADER_PREFIX + string2);
                Class[] classArray = new Class[]{URLClassLoader.class, URLStreamHandlerCache.class, URLStreamHandlerFactory.class, URL.class, URL.class};
                Constructor constructor = ((Class)serializable).getDeclaredConstructor(classArray);
                uRLLoader = (URLLoader)constructor.newInstance(this, factoryCache, this.factory, uRL, uRL2);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                InternalError internalError = new InternalError("couldn't find URLLoader constructor");
                internalError.initCause(noSuchMethodException);
                throw internalError;
            }
            catch (InstantiationException instantiationException) {
                InternalError internalError = new InternalError("couldn't instantiate URLLoader");
                internalError.initCause(instantiationException);
                throw internalError;
            }
            catch (InvocationTargetException invocationTargetException) {
                InternalError internalError = new InternalError("error instantiating URLLoader");
                internalError.initCause(invocationTargetException);
                throw internalError;
            }
            catch (IllegalAccessException illegalAccessException) {
                InternalError internalError = new InternalError("invalid access to URLLoader");
                internalError.initCause(illegalAccessException);
                throw internalError;
            }
            if (uRLLoader == null) {
                uRLLoader = !string.endsWith("/") && !string.endsWith(File.separator) ? new JarURLLoader(this, factoryCache, this.factory, uRL, uRL2) : ("file".equals(string2) ? new FileURLLoader(this, factoryCache, this.factory, uRL, uRL2) : new RemoteURLLoader(this, factoryCache, this.factory, uRL));
            }
            this.urlinfos.add(uRLLoader);
            serializable = uRLLoader.getClassPath();
            if (serializable != null) {
                this.urlinfos.addAll((Collection<URLLoader>)((Object)serializable));
            }
        }
    }

    private void addURLs(URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            this.urls.add(uRLArray[i]);
            this.addURLImpl(uRLArray[i]);
        }
    }

    private String getAttributeValue(Attributes.Name name, Attributes attributes, Attributes attributes2) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(string);
        for (int i = cPStringBuilder.length() - 1; i >= 0; --i) {
            if (cPStringBuilder.charAt(i) != '.') continue;
            cPStringBuilder.setCharAt(i, '/');
        }
        cPStringBuilder.append('/');
        String string2 = cPStringBuilder.toString();
        Attributes attributes = manifest.getAttributes(string2);
        Attributes attributes2 = manifest.getMainAttributes();
        String string3 = this.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, attributes, attributes2);
        String string4 = this.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, attributes, attributes2);
        String string5 = this.getAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, attributes, attributes2);
        String string6 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, attributes, attributes2);
        String string7 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, attributes, attributes2);
        String string8 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VENDOR, attributes, attributes2);
        String string9 = attributes2.getValue(Attributes.Name.SEALED);
        if ("false".equals(string9)) {
            uRL = null;
        }
        return this.definePackage(string, string3, string5, string4, string6, string8, string7, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(final String string) throws ClassNotFoundException {
        Object object;
        String string2 = string.replace('.', '/') + ".class";
        int n = this.urlinfos.size();
        Resource resource = null;
        for (int i = 0; i < n && resource == null; ++i) {
            object = this.urlinfos.elementAt(i);
            if (object == null) continue;
            Class clazz = ((URLLoader)object).getClass(string);
            if (clazz != null) {
                return clazz;
            }
            resource = ((URLLoader)object).getResource(string2);
        }
        if (resource == null) {
            throw new ClassNotFoundException(string + " not found in " + this);
        }
        try {
            Object object2;
            Class clazz;
            int n2;
            byte[] byArray;
            object = resource.getInputStream();
            try {
                int n3 = resource.getLength();
                if (n3 != -1) {
                    byArray = new byte[n3];
                    int n4 = 0;
                    while (n3 - n4 > 0) {
                        int n5 = ((InputStream)object).read(byArray, n4, n3 - n4);
                        if (n5 == -1) {
                            throw new EOFException("Not enough data reading from: " + object);
                        }
                        n4 += n5;
                    }
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
                    byte[] byArray2 = new byte[4096];
                    n2 = 0;
                    while (n2 != -1) {
                        n2 = ((InputStream)object).read(byArray2);
                        if (n2 == -1) continue;
                        byteArrayOutputStream.write(byArray2, 0, n2);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                clazz = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                ((InputStream)object).close();
                throw throwable;
            }
            ((InputStream)object).close();
            final byte[] byArray3 = byArray;
            final CodeSource codeSource = resource.getCodeSource();
            String string3 = null;
            n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string3 = string.substring(0, n2);
            }
            if (string3 != null && this.getPackage(string3) == null) {
                object2 = resource.getLoader().getManifest();
                if (object2 == null) {
                    this.definePackage(string3, null, null, null, null, null, null, null);
                } else {
                    this.definePackage(string3, (Manifest)object2, resource.getLoader().getBaseURL());
                }
            }
            object2 = System.getSecurityManager();
            clazz = null;
            clazz = object2 != null && this.securityContext != null ? AccessController.doPrivileged(new PrivilegedAction<Class>(){

                @Override
                public Class run() {
                    return URLClassLoader.this.defineClass(string, byArray3, 0, byArray3.length, codeSource);
                }
            }, this.securityContext) : this.defineClass(string, byArray3, 0, byArray3.length, codeSource);
            Object[] objectArray = resource.getCertificates();
            if (objectArray != null) {
                super.setSigners(clazz, objectArray);
            }
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string + " not found in " + this, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            if (this.thisString == null) {
                CPStringBuilder cPStringBuilder = new CPStringBuilder();
                cPStringBuilder.append(this.getClass().getName());
                cPStringBuilder.append("{urls=[");
                URL[] uRLArray = this.getURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    cPStringBuilder.append(uRLArray[i]);
                    if (i >= uRLArray.length - 1) continue;
                    cPStringBuilder.append(',');
                }
                cPStringBuilder.append(']');
                cPStringBuilder.append(", parent=");
                cPStringBuilder.append(this.getParent());
                cPStringBuilder.append('}');
                this.thisString = cPStringBuilder.toString();
            }
            return this.thisString;
        }
    }

    private Resource findURLResource(String string) {
        int n = this.urlinfos.size();
        for (int i = 0; i < n; ++i) {
            Resource resource;
            URLLoader uRLLoader = this.urlinfos.elementAt(i);
            if (uRLLoader == null || (resource = uRLLoader.getResource(string)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public URL findResource(String string) {
        Resource resource = this.findURLResource(string);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>();
        int n = this.urlinfos.size();
        for (int i = 0; i < n; ++i) {
            URLLoader uRLLoader = this.urlinfos.elementAt(i);
            Resource resource = uRLLoader.getResource(string);
            if (resource == null) continue;
            vector.add(resource.getURL());
        }
        return vector.elements();
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            String string2 = uRL.getFile();
            if (string2.endsWith("/") || string2.endsWith(File.separator)) {
                permissionCollection.add(new FilePermission(string2 + "-", "read"));
            } else {
                permissionCollection.add(new FilePermission(string2, "read"));
            }
        } else {
            String string3 = uRL.getHost();
            if (string3 != null) {
                permissionCollection.add(new SocketPermission(string3, "connect,accept"));
            }
        }
        return permissionCollection;
    }

    public URL[] getURLs() {
        return this.urls.toArray((S[])new URL[this.urls.size()]);
    }

    public static URLClassLoader newInstance(URL[] uRLArray) throws SecurityException {
        return URLClassLoader.newInstance(uRLArray, null);
    }

    public static URLClassLoader newInstance(URL[] uRLArray, final ClassLoader classLoader) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return new URLClassLoader(uRLArray, classLoader);
        }
        final Object object = securityManager.getSecurityContext();
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException("securityContext must be AccessControlContext: " + object);
        }
        URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(classLoader, (AccessControlContext)object);
            }
        });
        uRLClassLoader.addURLs(uRLArray);
        return uRLClassLoader;
    }
}

