/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.VMNetworkInterface;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkInterface {
    private final VMNetworkInterface netif;

    private NetworkInterface(VMNetworkInterface vMNetworkInterface) {
        this.netif = vMNetworkInterface;
    }

    static NetworkInterface createAnyInterface() {
        return new NetworkInterface(new VMNetworkInterface());
    }

    public String getName() {
        return this.netif.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        SecurityManager securityManager = System.getSecurityManager();
        Vector vector = new Vector(this.netif.addresses);
        if (securityManager == null) {
            return vector.elements();
        }
        Vector<InetAddress> vector2 = new Vector<InetAddress>(1, 1);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            try {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
                vector2.add(inetAddress);
            }
            catch (SecurityException securityException) {}
        }
        return vector2.elements();
    }

    public String getDisplayName() {
        return this.netif.name;
    }

    public static NetworkInterface getByName(String string) throws SocketException {
        if (string == null) {
            throw new NullPointerException();
        }
        VMNetworkInterface[] vMNetworkInterfaceArray = VMNetworkInterface.getVMInterfaces();
        for (int i = 0; i < vMNetworkInterfaceArray.length; ++i) {
            if (!vMNetworkInterfaceArray[i].name.equals(string)) continue;
            return new NetworkInterface(vMNetworkInterfaceArray[i]);
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress inetAddress) throws SocketException {
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        VMNetworkInterface[] vMNetworkInterfaceArray = VMNetworkInterface.getVMInterfaces();
        for (int i = 0; i < vMNetworkInterfaceArray.length; ++i) {
            if (!vMNetworkInterfaceArray[i].addresses.contains(inetAddress)) continue;
            return new NetworkInterface(vMNetworkInterfaceArray[i]);
        }
        return null;
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        VMNetworkInterface[] vMNetworkInterfaceArray = VMNetworkInterface.getVMInterfaces();
        Vector<NetworkInterface> vector = new Vector<NetworkInterface>(vMNetworkInterfaceArray.length);
        for (int i = 0; i < vMNetworkInterfaceArray.length; ++i) {
            if (vMNetworkInterfaceArray[i].addresses.isEmpty()) continue;
            vector.add(new NetworkInterface(vMNetworkInterfaceArray[i]));
        }
        return vector.elements();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface networkInterface = (NetworkInterface)object;
        if (this.netif.name == null) {
            return networkInterface.netif.name == null;
        }
        return this.netif.name.equals(networkInterface.netif.name) && this.netif.addresses.equals(networkInterface.netif.addresses);
    }

    public int hashCode() {
        int n = this.netif.addresses.hashCode();
        if (this.netif.name != null) {
            n += this.netif.name.hashCode();
        }
        return n;
    }

    public String toString() {
        String string = SystemProperties.getProperty("line.separator");
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append("name: ");
        cPStringBuilder.append(this.getDisplayName());
        cPStringBuilder.append(" (").append(this.getName()).append(") addresses:");
        cPStringBuilder.append(string);
        for (InetAddress inetAddress : this.netif.addresses) {
            cPStringBuilder.append(inetAddress.toString()).append(";").append(string);
        }
        return cPStringBuilder.toString();
    }

    public boolean isUp() throws SocketException {
        return VMNetworkInterface.isUp(this.netif.name);
    }

    public boolean isPointToPoint() throws SocketException {
        return VMNetworkInterface.isPointToPoint(this.netif.name);
    }

    public boolean isLoopback() throws SocketException {
        return VMNetworkInterface.isLoopback(this.netif.name);
    }

    public boolean supportsMulticast() throws SocketException {
        return VMNetworkInterface.supportsMulticast(this.netif.name);
    }
}

