/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import gnu.java.lang.CPStringBuilder;
import gnu.java.math.GMP;
import gnu.java.math.MPN;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigInteger
extends Number
implements Comparable<BigInteger> {
    private static final Logger log = null;
    private transient int ival;
    private transient int[] words;
    private int bitCount = -1;
    private int bitLength = -1;
    private int lowestSetBit = -2;
    private byte[] magnitude;
    private int signum;
    private static final long serialVersionUID = -8287574255936472291L;
    private static final int minFixNum = -100;
    private static final int maxFixNum = 1024;
    private static final int numFixNum = 1125;
    private static final BigInteger[] smallFixNums;
    private transient GMP mpz;
    private static final boolean USING_NATIVE;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    public static final BigInteger TEN;
    private static final int FLOOR = 1;
    private static final int CEILING = 2;
    private static final int TRUNCATE = 3;
    private static final int ROUND = 4;
    private static final int[] primes;
    private static final int[] k;
    private static final int[] t;
    private static final byte[] bit4_count;

    private BigInteger() {
        if (USING_NATIVE) {
            this.mpz = new GMP();
        }
    }

    private BigInteger(int n) {
        this.ival = n;
    }

    public BigInteger(String string, int n) {
        this();
        byte[] byArray;
        int n2;
        boolean bl;
        int n3 = string.length();
        char c = string.charAt(0);
        if (c == '-') {
            bl = true;
            n2 = 1;
            byArray = new byte[n3 - 1];
        } else {
            bl = false;
            n2 = 0;
            byArray = new byte[n3];
        }
        int n4 = 0;
        while (n2 < n3) {
            c = string.charAt(n2);
            int n5 = Character.digit(c, n);
            if (n5 < 0) {
                throw new NumberFormatException("Invalid character at position #" + n2);
            }
            byArray[n4++] = (byte)n5;
            ++n2;
        }
        if (USING_NATIVE) {
            byArray = null;
            if (this.mpz.fromString(string, n) != 0) {
                throw new NumberFormatException("String \"" + string + "\" is NOT a valid number in base " + n);
            }
        } else {
            BigInteger bigInteger = n3 <= 15 && n <= 16 ? BigInteger.valueOf(Long.parseLong(string, n)) : BigInteger.valueOf(byArray, n4, bl, n);
            this.ival = bigInteger.ival;
            this.words = bigInteger.words;
        }
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(byte[] byArray) {
        this();
        if (byArray == null || byArray.length < 1) {
            throw new NumberFormatException();
        }
        if (USING_NATIVE) {
            this.mpz.fromByteArray(byArray);
        } else {
            this.words = BigInteger.byteArrayToIntArray(byArray, byArray[0] < 0 ? -1 : 0);
            BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
            this.ival = bigInteger.ival;
            this.words = bigInteger.words;
        }
    }

    public BigInteger(int n, byte[] byArray) {
        this();
        if (byArray == null || n > 1 || n < -1) {
            throw new NumberFormatException();
        }
        if (n == 0) {
            int n2;
            for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
            }
            if (n2 >= 0) {
                throw new NumberFormatException();
            }
            return;
        }
        if (USING_NATIVE) {
            this.mpz.fromSignedMagnitude(byArray, n == -1);
        } else {
            this.words = BigInteger.byteArrayToIntArray(byArray, 0);
            BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
            this.ival = bigInteger.ival;
            this.words = bigInteger.words;
            if (n < 0) {
                this.setNegative();
            }
        }
    }

    public BigInteger(int n, Random random) {
        this();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.init(n, random);
    }

    private void init(int n, Random random) {
        int n2;
        if (USING_NATIVE) {
            int n3 = (n + 7) / 8;
            byte[] byArray = new byte[n3];
            random.nextBytes(byArray);
            int n4 = n % 8;
            if (n4 != 0) {
                n4 = 8 - n4;
                byArray[0] = (byte)((byArray[0] & 0xFF) >>> n4);
            }
            this.mpz.fromSignedMagnitude(byArray, false);
            byArray = null;
            return;
        }
        int n5 = n & 0x1F;
        int n6 = (n5 + 7) / 8;
        int n7 = n5 % 8;
        if (n7 != 0) {
            n7 = 8 - n7;
        }
        byte[] byArray = new byte[n6];
        if (n5 > 0) {
            random.nextBytes(byArray);
            n5 = (byArray[n6 - 1] & 0xFF) >>> n7;
            for (n2 = n6 - 2; n2 >= 0; --n2) {
                n5 = n5 << 8 | byArray[n2] & 0xFF;
            }
        }
        for (n2 = n / 32; n5 == 0 && n2 > 0; --n2) {
            n5 = random.nextInt();
        }
        if (n2 == 0 && n5 >= 0) {
            this.ival = n5;
        } else {
            this.ival = n5 < 0 ? n2 + 2 : n2 + 1;
            this.words = new int[this.ival];
            this.words[n2] = n5;
            while (--n2 >= 0) {
                this.words[n2] = random.nextInt();
            }
        }
    }

    public BigInteger(int n, int n2, Random random) {
        this();
        BigInteger bigInteger = new BigInteger();
        do {
            bigInteger.init(n, random);
        } while (!(bigInteger = bigInteger.setBit(n - 1)).isProbablePrime(n2));
        if (USING_NATIVE) {
            this.mpz.fromBI(bigInteger.mpz);
        } else {
            this.ival = bigInteger.ival;
            this.words = bigInteger.words;
        }
    }

    public static BigInteger probablePrime(int n, Random random) {
        if (n < 2) {
            throw new ArithmeticException();
        }
        return new BigInteger(n, 100, random);
    }

    public static BigInteger valueOf(long l) {
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            bigInteger.mpz.fromLong(l);
            return bigInteger;
        }
        if (l >= -100L && l <= 1024L) {
            return smallFixNums[(int)l - -100];
        }
        int n = (int)l;
        if ((long)n == l) {
            return new BigInteger(n);
        }
        BigInteger bigInteger = BigInteger.alloc(2);
        bigInteger.ival = 2;
        bigInteger.words[0] = n;
        bigInteger.words[1] = (int)(l >> 32);
        return bigInteger;
    }

    private static boolean initializeLibrary() {
        boolean bl;
        try {
            System.loadLibrary("javamath");
            GMP.natInitializeLibrary();
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private static BigInteger make(int[] nArray, int n) {
        if (nArray == null) {
            return BigInteger.valueOf(n);
        }
        if ((n = BigInteger.wordsNeeded(nArray, n)) <= 1) {
            return n == 0 ? ZERO : BigInteger.valueOf(nArray[0]);
        }
        BigInteger bigInteger = new BigInteger();
        bigInteger.words = nArray;
        bigInteger.ival = n;
        return bigInteger;
    }

    private static int[] byteArrayToIntArray(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length / 4 + 1];
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        int n5 = byArray.length % 4;
        while (n5 > 0) {
            n4 = n4 << 8 | byArray[n3] & 0xFF;
            --n5;
            ++n3;
        }
        nArray[--n2] = n4;
        while (n2 > 0) {
            nArray[--n2] = byArray[n3++] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
        return nArray;
    }

    private static BigInteger alloc(int n) {
        BigInteger bigInteger = new BigInteger();
        if (n > 1) {
            bigInteger.words = new int[n];
        }
        return bigInteger;
    }

    private void realloc(int n) {
        if (n == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < n || this.words.length > n + 2) {
            int[] nArray = new int[n];
            if (this.words == null) {
                nArray[0] = this.ival;
                this.ival = 1;
            } else {
                if (n < this.ival) {
                    this.ival = n;
                }
                System.arraycopy(this.words, 0, nArray, 0, this.ival);
            }
            this.words = nArray;
        }
    }

    private boolean isNegative() {
        return (this.words == null ? this.ival : this.words[this.ival - 1]) < 0;
    }

    public int signum() {
        if (USING_NATIVE) {
            return this.mpz.compare(BigInteger.ZERO.mpz);
        }
        if (this.ival == 0 && this.words == null) {
            return 0;
        }
        int n = this.words == null ? this.ival : this.words[this.ival - 1];
        return n < 0 ? -1 : 1;
    }

    private static int compareTo(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        boolean bl;
        if (USING_NATIVE) {
            int n2 = bigInteger2.signum;
            return bigInteger.mpz.compare(bigInteger2.mpz);
        }
        if (bigInteger.words == null && bigInteger2.words == null) {
            return bigInteger.ival < bigInteger2.ival ? -1 : (bigInteger.ival > bigInteger2.ival ? 1 : 0);
        }
        boolean bl2 = bigInteger.isNegative();
        if (bl2 != (bl = bigInteger2.isNegative())) {
            return bl2 ? -1 : 1;
        }
        int n3 = bigInteger.words == null ? 1 : bigInteger.ival;
        int n4 = n = bigInteger2.words == null ? 1 : bigInteger2.ival;
        if (n3 != n) {
            return n3 > n != bl2 ? 1 : -1;
        }
        return MPN.cmp(bigInteger.words, bigInteger2.words, n3);
    }

    @Override
    public int compareTo(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger);
    }

    public BigInteger min(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger) < 0 ? this : bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger) > 0 ? this : bigInteger;
    }

    private boolean isZero() {
        return this.words == null && this.ival == 0;
    }

    private boolean isOne() {
        return this.words == null && this.ival == 1;
    }

    private static int wordsNeeded(int[] nArray, int n) {
        int n2;
        block4: {
            int n3;
            n2 = n;
            if (n2 <= 0) break block4;
            if ((n3 = nArray[--n2]) == -1) {
                while (n2 > 0 && (n3 = nArray[n2 - 1]) < 0) {
                    --n2;
                    if (n3 == -1) continue;
                    break;
                }
            } else {
                while (n3 == 0 && n2 > 0 && (n3 = nArray[n2 - 1]) >= 0) {
                    --n2;
                }
            }
        }
        return n2 + 1;
    }

    private BigInteger canonicalize() {
        if (this.words != null && (this.ival = BigInteger.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    private static BigInteger add(int n, int n2) {
        return BigInteger.valueOf((long)n + (long)n2);
    }

    private static BigInteger add(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger.ival, n);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setAdd(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    private void setAdd(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            this.set((long)bigInteger.ival + (long)n);
            return;
        }
        int n2 = bigInteger.ival;
        this.realloc(n2 + 1);
        long l = n;
        for (int i = 0; i < n2; ++i) {
            this.words[i] = (int)(l += (long)bigInteger.words[i] & 0xFFFFFFFFL);
            l >>= 32;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            --l;
        }
        this.words[n2] = (int)l;
        this.ival = BigInteger.wordsNeeded(this.words, n2 + 1);
    }

    private void setAdd(int n) {
        this.setAdd(this, n);
    }

    private void set(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.ival = n;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = n;
            this.words[1] = (int)(l >> 32);
            this.ival = 2;
        }
    }

    private void set(int[] nArray, int n) {
        this.ival = n;
        this.words = nArray;
    }

    private void set(BigInteger bigInteger) {
        if (bigInteger.words == null) {
            this.set(bigInteger.ival);
        } else if (this != bigInteger) {
            this.realloc(bigInteger.ival);
            System.arraycopy(bigInteger.words, 0, this.words, 0, bigInteger.ival);
            this.ival = bigInteger.ival;
        }
    }

    private static BigInteger add(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        long l;
        int n2;
        BigInteger bigInteger3;
        if (bigInteger.words == null && bigInteger2.words == null) {
            return BigInteger.valueOf((long)n * (long)bigInteger2.ival + (long)bigInteger.ival);
        }
        if (n != 1) {
            bigInteger2 = n == -1 ? BigInteger.neg(bigInteger2) : BigInteger.times(bigInteger2, BigInteger.valueOf(n));
        }
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger2, bigInteger.ival);
        }
        if (bigInteger2.words == null) {
            return BigInteger.add(bigInteger, bigInteger2.ival);
        }
        if (bigInteger2.ival > bigInteger.ival) {
            bigInteger3 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger3;
        }
        bigInteger3 = BigInteger.alloc(bigInteger.ival + 1);
        long l2 = MPN.add_n(bigInteger3.words, bigInteger.words, bigInteger2.words, n2);
        long l3 = l = bigInteger2.words[n2 - 1] < 0 ? 0xFFFFFFFFL : 0L;
        for (n2 = bigInteger2.ival; n2 < bigInteger.ival; ++n2) {
            bigInteger3.words[n2] = (int)(l2 += ((long)bigInteger.words[n2] & 0xFFFFFFFFL) + l);
            l2 >>>= 32;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            --l;
        }
        bigInteger3.words[n2] = (int)(l2 + l);
        bigInteger3.ival = n2 + 1;
        return bigInteger3.canonicalize();
    }

    public BigInteger add(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.add(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        return BigInteger.add(this, bigInteger, 1);
    }

    public BigInteger subtract(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.subtract(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        return BigInteger.add(this, bigInteger, -1);
    }

    private static BigInteger times(BigInteger bigInteger, int n) {
        boolean bl;
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return bigInteger;
        }
        int[] nArray = bigInteger.words;
        int n2 = bigInteger.ival;
        if (nArray == null) {
            return BigInteger.valueOf((long)n2 * (long)n);
        }
        BigInteger bigInteger2 = BigInteger.alloc(n2 + 1);
        if (nArray[n2 - 1] < 0) {
            bl = true;
            BigInteger.negate(bigInteger2.words, nArray, n2);
            nArray = bigInteger2.words;
        } else {
            bl = false;
        }
        if (n < 0) {
            bl = !bl;
            n = -n;
        }
        bigInteger2.words[n2] = MPN.mul_1(bigInteger2.words, nArray, n2, n);
        bigInteger2.ival = n2 + 1;
        if (bl) {
            bigInteger2.setNegative();
        }
        return bigInteger2.canonicalize();
    }

    private static BigInteger times(BigInteger bigInteger, BigInteger bigInteger2) {
        Object object;
        int[] nArray;
        int[] nArray2;
        if (bigInteger2.words == null) {
            return BigInteger.times(bigInteger, bigInteger2.ival);
        }
        if (bigInteger.words == null) {
            return BigInteger.times(bigInteger2, bigInteger.ival);
        }
        boolean bl = false;
        int n = bigInteger.ival;
        int n2 = bigInteger2.ival;
        if (bigInteger.isNegative()) {
            bl = true;
            nArray2 = new int[n];
            BigInteger.negate(nArray2, bigInteger.words, n);
        } else {
            bl = false;
            nArray2 = bigInteger.words;
        }
        if (bigInteger2.isNegative()) {
            bl = !bl;
            nArray = new int[n2];
            BigInteger.negate(nArray, bigInteger2.words, n2);
        } else {
            nArray = bigInteger2.words;
        }
        if (n < n2) {
            object = nArray2;
            nArray2 = nArray;
            nArray = object;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        object = BigInteger.alloc(n + n2);
        MPN.mul(((BigInteger)object).words, nArray2, n, nArray, n2);
        ((BigInteger)object).ival = n + n2;
        if (bl) {
            super.setNegative();
        }
        return super.canonicalize();
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.multiply(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        return BigInteger.times(this, bigInteger);
    }

    private static void divide(long l, long l2, BigInteger bigInteger, BigInteger bigInteger2, int n) {
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            bl2 = true;
            if (l == Long.MIN_VALUE) {
                BigInteger.divide(BigInteger.valueOf(l), BigInteger.valueOf(l2), bigInteger, bigInteger2, n);
                return;
            }
            l = -l;
        } else {
            bl2 = false;
        }
        if (l2 < 0L) {
            bl = true;
            if (l2 == Long.MIN_VALUE) {
                if (n == 3) {
                    if (bigInteger != null) {
                        bigInteger.set(0L);
                    }
                    if (bigInteger2 != null) {
                        bigInteger2.set(l);
                    }
                } else {
                    BigInteger.divide(BigInteger.valueOf(l), BigInteger.valueOf(l2), bigInteger, bigInteger2, n);
                }
                return;
            }
            l2 = -l2;
        } else {
            bl = false;
        }
        long l3 = l / l2;
        long l4 = l % l2;
        boolean bl3 = bl2 ^ bl;
        boolean bl4 = false;
        if (l4 != 0L) {
            switch (n) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    boolean bl5 = bl4 = l4 > l2 - (l3 & 1L) >> 1;
                }
            }
        }
        if (bigInteger != null) {
            if (bl4) {
                ++l3;
            }
            if (bl3) {
                l3 = -l3;
            }
            bigInteger.set(l3);
        }
        if (bigInteger2 != null) {
            if (bl4) {
                l4 = l2 - l4;
                boolean bl6 = bl2 = !bl2;
            }
            if (bl2) {
                l4 = -l4;
            }
            bigInteger2.set(l4);
        }
    }

    private static void divide(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!(bigInteger.words != null && bigInteger.ival > 2 || bigInteger2.words != null && bigInteger2.ival > 2)) {
            long l = bigInteger.longValue();
            long l2 = bigInteger2.longValue();
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                BigInteger.divide(l, l2, bigInteger3, bigInteger4, n);
                return;
            }
        }
        boolean bl = bigInteger.isNegative();
        boolean bl2 = bigInteger2.isNegative();
        boolean bl3 = bl ^ bl2;
        int[] nArray = new int[n5];
        bigInteger2.getAbsolute(nArray);
        for (n5 = bigInteger2.words == null ? 1 : bigInteger2.ival; n5 > 1 && nArray[n5 - 1] == 0; --n5) {
        }
        int[] nArray2 = new int[n4 + 2];
        bigInteger.getAbsolute(nArray2);
        for (n4 = bigInteger.words == null ? 1 : bigInteger.ival; n4 > 1 && nArray2[n4 - 1] == 0; --n4) {
        }
        int n6 = MPN.cmp(nArray2, n4, nArray, n5);
        if (n6 < 0) {
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n3 = n4;
            n2 = 1;
            nArray2[0] = 0;
        } else if (n6 == 0) {
            nArray2[0] = 1;
            n2 = 1;
            nArray[0] = 0;
            n3 = 1;
        } else if (n5 == 1) {
            n2 = n4;
            if (nArray[0] == 1 && nArray2[n4 - 1] < 0) {
                ++n2;
            }
            n3 = 1;
            nArray[0] = MPN.divmod_1(nArray2, nArray2, n4, nArray[0]);
        } else {
            int n7;
            int n8 = MPN.count_leading_zeros(nArray[n5 - 1]);
            if (n8 != 0) {
                MPN.lshift(nArray, 0, nArray, n5, n8);
                n7 = MPN.lshift(nArray2, 0, nArray2, n4, n8);
                nArray2[n4++] = n7;
            }
            if (n4 == n5) {
                nArray2[n4++] = 0;
            }
            MPN.divide(nArray2, n4, nArray, n5);
            n3 = n5;
            MPN.rshift0(nArray, nArray2, 0, n3, n8);
            n2 = n4 + 1 - n5;
            if (bigInteger3 != null) {
                for (n7 = 0; n7 < n2; ++n7) {
                    nArray2[n7] = nArray2[n7 + n5];
                }
            }
        }
        if (nArray[n3 - 1] < 0) {
            nArray[n3] = 0;
            ++n3;
        }
        boolean bl4 = false;
        if (n3 > 1 || nArray[0] != 0) {
            switch (n) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    BigInteger bigInteger5 = bigInteger4 == null ? new BigInteger() : bigInteger4;
                    bigInteger5.set(nArray, n3);
                    bigInteger5 = BigInteger.shift(bigInteger5, 1);
                    if (bl2) {
                        bigInteger5.setNegative();
                    }
                    int n9 = BigInteger.compareTo(bigInteger5, bigInteger2);
                    if (bl2) {
                        n9 = -n9;
                    }
                    boolean bl5 = bl4 = n9 == 1 || n9 == 0 && (nArray2[0] & 1) != 0;
                }
            }
        }
        if (bigInteger3 != null) {
            bigInteger3.set(nArray2, n2);
            if (bl3) {
                if (bl4) {
                    bigInteger3.setInvert();
                } else {
                    bigInteger3.setNegative();
                }
            } else if (bl4) {
                bigInteger3.setAdd(1);
            }
        }
        if (bigInteger4 != null) {
            bigInteger4.set(nArray, n3);
            if (bl4) {
                BigInteger bigInteger6;
                if (bigInteger2.words == null) {
                    bigInteger6 = bigInteger4;
                    bigInteger6.set(bl2 ? (long)(nArray[0] + bigInteger2.ival) : (long)(nArray[0] - bigInteger2.ival));
                } else {
                    bigInteger6 = BigInteger.add(bigInteger4, bigInteger2, bl2 ? 1 : -1);
                }
                if (bl) {
                    bigInteger4.setNegative(bigInteger6);
                } else {
                    bigInteger4.set(bigInteger6);
                }
            } else if (bl) {
                bigInteger4.setNegative();
            }
        }
    }

    public BigInteger divide(BigInteger bigInteger) {
        if (USING_NATIVE) {
            if (bigInteger.compareTo(ZERO) == 0) {
                throw new ArithmeticException("divisor is zero");
            }
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.quotient(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.divide(this, bigInteger, bigInteger3, null, 3);
        return bigInteger3.canonicalize();
    }

    public BigInteger remainder(BigInteger bigInteger) {
        if (USING_NATIVE) {
            if (bigInteger.compareTo(ZERO) == 0) {
                throw new ArithmeticException("divisor is zero");
            }
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.remainder(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger3, 3);
        return bigInteger3.canonicalize();
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        if (USING_NATIVE) {
            if (bigInteger.compareTo(ZERO) == 0) {
                throw new ArithmeticException("divisor is zero");
            }
            BigInteger bigInteger2 = new BigInteger();
            BigInteger bigInteger3 = new BigInteger();
            this.mpz.quotientAndRemainder(bigInteger.mpz, bigInteger2.mpz, bigInteger3.mpz);
            return new BigInteger[]{bigInteger2, bigInteger3};
        }
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{new BigInteger(), new BigInteger()};
        BigInteger.divide(this, bigInteger, bigIntegerArray[0], bigIntegerArray[1], 3);
        bigIntegerArray[0].canonicalize();
        bigIntegerArray[1].canonicalize();
        return bigIntegerArray;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            if (bigInteger.compareTo(ZERO) < 1) {
                throw new ArithmeticException("non-positive modulus");
            }
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.modulo(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        if (bigInteger.isNegative() || bigInteger.isZero()) {
            throw new ArithmeticException("non-positive modulus");
        }
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger3, 1);
        return bigInteger3.canonicalize();
    }

    public BigInteger pow(int n) {
        if (n <= 0) {
            if (n == 0) {
                return ONE;
            }
            throw new ArithmeticException("negative exponent");
        }
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.pow(n, bigInteger.mpz);
            return bigInteger;
        }
        if (this.isZero()) {
            return this;
        }
        int n2 = this.words == null ? 1 : this.ival;
        int n3 = (this.bitLength() * n >> 5) + 2 * n2;
        boolean bl = this.isNegative() && (n & 1) != 0;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        this.getAbsolute(nArray);
        int n4 = 1;
        nArray2[0] = 1;
        block0: while (true) {
            int[] nArray4;
            if ((n & 1) != 0) {
                MPN.mul(nArray3, nArray, n2, nArray2, n4);
                nArray4 = nArray3;
                nArray3 = nArray2;
                nArray2 = nArray4;
                n4 += n2;
                while (nArray2[n4 - 1] == 0) {
                    --n4;
                }
            }
            if ((n >>= 1) == 0) break;
            MPN.mul(nArray3, nArray, n2, nArray, n2);
            nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
            n2 *= 2;
            while (true) {
                if (nArray[n2 - 1] != 0) continue block0;
                --n2;
            }
            break;
        }
        if (nArray2[n4 - 1] < 0) {
            ++n4;
        }
        if (bl) {
            BigInteger.negate(nArray2, nArray2, n4);
        }
        return BigInteger.make(nArray2, n4);
    }

    private static int[] euclidInv(int n, int n2, int n3) {
        if (n2 == 0) {
            throw new ArithmeticException("not invertible");
        }
        if (n2 == 1) {
            return new int[]{-n3, 1};
        }
        int[] nArray = BigInteger.euclidInv(n2, n % n2, n / n2);
        n = nArray[0];
        nArray[0] = n * -n3 + nArray[1];
        nArray[1] = n;
        return nArray;
    }

    private static void euclidInv(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger[] bigIntegerArray) {
        Object object;
        if (bigInteger2.isZero()) {
            throw new ArithmeticException("not invertible");
        }
        if (bigInteger2.isOne()) {
            bigIntegerArray[0] = BigInteger.neg(bigInteger3);
            bigIntegerArray[1] = ONE;
            return;
        }
        if (bigInteger.words == null) {
            object = BigInteger.euclidInv(bigInteger2.ival, bigInteger.ival % bigInteger2.ival, bigInteger.ival / bigInteger2.ival);
            bigIntegerArray[0] = new BigInteger((int)object[0]);
            bigIntegerArray[1] = new BigInteger((int)object[1]);
        } else {
            object = new BigInteger();
            BigInteger bigInteger4 = new BigInteger();
            BigInteger.divide(bigInteger, bigInteger2, bigInteger4, (BigInteger)object, 1);
            super.canonicalize();
            bigInteger4.canonicalize();
            BigInteger.euclidInv(bigInteger2, (BigInteger)object, bigInteger4, bigIntegerArray);
        }
        object = bigIntegerArray[0];
        bigIntegerArray[0] = BigInteger.add(bigIntegerArray[1], BigInteger.times((BigInteger)object, bigInteger3), -1);
        bigIntegerArray[1] = object;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            if (this.mpz.compare(BigInteger.ZERO.mpz) < 1) {
                throw new ArithmeticException("non-positive modulo");
            }
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.modInverse(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        if (bigInteger.isNegative() || bigInteger.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInteger.isOne()) {
            return ZERO;
        }
        if (this.isOne()) {
            return ONE;
        }
        BigInteger bigInteger3 = new BigInteger();
        boolean bl = false;
        if (bigInteger.words == null) {
            int n = bigInteger.ival;
            int n2 = this.words != null || this.isNegative() ? this.mod((BigInteger)bigInteger).ival : this.ival;
            if (n > n2) {
                int n3 = n2;
                n2 = n;
                n = n3;
                bl = true;
            }
            bigInteger3.ival = BigInteger.euclidInv(n, n2 % n, n2 / n)[bl ? 0 : 1];
            if (bigInteger3.ival < 0) {
                bigInteger3.ival += bigInteger.ival;
            }
        } else {
            BigInteger bigInteger4;
            BigInteger bigInteger5 = bigInteger4 = this.isNegative() ? this.mod(bigInteger) : this;
            if (bigInteger4.compareTo(bigInteger) < 0) {
                bigInteger3 = bigInteger4;
                bigInteger4 = bigInteger;
                bigInteger = bigInteger3;
                bl = true;
            }
            BigInteger bigInteger6 = new BigInteger();
            BigInteger bigInteger7 = new BigInteger();
            BigInteger.divide(bigInteger4, bigInteger, bigInteger7, bigInteger6, 1);
            bigInteger6.canonicalize();
            bigInteger7.canonicalize();
            BigInteger[] bigIntegerArray = new BigInteger[2];
            BigInteger.euclidInv(bigInteger, bigInteger6, bigInteger7, bigIntegerArray);
            BigInteger bigInteger8 = bigInteger3 = bl ? bigIntegerArray[0] : bigIntegerArray[1];
            if (bigInteger3.isNegative()) {
                bigInteger3 = BigInteger.add(bigInteger3, bl ? bigInteger4 : bigInteger, 1);
            }
        }
        return bigInteger3;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            if (bigInteger2.mpz.compare(BigInteger.ZERO.mpz) < 1) {
                throw new ArithmeticException("non-positive modulo");
            }
            BigInteger bigInteger3 = new BigInteger();
            this.mpz.modPow(bigInteger.mpz, bigInteger2.mpz, bigInteger3.mpz);
            return bigInteger3;
        }
        if (bigInteger2.isNegative() || bigInteger2.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInteger.isNegative()) {
            return this.modInverse(bigInteger2).modPow(bigInteger.negate(), bigInteger2);
        }
        if (bigInteger.isOne()) {
            return this.mod(bigInteger2);
        }
        BigInteger bigInteger4 = ONE;
        BigInteger bigInteger5 = this;
        BigInteger bigInteger6 = bigInteger;
        while (!bigInteger6.isZero()) {
            if (bigInteger6.and(ONE).isOne()) {
                bigInteger4 = BigInteger.times(bigInteger4, bigInteger5).mod(bigInteger2);
            }
            bigInteger6 = bigInteger6.shiftRight(1);
            bigInteger5 = BigInteger.times(bigInteger5, bigInteger5).mod(bigInteger2);
        }
        return bigInteger4;
    }

    private static int gcd(int n, int n2) {
        int n3;
        if (n2 > n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 != 0) {
            if (n2 == 1) {
                return n2;
            }
            n3 = n2;
            n2 = n % n2;
            n = n3;
        }
        return n;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.gcd(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        int n = this.ival;
        int n2 = bigInteger.ival;
        if (this.words == null) {
            if (n == 0) {
                return BigInteger.abs(bigInteger);
            }
            if (bigInteger.words == null && n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                if (n < 0) {
                    n = -n;
                }
                if (n2 < 0) {
                    n2 = -n2;
                }
                return BigInteger.valueOf(BigInteger.gcd(n, n2));
            }
            n = 1;
        }
        if (bigInteger.words == null) {
            if (n2 == 0) {
                return BigInteger.abs(this);
            }
            n2 = 1;
        }
        int n3 = (n > n2 ? n : n2) + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        this.getAbsolute(nArray);
        bigInteger.getAbsolute(nArray2);
        n3 = MPN.gcd(nArray, nArray2, n3);
        BigInteger bigInteger3 = new BigInteger(0);
        bigInteger3.ival = n3;
        bigInteger3.words = nArray;
        return bigInteger3.canonicalize();
    }

    public boolean isProbablePrime(int n) {
        int n2;
        if (n < 1) {
            return true;
        }
        if (USING_NATIVE) {
            return this.mpz.testPrimality(n) != 0;
        }
        BigInteger bigInteger = new BigInteger();
        for (n2 = 0; n2 < primes.length; ++n2) {
            if (this.words == null && this.ival == primes[n2]) {
                return true;
            }
            BigInteger.divide(this, smallFixNums[primes[n2] - -100], null, bigInteger, 3);
            if (!bigInteger.canonicalize().isZero()) continue;
            return false;
        }
        BigInteger bigInteger2 = BigInteger.add(this, -1);
        int n3 = bigInteger2.getLowestSetBit();
        BigInteger bigInteger3 = bigInteger2.divide(BigInteger.valueOf(2L).pow(n3));
        int n4 = this.bitLength();
        for (n2 = 0; n2 < k.length && n4 > k[n2]; ++n2) {
        }
        int n5 = t[n2];
        if (n > 80) {
            n5 *= 2;
        }
        for (int i = 0; i < n5; ++i) {
            BigInteger bigInteger4 = smallFixNums[primes[i] - -100].modPow(bigInteger3, this);
            if (bigInteger4.isOne() || bigInteger4.equals(bigInteger2)) continue;
            n2 = 0;
            while (n2 < n3) {
                if (bigInteger4.isOne()) {
                    return false;
                }
                ++n2;
                if (bigInteger4.equals(bigInteger2)) break;
                bigInteger4 = bigInteger4.modPow(BigInteger.valueOf(2L), this);
            }
            if (n2 != n3 || bigInteger4.equals(bigInteger2)) continue;
            return false;
        }
        return true;
    }

    private void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int n = this.ival;
            while (--n >= 0) {
                this.words[n] = ~this.words[n];
            }
        }
    }

    private void setShiftLeft(BigInteger bigInteger, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (bigInteger.words == null) {
            if (n < 32) {
                this.set((long)bigInteger.ival << n);
                return;
            }
            nArray = new int[]{bigInteger.ival};
            n3 = 1;
        } else {
            nArray = bigInteger.words;
            n3 = bigInteger.ival;
        }
        int n4 = n >> 5;
        int n5 = n3 + n4;
        if ((n &= 0x1F) == 0) {
            this.realloc(n5);
            n2 = n3;
            while (--n2 >= 0) {
                this.words[n2 + n4] = nArray[n2];
            }
        } else {
            this.realloc(++n5);
            n2 = MPN.lshift(this.words, n4, nArray, n3, n);
            n = 32 - n;
            this.words[n5 - 1] = n2 << n >> n;
        }
        this.ival = n5;
        n2 = n4;
        while (--n2 >= 0) {
            this.words[n2] = 0;
        }
    }

    private void setShiftRight(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            this.set(n < 32 ? (long)(bigInteger.ival >> n) : (bigInteger.ival < 0 ? -1L : 0L));
        } else if (n == 0) {
            this.set(bigInteger);
        } else {
            boolean bl = bigInteger.isNegative();
            int n2 = n >> 5;
            n &= 0x1F;
            int n3 = bigInteger.ival - n2;
            if (n3 <= 0) {
                this.set(bl ? -1L : 0L);
            } else {
                if (this.words == null || this.words.length < n3) {
                    this.realloc(n3);
                }
                MPN.rshift0(this.words, bigInteger.words, n2, n3, n);
                this.ival = n3;
                if (bl) {
                    int n4 = n3 - 1;
                    this.words[n4] = this.words[n4] | -2 << 31 - n;
                }
            }
        }
    }

    private void setShift(BigInteger bigInteger, int n) {
        if (n > 0) {
            this.setShiftLeft(bigInteger, n);
        } else {
            this.setShiftRight(bigInteger, -n);
        }
    }

    private static BigInteger shift(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            if (n <= 0) {
                return BigInteger.valueOf(n > -32 ? (long)(bigInteger.ival >> -n) : (bigInteger.ival < 0 ? -1L : 0L));
            }
            if (n < 32) {
                return BigInteger.valueOf((long)bigInteger.ival << n);
            }
        }
        if (n == 0) {
            return bigInteger;
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setShift(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0) {
            return this;
        }
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            if (n < 0) {
                this.mpz.shiftRight(-n, bigInteger.mpz);
            } else {
                this.mpz.shiftLeft(n, bigInteger.mpz);
            }
            return bigInteger;
        }
        return BigInteger.shift(this, n);
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            if (n < 0) {
                this.mpz.shiftLeft(-n, bigInteger.mpz);
            } else {
                this.mpz.shiftRight(n, bigInteger.mpz);
            }
            return bigInteger;
        }
        return BigInteger.shift(this, -n);
    }

    private void format(int n, CPStringBuilder cPStringBuilder) {
        if (this.words == null) {
            cPStringBuilder.append(Integer.toString(this.ival, n));
        } else if (this.ival <= 2) {
            cPStringBuilder.append(Long.toString(this.longValue(), n));
        } else {
            int[] nArray;
            boolean bl = this.isNegative();
            if (bl || n != 16) {
                nArray = new int[this.ival];
                this.getAbsolute(nArray);
            } else {
                nArray = this.words;
            }
            int n2 = this.ival;
            if (n == 16) {
                if (bl) {
                    cPStringBuilder.append('-');
                }
                int n3 = cPStringBuilder.length();
                int n4 = n2;
                while (--n4 >= 0) {
                    int n5 = nArray[n4];
                    int n6 = 8;
                    while (--n6 >= 0) {
                        int n7 = n5 >> 4 * n6 & 0xF;
                        if (n7 <= 0 && cPStringBuilder.length() <= n3) continue;
                        cPStringBuilder.append(Character.forDigit(n7, 16));
                    }
                }
            } else {
                int n8;
                int n9 = cPStringBuilder.length();
                do {
                    n8 = MPN.divmod_1(nArray, nArray, n2, n);
                    cPStringBuilder.append(Character.forDigit(n8, n));
                    while (n2 > 0 && nArray[n2 - 1] == 0) {
                        --n2;
                    }
                } while (n2 != 0);
                if (bl) {
                    cPStringBuilder.append('-');
                }
                for (n8 = cPStringBuilder.length() - 1; n9 < n8; ++n9, --n8) {
                    char c = cPStringBuilder.charAt(n9);
                    cPStringBuilder.setCharAt(n9, cPStringBuilder.charAt(n8));
                    cPStringBuilder.setCharAt(n8, c);
                }
            }
        }
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int n) {
        if (USING_NATIVE) {
            return this.mpz.toString(n);
        }
        if (this.words == null) {
            return Integer.toString(this.ival, n);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), n);
        }
        int n2 = this.ival * (MPN.chars_per_word(n) + 1);
        CPStringBuilder cPStringBuilder = new CPStringBuilder(n2);
        this.format(n, cPStringBuilder);
        return cPStringBuilder.toString();
    }

    @Override
    public int intValue() {
        if (USING_NATIVE) {
            int n = this.mpz.absIntValue();
            return this.mpz.compare(BigInteger.ZERO.mpz) < 0 ? -n : n;
        }
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    @Override
    public long longValue() {
        if (USING_NATIVE) {
            long l = this.abs().shiftRight((int)32).mpz.absIntValue();
            l <<= 32;
            return this.compareTo(ZERO) < 0 ? -l : (l |= (long)this.mpz.absIntValue() & 0xFFFFFFFFL);
        }
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    public int hashCode() {
        if (USING_NATIVE) {
            byte[] byArray = this.toByteArray();
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n ^= (byArray[i] & 0xFF) << 8 * (i % 4);
            }
            return n;
        }
        return this.words == null ? this.ival : this.words[0] + this.words[this.ival - 1];
    }

    private static boolean equals(BigInteger bigInteger, BigInteger bigInteger2) {
        if (USING_NATIVE) {
            return bigInteger.mpz.compare(bigInteger2.mpz) == 0;
        }
        if (bigInteger.words == null && bigInteger2.words == null) {
            return bigInteger.ival == bigInteger2.ival;
        }
        if (bigInteger.words == null || bigInteger2.words == null || bigInteger.ival != bigInteger2.ival) {
            return false;
        }
        int n = bigInteger.ival;
        while (--n >= 0) {
            if (bigInteger.words[n] == bigInteger2.words[n]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        return BigInteger.equals(this, (BigInteger)object);
    }

    private static BigInteger valueOf(byte[] byArray, int n, boolean bl, int n2) {
        int n3 = MPN.chars_per_word(n2);
        int[] nArray = new int[n / n3 + 1];
        int n4 = MPN.set_str(nArray, byArray, n, n2);
        if (n4 == 0) {
            return ZERO;
        }
        if (nArray[n4 - 1] < 0) {
            nArray[n4++] = 0;
        }
        if (bl) {
            BigInteger.negate(nArray, nArray, n4);
        }
        return BigInteger.make(nArray, n4);
    }

    @Override
    public double doubleValue() {
        if (USING_NATIVE) {
            return this.mpz.doubleValue();
        }
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return BigInteger.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    private boolean checkBits(int n) {
        int n2;
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            return n > 31 || (this.ival & (1 << n) - 1) != 0;
        }
        for (n2 = 0; n2 < n >> 5; ++n2) {
            if (this.words[n2] == 0) continue;
            return true;
        }
        return (n & 0x1F) != 0 && (this.words[n2] & (1 << (n & 0x1F)) - 1) != 0;
    }

    private double roundToDouble(int n, boolean bl, boolean bl2) {
        int n2 = this.bitLength();
        if ((n += n2 - 1) < -1075) {
            return bl ? -0.0 : 0.0;
        }
        if (n > 1023) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int n3 = n >= -1022 ? 53 : 53 + n + 1022;
        int n4 = n2 - (n3 + 1);
        long l = n4 > 0 ? (this.words == null ? (long)(this.ival >> n4) : MPN.rshift_long(this.words, this.ival, n4)) : this.longValue() << -n4;
        if (n == 1023 && l >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (bl2 || this.checkBits(n2 - n3)) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return bl ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if ((l & 1L) == 1L && ((l & 2L) == 2L || bl2 || this.checkBits(n4))) {
            if (((l += 2L) & 0x40000000000000L) != 0L) {
                ++n;
                l >>= 1;
            } else if (n3 == 52 && (l & 0x20000000000000L) != 0L) {
                ++n;
            }
        }
        long l2 = bl ? Long.MIN_VALUE : 0L;
        long l3 = (n += 1023) <= 0 ? 0L : (long)n << 52;
        long l4 = (l >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 | l3 | l4);
    }

    private void getAbsolute(int[] nArray) {
        int n;
        int n2;
        if (this.words == null) {
            n2 = 1;
            nArray[0] = this.ival;
        } else {
            n = n2 = this.ival;
            while (--n >= 0) {
                nArray[n] = this.words[n];
            }
        }
        if (nArray[n2 - 1] < 0) {
            BigInteger.negate(nArray, nArray, n2);
        }
        n = nArray.length;
        while (--n > n2) {
            nArray[n] = 0;
        }
    }

    private static boolean negate(int[] nArray, int[] nArray2, int n) {
        long l = 1L;
        boolean bl = nArray2[n - 1] < 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(l += (long)(~nArray2[i]) & 0xFFFFFFFFL);
            l >>= 32;
        }
        return bl && nArray[n - 1] < 0;
    }

    private void setNegative(BigInteger bigInteger) {
        int n = bigInteger.ival;
        if (bigInteger.words == null) {
            if (n == Integer.MIN_VALUE) {
                this.set(-((long)n));
            } else {
                this.set(-n);
            }
            return;
        }
        this.realloc(n + 1);
        if (BigInteger.negate(this.words, bigInteger.words, n)) {
            this.words[n++] = 0;
        }
        this.ival = n;
    }

    private void setNegative() {
        this.setNegative(this);
    }

    private static BigInteger abs(BigInteger bigInteger) {
        return bigInteger.isNegative() ? BigInteger.neg(bigInteger) : bigInteger;
    }

    public BigInteger abs() {
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.abs(bigInteger.mpz);
            return bigInteger;
        }
        return BigInteger.abs(this);
    }

    private static BigInteger neg(BigInteger bigInteger) {
        if (bigInteger.words == null && bigInteger.ival != Integer.MIN_VALUE) {
            return BigInteger.valueOf(-bigInteger.ival);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setNegative(bigInteger);
        return bigInteger2.canonicalize();
    }

    public BigInteger negate() {
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.negate(bigInteger.mpz);
            return bigInteger;
        }
        return BigInteger.neg(this);
    }

    public int bitLength() {
        if (USING_NATIVE) {
            return this.mpz.bitLength();
        }
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public byte[] toByteArray() {
        int n;
        if (this.signum() == 0) {
            return new byte[1];
        }
        if (USING_NATIVE) {
            int n2 = this.bitLength();
            if (n2 % 8 == 0 || this.signum() == 1) {
                ++n2;
            }
            byte[] byArray = new byte[(n2 + 7) / 8];
            this.mpz.toByteArray(byArray);
            return byArray;
        }
        byte[] byArray = new byte[(this.bitLength() + 1 + 7) / 8];
        int n3 = byArray.length;
        int n4 = 0;
        while (n3 > 4) {
            n = this.words[n4++];
            int n5 = 4;
            while (n5 > 0) {
                byArray[--n3] = (byte)n;
                --n5;
                n >>= 8;
            }
        }
        int n6 = n = this.words == null ? this.ival : this.words[n4];
        while (n3 > 0) {
            byArray[--n3] = (byte)n;
            n >>= 8;
        }
        return byArray;
    }

    private static int swappedOp(int n) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(n);
    }

    private static BigInteger bitOp(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return bigInteger.and(bigInteger2);
            }
            case 3: {
                return bigInteger;
            }
            case 5: {
                return bigInteger2;
            }
            case 15: {
                return BigInteger.valueOf(-1L);
            }
        }
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.setBitOp(bigInteger3, n, bigInteger, bigInteger2);
        return bigInteger3.canonicalize();
    }

    private static void setBitOp(BigInteger bigInteger, int n, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bigInteger3.words != null && (bigInteger2.words == null || bigInteger2.ival < bigInteger3.ival)) {
            BigInteger bigInteger4 = bigInteger2;
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger4;
            n = BigInteger.swappedOp(n);
        }
        if (bigInteger3.words == null) {
            n6 = bigInteger3.ival;
            n5 = 1;
        } else {
            n6 = bigInteger3.words[0];
            n5 = bigInteger3.ival;
        }
        if (bigInteger2.words == null) {
            n4 = bigInteger2.ival;
            n3 = 1;
        } else {
            n4 = bigInteger2.words[0];
            n3 = bigInteger2.ival;
        }
        if (n3 > 1) {
            bigInteger.realloc(n3);
        }
        int[] nArray = bigInteger.words;
        int n7 = 0;
        int n8 = 0;
        block0 : switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                while (true) {
                    n2 = n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 2: {
                while (true) {
                    n2 = n4 & ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 3: {
                n2 = n4;
                n8 = 1;
                break;
            }
            case 4: {
                while (true) {
                    n2 = ~n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            case 5: {
                while (true) {
                    n2 = n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
            }
            case 6: {
                while (true) {
                    n2 = n4 ^ n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                n8 = n6 < 0 ? 2 : 1;
                break;
            }
            case 7: {
                while (true) {
                    n2 = n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 8: {
                while (true) {
                    n2 = ~(n4 | n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 9: {
                while (true) {
                    n2 = ~(n4 ^ n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                n8 = n6 >= 0 ? 2 : 1;
                break;
            }
            case 10: {
                while (true) {
                    n2 = ~n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
            }
            case 11: {
                while (true) {
                    n2 = n4 | ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 12: {
                n2 = ~n4;
                n8 = 2;
                break;
            }
            case 13: {
                while (true) {
                    n2 = ~n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 14: {
                while (true) {
                    n2 = ~(n4 & n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n7 + 1 == n3) {
            n8 = 0;
        }
        switch (n8) {
            case 0: {
                if (n7 == 0 && nArray == null) {
                    bigInteger.ival = n2;
                    return;
                }
                nArray[n7++] = n2;
                break;
            }
            case 1: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = bigInteger2.words[n7];
                }
                break;
            }
            case 2: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = ~bigInteger2.words[n7];
                }
                break;
            }
        }
        bigInteger.ival = n7;
    }

    private static BigInteger and(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.valueOf(bigInteger.ival & n);
        }
        if (n >= 0) {
            return BigInteger.valueOf(bigInteger.words[0] & n);
        }
        int n2 = bigInteger.ival;
        int[] nArray = new int[n2];
        nArray[0] = bigInteger.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = bigInteger.words[n2];
        }
        return BigInteger.make(nArray, bigInteger.ival);
    }

    public BigInteger and(BigInteger bigInteger) {
        int n;
        if (USING_NATIVE) {
            int n2 = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.and(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        if (bigInteger.words == null) {
            return BigInteger.and(this, bigInteger.ival);
        }
        if (this.words == null) {
            return BigInteger.and(bigInteger, this.ival);
        }
        BigInteger bigInteger3 = this;
        if (this.ival < bigInteger.ival) {
            BigInteger bigInteger4 = this;
            bigInteger3 = bigInteger;
            bigInteger = bigInteger4;
        }
        int n3 = bigInteger.isNegative() ? bigInteger3.ival : bigInteger.ival;
        int[] nArray = new int[n3];
        for (n = 0; n < bigInteger.ival; ++n) {
            nArray[n] = bigInteger3.words[n] & bigInteger.words[n];
        }
        while (n < n3) {
            nArray[n] = bigInteger3.words[n];
            ++n;
        }
        return BigInteger.make(nArray, n3);
    }

    public BigInteger or(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.or(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        return BigInteger.bitOp(7, this, bigInteger);
    }

    public BigInteger xor(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.xor(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        return BigInteger.bitOp(6, this, bigInteger);
    }

    public BigInteger not() {
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.not(bigInteger.mpz);
            return bigInteger;
        }
        return BigInteger.bitOp(12, this, ZERO);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        if (USING_NATIVE) {
            int n = bigInteger.signum;
            BigInteger bigInteger2 = new BigInteger();
            this.mpz.andNot(bigInteger.mpz, bigInteger2.mpz);
            return bigInteger2;
        }
        return this.and(bigInteger.not());
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.setBit(n, false, bigInteger.mpz);
            return bigInteger;
        }
        return this.and(ONE.shiftLeft(n).not());
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.setBit(n, true, bigInteger.mpz);
            return bigInteger;
        }
        return this.or(ONE.shiftLeft(n));
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        if (USING_NATIVE) {
            return this.mpz.testBit(n) != 0;
        }
        return !this.and(ONE.shiftLeft(n)).isZero();
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        if (USING_NATIVE) {
            BigInteger bigInteger = new BigInteger();
            this.mpz.flipBit(n, bigInteger.mpz);
            return bigInteger;
        }
        return this.xor(ONE.shiftLeft(n));
    }

    public int getLowestSetBit() {
        if (USING_NATIVE) {
            return this.mpz.compare(BigInteger.ZERO.mpz) == 0 ? -1 : this.mpz.lowestSetBit();
        }
        if (this.isZero()) {
            return -1;
        }
        if (this.words == null) {
            return MPN.findLowestBit(this.ival);
        }
        return MPN.findLowestBit(this.words);
    }

    private static int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += bit4_count[n & 0xF];
            n >>>= 4;
        }
        return n2;
    }

    private static int bitCount(int[] nArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += BigInteger.bitCount(nArray[n]);
        }
        return n2;
    }

    public int bitCount() {
        int n;
        int n2;
        if (USING_NATIVE) {
            return this.mpz.bitCount();
        }
        int[] nArray = this.words;
        if (nArray == null) {
            n2 = 1;
            n = BigInteger.bitCount(this.ival);
        } else {
            n2 = this.ival;
            n = BigInteger.bitCount(nArray, n2);
        }
        return this.isNegative() ? n2 * 32 - n : n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (USING_NATIVE) {
            this.mpz = new GMP();
            objectInputStream.defaultReadObject();
            if (this.signum != 0) {
                this.mpz.fromByteArray(this.magnitude);
            }
        } else {
            objectInputStream.defaultReadObject();
            if (this.magnitude.length == 0 || this.signum == 0) {
                this.ival = 0;
                this.words = null;
            } else {
                this.words = BigInteger.byteArrayToIntArray(this.magnitude, this.signum < 0 ? -1 : 0);
                BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
                this.ival = bigInteger.ival;
                this.words = bigInteger.words;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        this.signum = this.signum();
        this.magnitude = this.signum == 0 ? new byte[]{} : this.toByteArray();
        objectOutputStream.defaultWriteObject();
        this.magnitude = null;
    }

    static {
        USING_NATIVE = false;
        if (USING_NATIVE) {
            smallFixNums = null;
            ZERO = BigInteger.valueOf(0L);
            ONE = BigInteger.valueOf(1L);
            TEN = BigInteger.valueOf(10L);
        } else {
            smallFixNums = new BigInteger[1125];
            int n = 1125;
            while (--n >= 0) {
                BigInteger.smallFixNums[n] = new BigInteger(n + -100);
            }
            ZERO = smallFixNums[100];
            ONE = smallFixNums[101];
            TEN = smallFixNums[110];
        }
        primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
        k = new int[]{100, 150, 200, 250, 300, 350, 400, 500, 600, 800, 1250, Integer.MAX_VALUE};
        t = new int[]{27, 18, 15, 12, 9, 8, 7, 6, 5, 4, 3, 2};
        bit4_count = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    }
}

