/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.reflect.TypeSignature;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.VMProxy;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Map proxyClasses = new HashMap();
    protected InvocationHandler h;

    protected Proxy(InvocationHandler invocationHandler) {
        if (invocationHandler == null && Proxy.isProxyClass(this.getClass())) {
            throw new NullPointerException("invalid handler");
        }
        this.h = invocationHandler;
    }

    public static synchronized Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) {
        ProxyType proxyType = new ProxyType(classLoader, classArray = (Class[])classArray.clone());
        Class clazz = (Class)proxyClasses.get(proxyType);
        if (clazz == null) {
            Object object;
            if (VMProxy.HAVE_NATIVE_GET_PROXY_CLASS) {
                clazz = VMProxy.getProxyClass(classLoader, classArray);
            } else {
                object = VMProxy.HAVE_NATIVE_GET_PROXY_DATA ? VMProxy.getProxyData(classLoader, classArray) : ProxyData.getProxyData(proxyType);
                clazz = VMProxy.HAVE_NATIVE_GENERATE_PROXY_CLASS ? VMProxy.generateProxyClass(classLoader, (ProxyData)object) : new ClassFactory((ProxyData)object).generate(classLoader);
            }
            object = proxyClasses.put(proxyType, clazz);
            if (object != null || clazz == null) {
                throw new InternalError();
            }
        }
        return clazz;
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) {
        try {
            return Proxy.getProxyClass(classLoader, classArray).getConstructor(InvocationHandler.class).newInstance(invocationHandler);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (NullPointerException)invocationTargetException.getCause();
        }
        catch (Exception exception) {
            throw (Error)new InternalError("Unexpected: " + exception).initCause(exception);
        }
    }

    public static synchronized boolean isProxyClass(Class<?> clazz) {
        if (!Proxy.class.isAssignableFrom(clazz)) {
            return false;
        }
        return proxyClasses.containsValue(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        return ((Proxy)object).h;
    }

    private static final class ClassFactory {
        private static final byte FIELD = 1;
        private static final byte METHOD = 2;
        private static final byte INTERFACE = 3;
        private static final String CTOR_SIG = "(Ljava/lang/reflect/InvocationHandler;)V";
        private static final String INVOKE_SIG = "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
        private static final char ACONST_NULL = '\u0001';
        private static final char ICONST_0 = '\u0003';
        private static final char BIPUSH = '\u0010';
        private static final char SIPUSH = '\u0011';
        private static final char ILOAD = '\u0015';
        private static final char ILOAD_0 = '\u001a';
        private static final char ALOAD_0 = '*';
        private static final char ALOAD_1 = '+';
        private static final char AALOAD = '2';
        private static final char AASTORE = 'S';
        private static final char DUP = 'Y';
        private static final char DUP_X1 = 'Z';
        private static final char SWAP = '_';
        private static final char IRETURN = '\u00ac';
        private static final char LRETURN = '\u00ad';
        private static final char FRETURN = '\u00ae';
        private static final char DRETURN = '\u00af';
        private static final char ARETURN = '\u00b0';
        private static final char RETURN = '\u00b1';
        private static final char GETSTATIC = '\u00b2';
        private static final char GETFIELD = '\u00b4';
        private static final char INVOKEVIRTUAL = '\u00b6';
        private static final char INVOKESPECIAL = '\u00b7';
        private static final char INVOKEINTERFACE = '\u00b9';
        private static final char NEW = '\u00bb';
        private static final char ANEWARRAY = '\u00bd';
        private static final char ATHROW = '\u00bf';
        private static final char CHECKCAST = '\u00c0';
        private final StringBuffer pool = new StringBuffer();
        private final StringBuffer stream = new StringBuffer();
        private final Map poolEntries = new HashMap();
        private final String qualName;
        private final Method[] methods;

        ClassFactory(ProxyData proxyData) {
            int n;
            this.methods = proxyData.methods;
            this.pool.append("\u00ca\u00fe\u00ba\u00be\u0000\u0000\u0000.\u0000\u0000");
            this.putU2(49);
            this.qualName = proxyData.pack + "$Proxy" + proxyData.id;
            this.putU2(this.classInfo(TypeSignature.getEncodingOfClass(this.qualName, false)));
            this.putU2(this.classInfo("java/lang/reflect/Proxy"));
            this.putU2(proxyData.interfaces.length);
            for (n = 0; n < proxyData.interfaces.length; ++n) {
                this.putU2(this.classInfo(proxyData.interfaces[n]));
            }
            this.putU2(1);
            this.putU2(10);
            this.putU2(this.utf8Info("m"));
            this.putU2(this.utf8Info("[Ljava/lang/reflect/Method;"));
            this.putU2(0);
            this.putU2(this.methods.length + 1);
            this.putU2(1);
            this.putU2(this.utf8Info("<init>"));
            this.putU2(this.utf8Info(CTOR_SIG));
            this.putU2(1);
            this.putU2(this.utf8Info("Code"));
            this.stream.append("\u0000\u0000\u0000\u0012\u0000\u0002\u0000\u0002\u0000\u0000\u0000\u0006*+\u00b7");
            this.putU2(this.refInfo((byte)2, "java/lang/reflect/Proxy", "<init>", CTOR_SIG));
            this.stream.append("\u00b1\u0000\u0000\u0000\u0000");
            for (n = this.methods.length - 1; n >= 0; --n) {
                this.emitMethod(n, proxyData.exceptions[n]);
            }
            this.putU2(0);
        }

        private void emitMethod(int n, Class[] classArray) {
            int n2;
            int n3;
            Class<?> clazz;
            int n4;
            Method method = this.methods[n];
            Class<?>[] classArray2 = method.getParameterTypes();
            int n5 = 0;
            int n6 = 1;
            int n7 = 16;
            if (n > 5) {
                n7 = n > 127 ? (n7 += 2) : ++n7;
            }
            if (classArray2.length > 0) {
                n7 += 3;
                if (classArray2.length > 127) {
                    n7 += 2;
                } else if (classArray2.length > 5) {
                    ++n7;
                }
                for (n4 = 0; n4 < classArray2.length; ++n4) {
                    n7 += 4;
                    clazz = classArray2[n4];
                    if (n4 > 5) {
                        n7 = n4 > 127 ? (n7 += 2) : ++n7;
                    }
                    if (n6 >= 4) {
                        ++n7;
                    }
                    ++n6;
                    if (!clazz.isPrimitive()) continue;
                    n7 += 7;
                    if (clazz == Long.TYPE || clazz == Double.TYPE) {
                        n5 = 3;
                        ++n6;
                        continue;
                    }
                    if (n5 >= 2) continue;
                    n5 = 2;
                }
            }
            n4 = n7++;
            clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                n7 = clazz.isPrimitive() ? (n7 += 7) : (n7 += 4);
            }
            int n8 = 0;
            boolean bl = false;
            for (n3 = 0; n3 < classArray.length; ++n3) {
                if (classArray[n3] != Throwable.class) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n8 = classArray.length + 3;
                n7 += 9;
            }
            n3 = n7 - 1;
            CPStringBuilder cPStringBuilder = new CPStringBuilder("(");
            for (n2 = 0; n2 < classArray2.length; ++n2) {
                cPStringBuilder.append(TypeSignature.getEncodingOfClass(classArray2[n2]));
            }
            cPStringBuilder.append(")").append(TypeSignature.getEncodingOfClass(clazz));
            this.putU2(17);
            this.putU2(this.utf8Info(method.getName()));
            this.putU2(this.utf8Info(cPStringBuilder.toString()));
            this.putU2(classArray.length > 0 ? 2 : 1);
            this.putU2(this.utf8Info("Code"));
            this.putU4(12 + n7 + 8 * n8);
            this.putU2(n6 == 1 ? 4 : 7 + n5);
            this.putU2(n6);
            this.putU4(n7);
            this.putU1(42);
            this.putU1(180);
            this.putU2(this.refInfo((byte)1, "java/lang/reflect/Proxy", "h", "Ljava/lang/reflect/InvocationHandler;"));
            this.putU1(42);
            this.putU1(178);
            this.putU2(this.refInfo((byte)1, TypeSignature.getEncodingOfClass(this.qualName, false), "m", "[Ljava/lang/reflect/Method;"));
            this.putConst(n);
            this.putU1(50);
            if (classArray2.length > 0) {
                this.putConst(classArray2.length);
                this.putU1(189);
                this.putU2(this.classInfo("java/lang/Object"));
                n6 = 1;
                n2 = 0;
                while (n2 < classArray2.length) {
                    this.putU1(89);
                    this.putConst(n2);
                    if (classArray2[n2].isPrimitive()) {
                        this.putU1(187);
                        this.putU2(this.classInfo(this.wrapper(classArray2[n2])));
                        this.putU1(89);
                    }
                    this.putLoad(n6, classArray2[n2]);
                    if (classArray2[n2].isPrimitive()) {
                        this.putU1(183);
                        this.putU2(this.refInfo((byte)2, this.wrapper(classArray2[n2]), "<init>", '(' + TypeSignature.getEncodingOfClass(classArray2[n2]) + ")V"));
                        if (classArray2[n2] == Long.TYPE || classArray2[n2] == Double.TYPE) {
                            ++n6;
                        }
                    }
                    this.putU1(83);
                    ++n2;
                    ++n6;
                }
            } else {
                this.putU1(1);
            }
            this.putU1(185);
            this.putU2(this.refInfo((byte)3, "java/lang/reflect/InvocationHandler", "invoke", INVOKE_SIG));
            this.putU1(4);
            this.putU1(0);
            if (clazz == Void.TYPE) {
                this.putU1(177);
            } else if (clazz.isPrimitive()) {
                this.putU1(192);
                this.putU2(this.classInfo(this.wrapper(clazz)));
                this.putU1(182);
                this.putU2(this.refInfo((byte)2, this.wrapper(clazz), clazz.getName() + "Value", "()" + TypeSignature.getEncodingOfClass(clazz)));
                if (clazz == Long.TYPE) {
                    this.putU1(173);
                } else if (clazz == Float.TYPE) {
                    this.putU1(174);
                } else if (clazz == Double.TYPE) {
                    this.putU1(175);
                } else {
                    this.putU1(172);
                }
            } else {
                this.putU1(192);
                this.putU2(this.classInfo(clazz));
                this.putU1(176);
            }
            if (!bl) {
                this.putU1(187);
                this.putU2(this.classInfo("java/lang/reflect/UndeclaredThrowableException"));
                this.putU1(90);
                this.putU1(95);
                this.putU1(183);
                this.putU2(this.refInfo((byte)2, "java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V"));
                this.putU1(191);
            }
            this.putU2(n8);
            if (!bl) {
                this.putU2(0);
                this.putU2(n4);
                this.putU2(n3);
                this.putU2(this.classInfo("java/lang/Error"));
                this.putU2(0);
                this.putU2(n4);
                this.putU2(n3);
                this.putU2(this.classInfo("java/lang/RuntimeException"));
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    this.putU2(0);
                    this.putU2(n4);
                    this.putU2(n3);
                    this.putU2(this.classInfo(classArray[n2]));
                }
                this.putU2(0);
                this.putU2(n4);
                this.putU2(n3 - 8);
                this.putU2(0);
            }
            this.putU2(0);
            if (classArray.length > 0) {
                this.putU2(this.utf8Info("Exceptions"));
                this.putU4(2 * classArray.length + 2);
                this.putU2(classArray.length);
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    this.putU2(this.classInfo(classArray[n2]));
                }
            }
        }

        Class generate(ClassLoader classLoader) {
            byte[] byArray = new byte[this.pool.length() + this.stream.length()];
            char[] cArray = this.pool.toString().toCharArray();
            int n = cArray.length;
            while (--n >= 0) {
                byArray[n] = (byte)cArray[n];
            }
            cArray = this.stream.toString().toCharArray();
            n = cArray.length;
            int n2 = byArray.length;
            while (n > 0) {
                byArray[--n2] = (byte)cArray[--n];
            }
            int n3 = this.poolEntries.size() + 1;
            byArray[8] = (byte)(n3 >> 8);
            byArray[9] = (byte)n3;
            try {
                Class<?> clazz = Class.forName("java.lang.VMClassLoader");
                Class[] classArray = new Class[]{ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class};
                Method method = clazz.getDeclaredMethod("defineClass", classArray);
                method.flag = true;
                Object[] objectArray = new Object[]{classLoader, this.qualName, byArray, 0, byArray.length, Object.class.getProtectionDomain()};
                Class clazz2 = (Class)method.invoke(null, objectArray);
                Field field = clazz2.getDeclaredField("m");
                field.flag = true;
                field.set(null, this.methods);
                return clazz2;
            }
            catch (Exception exception) {
                throw (Error)new InternalError("Unexpected: " + exception).initCause(exception);
            }
        }

        private void putU1(int n) {
            this.stream.append((char)n);
        }

        private void putU2(int n) {
            this.stream.append((char)(n >> 8)).append((char)n);
        }

        private void putU4(int n) {
            this.stream.append((char)(n >> 24)).append((char)(n >> 16));
            this.stream.append((char)(n >> 8)).append((char)n);
        }

        private void putConst(int n) {
            if (n >= -1 && n <= 5) {
                this.putU1(3 + n);
            } else if (n >= -128 && n <= 127) {
                this.putU1(16);
                this.putU1(n);
            } else {
                this.putU1(17);
                this.putU2(n);
            }
        }

        private void putLoad(int n, Class clazz) {
            int n2 = 0;
            if (clazz == Long.TYPE) {
                n2 = 1;
            } else if (clazz == Float.TYPE) {
                n2 = 2;
            } else if (clazz == Double.TYPE) {
                n2 = 3;
            } else if (!clazz.isPrimitive()) {
                n2 = 4;
            }
            if (n < 4) {
                this.putU1(26 + 4 * n2 + n);
            } else {
                this.putU1(21 + n2);
                this.putU1(n);
            }
        }

        private String wrapper(Class clazz) {
            if (clazz == Boolean.TYPE) {
                return "java/lang/Boolean";
            }
            if (clazz == Byte.TYPE) {
                return "java/lang/Byte";
            }
            if (clazz == Short.TYPE) {
                return "java/lang/Short";
            }
            if (clazz == Character.TYPE) {
                return "java/lang/Character";
            }
            if (clazz == Integer.TYPE) {
                return "java/lang/Integer";
            }
            if (clazz == Long.TYPE) {
                return "java/lang/Long";
            }
            if (clazz == Float.TYPE) {
                return "java/lang/Float";
            }
            if (clazz == Double.TYPE) {
                return "java/lang/Double";
            }
            return null;
        }

        private char utf8Info(String string) {
            String string2 = this.toUtf8(string);
            int n = string2.length();
            return this.poolIndex("\u0001" + (char)(n >> 8) + (char)(n & 0xFF) + string2);
        }

        private char classInfo(String string) {
            char c = this.utf8Info(string);
            char[] cArray = new char[]{'\u0007', (char)(c >> 8), (char)(c & 0xFF)};
            return this.poolIndex(new String(cArray));
        }

        private char classInfo(Class clazz) {
            return this.classInfo(TypeSignature.getEncodingOfClass(clazz.getName(), false));
        }

        private char refInfo(byte by, String string, String string2, String string3) {
            char c = this.classInfo(string);
            char c2 = this.nameAndTypeInfo(string2, string3);
            char[] cArray = new char[]{(char)(by + 8), (char)(c >> 8), (char)(c & 0xFF), (char)(c2 >> 8), (char)(c2 & 0xFF)};
            return this.poolIndex(new String(cArray));
        }

        private char nameAndTypeInfo(String string, String string2) {
            char c = this.utf8Info(string);
            char c2 = this.utf8Info(string2);
            char[] cArray = new char[]{'\f', (char)(c >> 8), (char)(c & 0xFF), (char)(c2 >> 8), (char)(c2 & 0xFF)};
            return this.poolIndex(new String(cArray));
        }

        private String toUtf8(String string) {
            int n;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            for (n = 0; n < n2 && cArray[n] != '\u0000' && cArray[n] <= '\u007f'; ++n) {
            }
            if (n == n2) {
                return string;
            }
            CPStringBuilder cPStringBuilder = new CPStringBuilder(string);
            cPStringBuilder.setLength(n);
            while (n < n2) {
                char c = cArray[n];
                if (c > '\u0000' && c <= '\u007f') {
                    cPStringBuilder.append(c);
                } else if (c <= '\u07ff') {
                    cPStringBuilder.append((char)(0xC0 | c >> 6));
                    cPStringBuilder.append((char)(0x80 | c & 0x6F));
                } else {
                    cPStringBuilder.append((char)(0xE0 | c >> 12));
                    cPStringBuilder.append((char)(0x80 | c >> 6 & 0x6F));
                    cPStringBuilder.append((char)(0x80 | c & 0x6F));
                }
                ++n;
            }
            return cPStringBuilder.toString();
        }

        private char poolIndex(String string) {
            Integer n = (Integer)this.poolEntries.get(string);
            if (n == null) {
                int n2 = this.poolEntries.size() + 1;
                if (n2 >= 65535) {
                    throw new IllegalArgumentException("exceeds VM limitations");
                }
                n = n2;
                this.poolEntries.put(string, n);
                this.pool.append(string);
            }
            return (char)n.intValue();
        }
    }

    static final class ProxyData {
        String pack = "";
        Class[] interfaces;
        Method[] methods;
        Class[][] exceptions;
        private static int count;
        final int id = count++;

        ProxyData() {
        }

        private static String getPackage(Class clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            return string.substring(0, n + 1);
        }

        static ProxyData getProxyData(ProxyType proxyType) {
            Object object;
            Object object2;
            Map map = (Map)ProxySignature.coreMethods.clone();
            boolean bl = false;
            ProxyData proxyData = new ProxyData();
            proxyData.interfaces = proxyType.interfaces;
            int n = proxyData.interfaces.length;
            while (--n >= 0) {
                object2 = proxyData.interfaces[n];
                if (!((Class)object2).isInterface()) {
                    throw new IllegalArgumentException("not an interface: " + object2);
                }
                try {
                    if (Class.forName(((Class)object2).getName(), false, proxyType.loader) != object2) {
                        throw new IllegalArgumentException("not accessible in classloader: " + object2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("not accessible in classloader: " + object2);
                }
                if (!Modifier.isPublic(((Class)object2).getModifiers())) {
                    if (bl) {
                        object = ProxyData.getPackage((Class)object2);
                        if (!proxyData.pack.equals(object)) {
                            throw new IllegalArgumentException("non-public interfaces from different packages");
                        }
                    } else {
                        bl = true;
                        proxyData.pack = ProxyData.getPackage((Class)object2);
                    }
                }
                for (int i = n - 1; i >= 0; --i) {
                    if (proxyData.interfaces[i] != object2) continue;
                    throw new IllegalArgumentException("duplicate interface: " + object2);
                }
                object = ((Class)object2).getMethods();
                int n2 = ((Method[])object).length;
                while (--n2 >= 0) {
                    ProxySignature proxySignature;
                    ProxySignature proxySignature2;
                    if (ProxyData.isCoreObjectMethod(object[n2]) || (proxySignature2 = map.put(proxySignature = new ProxySignature(object[n2]), proxySignature)) == null) continue;
                    proxySignature.checkCompatibility(proxySignature2);
                }
            }
            n = map.size();
            proxyData.methods = new Method[n];
            proxyData.exceptions = new Class[n][];
            object2 = map.values().iterator();
            while (--n >= 0) {
                object = (ProxySignature)object2.next();
                proxyData.methods[n] = object.method;
                proxyData.exceptions[n] = object.exceptions.toArray(new Class[object.exceptions.size()]);
            }
            return proxyData;
        }

        private static boolean isCoreObjectMethod(Method method) {
            String string = method.getName();
            if (string.equals("equals")) {
                return Arrays.equals(method.getParameterTypes(), new Class[]{Object.class});
            }
            if (string.equals("hashCode")) {
                return method.getParameterTypes().length == 0;
            }
            if (string.equals("toString")) {
                return method.getParameterTypes().length == 0;
            }
            return false;
        }
    }

    private static final class ProxySignature {
        static final HashMap coreMethods = new HashMap();
        final Method method;
        final Set exceptions = new HashSet();

        ProxySignature(Method method) {
            this.method = method;
            Class<?>[] classArray = method.getExceptionTypes();
            int n = classArray.length;
            while (--n >= 0) {
                if (Error.class.isAssignableFrom(classArray[n]) || RuntimeException.class.isAssignableFrom(classArray[n])) continue;
                this.exceptions.add(classArray[n]);
            }
        }

        void checkCompatibility(ProxySignature proxySignature) {
            if (this.method.getReturnType() != proxySignature.method.getReturnType()) {
                throw new IllegalArgumentException("incompatible return types: " + this.method + ", " + proxySignature.method);
            }
            int n = this.exceptions.size();
            int n2 = proxySignature.exceptions.size();
            boolean[] blArray = new boolean[n];
            boolean[] blArray2 = new boolean[n2];
            Iterator iterator = this.exceptions.iterator();
            int n3 = n;
            while (--n3 >= 0) {
                Class clazz = (Class)iterator.next();
                Iterator iterator2 = proxySignature.exceptions.iterator();
                int n4 = n2;
                while (--n4 >= 0) {
                    Class clazz2 = (Class)iterator2.next();
                    if (clazz2.isAssignableFrom(clazz)) {
                        blArray[n3] = true;
                    }
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    blArray2[n4] = true;
                }
            }
            n3 = n;
            iterator = this.exceptions.iterator();
            while (--n3 >= 0) {
                iterator.next();
                if (blArray[n3]) continue;
                iterator.remove();
            }
            n3 = n2;
            iterator = proxySignature.exceptions.iterator();
            while (--n3 >= 0) {
                iterator.next();
                if (blArray2[n3]) continue;
                iterator.remove();
            }
            this.exceptions.addAll(proxySignature.exceptions);
        }

        public int hashCode() {
            int n = this.method.getName().hashCode();
            Class<?>[] classArray = this.method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                n = n * 31 + classArray[i].hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            ProxySignature proxySignature = (ProxySignature)object;
            Class<?>[] classArray = this.method.getParameterTypes();
            Class<?>[] classArray2 = proxySignature.method.getParameterTypes();
            if (!this.method.getName().equals(proxySignature.method.getName()) || classArray.length != classArray2.length) {
                return false;
            }
            int n = classArray.length;
            while (--n >= 0) {
                if (classArray[n] == classArray2[n]) continue;
                return false;
            }
            return true;
        }

        static {
            try {
                ProxySignature proxySignature = new ProxySignature(Object.class.getMethod("equals", Object.class));
                coreMethods.put(proxySignature, proxySignature);
                proxySignature = new ProxySignature(Object.class.getMethod("hashCode", new Class[0]));
                coreMethods.put(proxySignature, proxySignature);
                proxySignature = new ProxySignature(Object.class.getMethod("toString", new Class[0]));
                coreMethods.put(proxySignature, proxySignature);
            }
            catch (Exception exception) {
                throw (Error)new InternalError("Unexpected: " + exception).initCause(exception);
            }
        }
    }

    private static final class ProxyType {
        final ClassLoader loader;
        final Class[] interfaces;

        ProxyType(ClassLoader classLoader, Class[] classArray) {
            this.loader = classLoader;
            this.interfaces = classArray;
        }

        public int hashCode() {
            int n = this.loader == null ? 0 : this.loader.hashCode();
            for (int i = 0; i < this.interfaces.length; ++i) {
                n = n * 31 + this.interfaces[i].hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            ProxyType proxyType = (ProxyType)object;
            if (this.loader != proxyType.loader || this.interfaces.length != proxyType.interfaces.length) {
                return false;
            }
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (this.interfaces[i] == proxyType.interfaces[i]) continue;
                return false;
            }
            return true;
        }
    }
}

