/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.CPStringBuilder;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    static final int SUPER = 32;
    static final int ALL_FLAGS = 4095;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ENUM = 16384;

    public static boolean isAbstract(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean isFinal(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isInterface(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean isNative(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean isPrivate(int n) {
        return (n & 2) != 0;
    }

    public static boolean isProtected(int n) {
        return (n & 4) != 0;
    }

    public static boolean isPublic(int n) {
        return (n & 1) != 0;
    }

    public static boolean isStatic(int n) {
        return (n & 8) != 0;
    }

    public static boolean isStrict(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean isSynchronized(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isTransient(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean isVolatile(int n) {
        return (n & 0x40) != 0;
    }

    public static String toString(int n) {
        return Modifier.toString(n, new CPStringBuilder()).toString();
    }

    static CPStringBuilder toString(int n, CPStringBuilder cPStringBuilder) {
        if (Modifier.isPublic(n)) {
            cPStringBuilder.append("public ");
        }
        if (Modifier.isProtected(n)) {
            cPStringBuilder.append("protected ");
        }
        if (Modifier.isPrivate(n)) {
            cPStringBuilder.append("private ");
        }
        if (Modifier.isAbstract(n)) {
            cPStringBuilder.append("abstract ");
        }
        if (Modifier.isStatic(n)) {
            cPStringBuilder.append("static ");
        }
        if (Modifier.isFinal(n)) {
            cPStringBuilder.append("final ");
        }
        if (Modifier.isTransient(n)) {
            cPStringBuilder.append("transient ");
        }
        if (Modifier.isVolatile(n)) {
            cPStringBuilder.append("volatile ");
        }
        if (Modifier.isSynchronized(n)) {
            cPStringBuilder.append("synchronized ");
        }
        if (Modifier.isNative(n)) {
            cPStringBuilder.append("native ");
        }
        if (Modifier.isStrict(n)) {
            cPStringBuilder.append("strictfp ");
        }
        if (Modifier.isInterface(n)) {
            cPStringBuilder.append("interface ");
        }
        if ((n & 0xFFF) != 0) {
            cPStringBuilder.setLength(cPStringBuilder.length() - 1);
        }
        return cPStringBuilder;
    }
}

