/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.CPStringBuilder;
import gnu.java.lang.ClassHelper;
import gnu.java.lang.reflect.MethodSignatureParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.VMConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    private static final int CONSTRUCTOR_MODIFIERS = 7;
    private MethodSignatureParser p;
    VMConstructor cons;

    Constructor(VMConstructor vMConstructor) {
        this.cons = vMConstructor;
        vMConstructor.cons = this;
    }

    private Constructor() {
    }

    @Override
    public Class<T> getDeclaringClass() {
        Class clazz = this.cons.getDeclaringClass();
        return clazz;
    }

    @Override
    public String getName() {
        return this.cons.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return this.cons.getModifiersInternal() & 7;
    }

    @Override
    public boolean isSynthetic() {
        return (this.cons.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.cons.getModifiersInternal() & 0x80) != 0;
    }

    public Class<?>[] getParameterTypes() {
        return this.cons.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return this.cons.getExceptionTypes();
    }

    public boolean equals(Object object) {
        return this.cons.equals(object);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(128);
        Modifier.toString(this.getModifiers(), cPStringBuilder).append(' ');
        cPStringBuilder.append(this.getDeclaringClass().getName()).append('(');
        Class<?>[] classArray = this.getParameterTypes();
        if (classArray.length > 0) {
            cPStringBuilder.append(ClassHelper.getUserName(classArray[0]));
            for (n = 1; n < classArray.length; ++n) {
                cPStringBuilder.append(',').append(ClassHelper.getUserName(classArray[n]));
            }
        }
        cPStringBuilder.append(')');
        classArray = this.getExceptionTypes();
        if (classArray.length > 0) {
            cPStringBuilder.append(" throws ").append(classArray[0].getName());
            for (n = 1; n < classArray.length; ++n) {
                cPStringBuilder.append(',').append(classArray[n].getName());
            }
        }
        return cPStringBuilder.toString();
    }

    static <X extends GenericDeclaration> void addTypeParameters(CPStringBuilder cPStringBuilder, TypeVariable<X>[] typeVariableArray) {
        if (typeVariableArray.length == 0) {
            return;
        }
        cPStringBuilder.append('<');
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(',');
            }
            cPStringBuilder.append(typeVariableArray[i]);
        }
        cPStringBuilder.append("> ");
    }

    public String toGenericString() {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(128);
        Modifier.toString(this.getModifiers(), cPStringBuilder).append(' ');
        Constructor.addTypeParameters(cPStringBuilder, this.getTypeParameters());
        cPStringBuilder.append(this.getDeclaringClass().getName()).append('(');
        Type[] typeArray = this.getGenericParameterTypes();
        if (typeArray.length > 0) {
            cPStringBuilder.append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                cPStringBuilder.append(',').append(typeArray[n]);
            }
        }
        cPStringBuilder.append(')');
        typeArray = this.getGenericExceptionTypes();
        if (typeArray.length > 0) {
            cPStringBuilder.append(" throws ").append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                cPStringBuilder.append(',').append(typeArray[n]);
            }
        }
        return cPStringBuilder.toString();
    }

    public T newInstance(Object ... objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object = this.cons.construct(objectArray);
        return (T)object;
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        if (this.p == null) {
            String string = this.cons.getSignature();
            if (string == null) {
                return new TypeVariable[0];
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getTypeParameters();
    }

    public Type[] getGenericExceptionTypes() {
        if (this.p == null) {
            String string = this.cons.getSignature();
            if (string == null) {
                return this.getExceptionTypes();
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getGenericExceptionTypes();
    }

    public Type[] getGenericParameterTypes() {
        if (this.p == null) {
            String string = this.cons.getSignature();
            if (string == null) {
                return this.getParameterTypes();
            }
            this.p = new MethodSignatureParser(this, string);
        }
        return this.p.getGenericParameterTypes();
    }

    public Annotation[][] getParameterAnnotations() {
        return this.cons.getParameterAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Annotation annotation = this.cons.getAnnotation(clazz);
        return (T)annotation;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.cons.getDeclaredAnnotations();
    }
}

