/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.VMArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array {
    private Array() {
    }

    public static Object newInstance(Class<?> clazz, int n) {
        if (!clazz.isPrimitive()) {
            return VMArray.createObjectArray(clazz, n);
        }
        if (clazz == Boolean.TYPE) {
            return new boolean[n];
        }
        if (clazz == Byte.TYPE) {
            return new byte[n];
        }
        if (clazz == Character.TYPE) {
            return new char[n];
        }
        if (clazz == Short.TYPE) {
            return new short[n];
        }
        if (clazz == Integer.TYPE) {
            return new int[n];
        }
        if (clazz == Long.TYPE) {
            return new long[n];
        }
        if (clazz == Float.TYPE) {
            return new float[n];
        }
        if (clazz == Double.TYPE) {
            return new double[n];
        }
        throw new IllegalArgumentException();
    }

    public static Object newInstance(Class<?> clazz, int[] nArray) {
        if (nArray.length <= 0) {
            throw new IllegalArgumentException("Empty dimensions array.");
        }
        return Array.createMultiArray(clazz, nArray, 0);
    }

    public static int getLength(Object object) {
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof char[]) {
            return ((char[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static Object get(Object object, int n) {
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object)[n] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        if (object instanceof char[]) {
            return Character.valueOf(((char[])object)[n]);
        }
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        if (object instanceof long[]) {
            return ((long[])object)[n];
        }
        if (object instanceof float[]) {
            return Float.valueOf(((float[])object)[n]);
        }
        if (object instanceof double[]) {
            return ((double[])object)[n];
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static boolean getBoolean(Object object, int n) {
        if (object instanceof boolean[]) {
            return ((boolean[])object)[n];
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static byte getByte(Object object, int n) {
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static char getChar(Object object, int n) {
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        if (object == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException();
    }

    public static short getShort(Object object, int n) {
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        return Array.getByte(object, n);
    }

    public static int getInt(Object object, int n) {
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        return Array.getShort(object, n);
    }

    public static long getLong(Object object, int n) {
        if (object instanceof long[]) {
            return ((long[])object)[n];
        }
        return Array.getInt(object, n);
    }

    public static float getFloat(Object object, int n) {
        if (object instanceof float[]) {
            return ((float[])object)[n];
        }
        return Array.getLong(object, n);
    }

    public static double getDouble(Object object, int n) {
        if (object instanceof double[]) {
            return ((double[])object)[n];
        }
        return Array.getFloat(object, n);
    }

    public static void set(Object object, int n, Object object2) {
        if (object instanceof Object[]) {
            if (object2 != null && !object.getClass().getComponentType().isInstance(object2)) {
                throw new IllegalArgumentException();
            }
            ((Object[])object)[n] = object2;
        } else if (object2 instanceof Byte) {
            Array.setByte(object, n, (Byte)object2);
        } else if (object2 instanceof Short) {
            Array.setShort(object, n, (Short)object2);
        } else if (object2 instanceof Integer) {
            Array.setInt(object, n, (Integer)object2);
        } else if (object2 instanceof Long) {
            Array.setLong(object, n, (Long)object2);
        } else if (object2 instanceof Float) {
            Array.setFloat(object, n, ((Float)object2).floatValue());
        } else if (object2 instanceof Double) {
            Array.setDouble(object, n, (Double)object2);
        } else if (object2 instanceof Character) {
            Array.setChar(object, n, ((Character)object2).charValue());
        } else if (object2 instanceof Boolean) {
            Array.setBoolean(object, n, (Boolean)object2);
        } else {
            if (object == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException();
        }
    }

    public static void setBoolean(Object object, int n, boolean bl) {
        if (!(object instanceof boolean[])) {
            if (object == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException();
        }
        ((boolean[])object)[n] = bl;
    }

    public static void setByte(Object object, int n, byte by) {
        if (object instanceof byte[]) {
            ((byte[])object)[n] = by;
        } else {
            Array.setShort(object, n, by);
        }
    }

    public static void setChar(Object object, int n, char c) {
        if (object instanceof char[]) {
            ((char[])object)[n] = c;
        } else {
            Array.setInt(object, n, c);
        }
    }

    public static void setShort(Object object, int n, short s) {
        if (object instanceof short[]) {
            ((short[])object)[n] = s;
        } else {
            Array.setInt(object, n, s);
        }
    }

    public static void setInt(Object object, int n, int n2) {
        if (object instanceof int[]) {
            ((int[])object)[n] = n2;
        } else {
            Array.setLong(object, n, n2);
        }
    }

    public static void setLong(Object object, int n, long l) {
        if (object instanceof long[]) {
            ((long[])object)[n] = l;
        } else {
            Array.setFloat(object, n, l);
        }
    }

    public static void setFloat(Object object, int n, float f) {
        if (object instanceof float[]) {
            ((float[])object)[n] = f;
        } else {
            Array.setDouble(object, n, f);
        }
    }

    public static void setDouble(Object object, int n, double d) {
        if (!(object instanceof double[])) {
            if (object == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException();
        }
        ((double[])object)[n] = d;
    }

    private static Object createMultiArray(Class clazz, int[] nArray, int n) {
        if (n == nArray.length - 1) {
            return Array.newInstance(clazz, nArray[n]);
        }
        Object object = Array.createMultiArray(clazz, nArray, n + 1);
        Class<? extends Object> clazz2 = object.getClass();
        Object[] objectArray = (Object[])VMArray.createObjectArray(clazz2, nArray[n]);
        if (nArray[n] > 0) {
            objectArray[0] = object;
        }
        int n2 = nArray[n];
        while (--n2 > 0) {
            objectArray[n2] = Array.createMultiArray(clazz, nArray, n + 1);
        }
        return objectArray;
    }
}

