/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;

public class MonitorInfo
extends LockInfo {
    private int stackDepth;
    private StackTraceElement stackFrame;

    public MonitorInfo(String string, int n, int n2, StackTraceElement stackTraceElement) {
        super(string, n);
        if (stackTraceElement == null && n2 >= 0) {
            throw new IllegalArgumentException("The stack frame is null, but the stack depth is greater than or equal to zero.");
        }
        if (stackTraceElement != null && n2 < 0) {
            throw new IllegalArgumentException("The stack frame is not null, but the stack depth is less than zero.");
        }
        this.stackDepth = n2;
        this.stackFrame = stackTraceElement;
    }

    public static MonitorInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        CompositeType compositeType = compositeData.getCompositeType();
        ThreadInfo.checkAttribute(compositeType, "ClassName", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "IdentityHashCode", SimpleType.INTEGER);
        ThreadInfo.checkAttribute(compositeType, "LockedStackDepth", SimpleType.INTEGER);
        ThreadInfo.checkAttribute(compositeType, "LockedStackFrame", ThreadInfo.getStackTraceType());
        CompositeData compositeData2 = (CompositeData)compositeData.get("LockedStackFrame");
        return new MonitorInfo((String)compositeData.get("ClassName"), (Integer)compositeData.get("IdentityHashCode"), (Integer)compositeData.get("LockedStackDepth"), new StackTraceElement((String)compositeData2.get("ClassName"), (String)compositeData2.get("MethodName"), (String)compositeData2.get("FileName"), (Integer)compositeData2.get("LineNumber")));
    }

    public int getLockedStackDepth() {
        return this.stackDepth;
    }

    public StackTraceElement getLockedStackFrame() {
        return this.stackFrame;
    }
}

