/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.ClassLoadingMXBeanImpl;
import gnu.java.lang.management.CompilationMXBeanImpl;
import gnu.java.lang.management.GarbageCollectorMXBeanImpl;
import gnu.java.lang.management.MemoryMXBeanImpl;
import gnu.java.lang.management.MemoryManagerMXBeanImpl;
import gnu.java.lang.management.MemoryPoolMXBeanImpl;
import gnu.java.lang.management.OperatingSystemMXBeanImpl;
import gnu.java.lang.management.RuntimeMXBeanImpl;
import gnu.java.lang.management.ThreadMXBeanImpl;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.management.VMManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    private static OperatingSystemMXBean osBean;
    private static RuntimeMXBean runtimeBean;
    private static ClassLoadingMXBean classLoadingBean;
    private static ThreadMXBean threadBean;
    private static MemoryMXBean memoryBean;
    private static CompilationMXBean compilationBean;
    private static MBeanServer platformServer;

    private ManagementFactory() {
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        if (osBean == null) {
            try {
                osBean = new OperatingSystemMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the operating system bean is not a compliant management bean.");
            }
        }
        return osBean;
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        if (runtimeBean == null) {
            try {
                runtimeBean = new RuntimeMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the runtime bean is not a compliant management bean.");
            }
        }
        return runtimeBean;
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        if (classLoadingBean == null) {
            try {
                classLoadingBean = new ClassLoadingMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the class loading bean is not a compliant management bean.");
            }
        }
        return classLoadingBean;
    }

    public static ThreadMXBean getThreadMXBean() {
        if (threadBean == null) {
            try {
                threadBean = new ThreadMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the thread bean is not a compliant management bean.");
            }
        }
        return threadBean;
    }

    public static MemoryMXBean getMemoryMXBean() {
        if (memoryBean == null) {
            try {
                memoryBean = new MemoryMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory bean is not a compliant management bean.");
            }
        }
        return memoryBean;
    }

    public static CompilationMXBean getCompilationMXBean() {
        if (compilationBean == null && SystemProperties.getProperty("gnu.java.compiler.name") != null) {
            try {
                compilationBean = new CompilationMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the compilation bean is not a compliant management bean.");
            }
        }
        return compilationBean;
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        ArrayList<MemoryPoolMXBean> arrayList = new ArrayList<MemoryPoolMXBean>();
        String[] stringArray = VMManagementFactory.getMemoryPoolNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new MemoryPoolMXBeanImpl(stringArray[i]));
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory pool bean, " + i + ", is " + "not a compliant management bean.");
            }
        }
        return arrayList;
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        ArrayList<MemoryManagerMXBean> arrayList = new ArrayList<MemoryManagerMXBean>();
        String[] stringArray = VMManagementFactory.getMemoryManagerNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new MemoryManagerMXBeanImpl(stringArray[i]));
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory manager bean, " + i + ", is " + "not a compliant management bean.");
            }
        }
        arrayList.addAll(ManagementFactory.getGarbageCollectorMXBeans());
        return arrayList;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        ArrayList<GarbageCollectorMXBean> arrayList = new ArrayList<GarbageCollectorMXBean>();
        String[] stringArray = VMManagementFactory.getGarbageCollectorNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new GarbageCollectorMXBeanImpl(stringArray[i]));
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the garbage collector bean, " + i + ", is not a compliant management " + "bean.");
            }
        }
        return arrayList;
    }

    public static MBeanServer getPlatformMBeanServer() {
        if (platformServer == null) {
            platformServer = MBeanServerFactory.createMBeanServer();
            try {
                platformServer.registerMBean(ManagementFactory.getOperatingSystemMXBean(), new ObjectName(OPERATING_SYSTEM_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getRuntimeMXBean(), new ObjectName(RUNTIME_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getClassLoadingMXBean(), new ObjectName(CLASS_LOADING_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getThreadMXBean(), new ObjectName(THREAD_MXBEAN_NAME));
                platformServer.registerMBean(ManagementFactory.getMemoryMXBean(), new ObjectName(MEMORY_MXBEAN_NAME));
                CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
                if (compilationMXBean != null) {
                    platformServer.registerMBean(compilationMXBean, new ObjectName(COMPILATION_MXBEAN_NAME));
                }
                for (MemoryPoolMXBean object : ManagementFactory.getMemoryPoolMXBeans()) {
                    platformServer.registerMBean(object, new ObjectName("java.lang:type=MemoryPool,name=" + object.getName()));
                }
                for (MemoryManagerMXBean memoryManagerMXBean : ManagementFactory.getMemoryManagerMXBeans()) {
                    platformServer.registerMBean(memoryManagerMXBean, new ObjectName("java.lang:type=MemoryManager,name=" + memoryManagerMXBean.getName()));
                }
                for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    platformServer.registerMBean(garbageCollectorMXBean, new ObjectName("java.lang:type=GarbageCollector,name=" + garbageCollectorMXBean.getName()));
                }
                platformServer.registerMBean(LogManager.getLoggingMXBean(), new ObjectName("java.util.logging:type=Logging"));
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                throw (Error)new InternalError("One of the management beans is already registered.").initCause(instanceAlreadyExistsException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                throw (Error)new InternalError("One of the management beans' preRegister methods threw an exception.").initCause(mBeanRegistrationException);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw (Error)new InternalError("One of the management beans is not compliant.").initCause(notCompliantMBeanException);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw (Error)new InternalError("The object name of a management bean is not compliant.").initCause(malformedObjectNameException);
            }
        }
        return platformServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        ObjectName objectName;
        if (!(string.equals(CLASS_LOADING_MXBEAN_NAME) || string.equals(COMPILATION_MXBEAN_NAME) || string.startsWith(GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE) || string.startsWith(MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE) || string.equals(MEMORY_MXBEAN_NAME) || string.startsWith(MEMORY_POOL_MXBEAN_DOMAIN_TYPE) || string.equals(OPERATING_SYSTEM_MXBEAN_NAME) || string.equals(RUNTIME_MXBEAN_NAME) || string.equals(THREAD_MXBEAN_NAME))) {
            throw new IllegalArgumentException("The named bean, " + string + ", is not a platform name.");
        }
        if (string.equals(CLASS_LOADING_MXBEAN_NAME) && clazz != ClassLoadingMXBean.class || string.equals(COMPILATION_MXBEAN_NAME) && clazz != CompilationMXBean.class || string.startsWith(GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE) && clazz != GarbageCollectorMXBean.class || string.startsWith(MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE) && clazz != MemoryManagerMXBean.class || string.equals(MEMORY_MXBEAN_NAME) && clazz != MemoryMXBean.class || string.startsWith(MEMORY_POOL_MXBEAN_DOMAIN_TYPE) && clazz != MemoryPoolMXBean.class || string.equals(OPERATING_SYSTEM_MXBEAN_NAME) && clazz != OperatingSystemMXBean.class || string.equals(RUNTIME_MXBEAN_NAME) && clazz != RuntimeMXBean.class || string.equals(THREAD_MXBEAN_NAME) && clazz != ThreadMXBean.class) {
            throw new IllegalArgumentException("The interface, " + clazz + ", does not match the bean, " + string);
        }
        try {
            objectName = new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("The named bean is invalid.");
        }
        if (!mBeanServerConnection.isRegistered(objectName)) {
            throw new IllegalArgumentException("The bean is not registered on this connection.");
        }
        Class[] classArray = string.equals(MEMORY_MXBEAN_NAME) ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), classArray, new ManagementInvocationHandler(mBeanServerConnection, objectName));
    }

    private static class ManagementInvocationHandler
    implements InvocationHandler {
        private MBeanServerConnection conn;
        private ObjectName bean;

        public ManagementInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException {
            this.conn = mBeanServerConnection;
            this.bean = objectName;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("toString")) {
                return "Proxy for " + this.bean + " using " + this.conn;
            }
            if (string.equals("addNotificationListener")) {
                this.conn.addNotificationListener(this.bean, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                return null;
            }
            if (string.equals("getNotificationInfo")) {
                return this.conn.getMBeanInfo(this.bean).getNotifications();
            }
            if (string.equals("removeNotificationListener")) {
                if (objectArray.length == 1) {
                    this.conn.removeNotificationListener(this.bean, (NotificationListener)objectArray[0]);
                } else {
                    this.conn.removeNotificationListener(this.bean, (NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                }
                return null;
            }
            String string2 = null;
            if (string.startsWith("get")) {
                string2 = string.substring(3);
            } else if (string.startsWith("is")) {
                string2 = string.substring(2);
            }
            if (string2 != null) {
                return this.translate(this.conn.getAttribute(this.bean, string2), method);
            }
            if (string.startsWith("set")) {
                this.conn.setAttribute(this.bean, new Attribute(string.substring(3), objectArray[0]));
                return null;
            }
            return this.translate(this.conn.invoke(this.bean, string, objectArray, null), method);
        }

        private final Object translate(Object object, Method method) throws Throwable {
            Object object2;
            Object object3;
            Class<?> clazz = method.getReturnType();
            if (clazz.isEnum()) {
                object3 = (Object[])object;
                for (Object object4 : object2 = (Enum[])clazz.getEnumConstants()) {
                    if (!((Enum)object4).name().equals(object3)) continue;
                    return object4;
                }
            }
            if (List.class.isAssignableFrom(clazz)) {
                object3 = (Object[])object;
                object2 = new ArrayList(((Object[])object3).length);
                for (Object object4 : object3) {
                    object2.add(object4);
                }
                return object2;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                object3 = (TabularData)object;
                object2 = new HashMap(object3.size());
                for (Object e : object3.values()) {
                    CompositeData compositeData = (CompositeData)e;
                    object2.put(compositeData.get("key"), compositeData.get("value"));
                }
                return object2;
            }
            try {
                object3 = clazz.getMethod("from", CompositeData.class);
                return ((Method)object3).invoke(null, (CompositeData)object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return object;
            }
        }
    }
}

