/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class VMProcess
extends Process {
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int TERMINATED = 2;
    static Thread processThread;
    static final LinkedList workList;
    static long reapedPid;
    static int reapedExitValue;
    int state = 0;
    final String[] cmd;
    final String[] env;
    final File dir;
    Throwable exception;
    long pid;
    OutputStream stdin;
    InputStream stdout;
    InputStream stderr;
    int exitValue;
    boolean redirect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMProcess(String[] stringArray, String[] stringArray2, File file, boolean bl) throws IOException {
        this.cmd = stringArray;
        this.env = stringArray2;
        this.dir = file;
        this.redirect = bl;
        Object object = workList;
        synchronized (object) {
            workList.add(this);
            if (processThread == null) {
                processThread = new ProcessThread();
                processThread.setDaemon(true);
                processThread.start();
            } else {
                workList.notify();
            }
        }
        object = this;
        synchronized (object) {
            while (this.state == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.exception != null) {
            this.exception.fillInStackTrace();
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }
    }

    private void setProcessInfo(OutputStream outputStream, InputStream inputStream, InputStream inputStream2, long l) {
        this.stdin = outputStream;
        this.stdout = inputStream;
        this.stderr = inputStream2 == null ? new InputStream(){

            public int read() throws IOException {
                return -1;
            }
        } : inputStream2;
        this.pid = l;
    }

    static Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        return new VMProcess(stringArray, stringArray2, file, false);
    }

    static Process exec(List list2, Map map, File file, boolean bl) throws IOException {
        String[] stringArray = list2.toArray(new String[list2.size()]);
        String[] stringArray2 = new String[map.size()];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            stringArray2[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return new VMProcess(stringArray, stringArray2, file, bl);
    }

    public OutputStream getOutputStream() {
        return this.stdin;
    }

    public InputStream getInputStream() {
        return this.stdout;
    }

    public InputStream getErrorStream() {
        return this.stderr;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (this.state != 2) {
            this.wait();
        }
        return this.exitValue;
    }

    public synchronized int exitValue() {
        if (this.state != 2) {
            throw new IllegalThreadStateException();
        }
        return this.exitValue;
    }

    public synchronized void destroy() {
        if (this.state == 2) {
            return;
        }
        VMProcess.nativeKill(this.pid);
        while (this.state != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    native void nativeSpawn(String[] var1, String[] var2, File var3, boolean var4) throws IOException;

    static native boolean nativeReap();

    private static native void nativeKill(long var0);

    static {
        workList = new LinkedList();
    }

    private static class ProcessThread
    extends Thread {
        private static final int MAX_REAP_DELAY = 1000;
        private final HashMap activeMap = new HashMap();

        ProcessThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = workList;
            while (true) {
                VMProcess vMProcess = null;
                LinkedList linkedList2 = linkedList;
                synchronized (linkedList2) {
                    if (!linkedList.isEmpty()) {
                        vMProcess = (VMProcess)linkedList.removeFirst();
                    }
                }
                if (vMProcess != null) {
                    this.spawn(vMProcess);
                }
                while (!this.activeMap.isEmpty() && VMProcess.nativeReap()) {
                    long l = reapedPid;
                    int n = reapedExitValue;
                    vMProcess = (VMProcess)this.activeMap.remove(new Long(l));
                    if (vMProcess != null) {
                        VMProcess vMProcess2 = vMProcess;
                        synchronized (vMProcess2) {
                            vMProcess.exitValue = n;
                            vMProcess.state = 2;
                            vMProcess.notify();
                            continue;
                        }
                    }
                    System.err.println("VMProcess WARNING reaped unknown process: " + l);
                }
                linkedList2 = linkedList;
                synchronized (linkedList2) {
                    if (!linkedList.isEmpty()) {
                        continue;
                    }
                    if (this.activeMap.isEmpty()) {
                        processThread = null;
                        break;
                    }
                    try {
                        linkedList.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spawn(VMProcess vMProcess) {
            VMProcess vMProcess2 = vMProcess;
            synchronized (vMProcess2) {
                try {
                    vMProcess.nativeSpawn(vMProcess.cmd, vMProcess.env, vMProcess.dir, vMProcess.redirect);
                    vMProcess.state = 1;
                    this.activeMap.put(new Long(vMProcess.pid), vMProcess);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    vMProcess.state = 2;
                    vMProcess.exception = throwable;
                }
                vMProcess.notify();
            }
        }
    }
}

