/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class VMClass {
    private VMClass() {
    }

    static native boolean isInstance(Class var0, Object var1);

    static native boolean isAssignableFrom(Class var0, Class var1);

    static native boolean isInterface(Class var0);

    static native boolean isPrimitive(Class var0);

    static native String getName(Class var0);

    static native Class getSuperclass(Class var0);

    static native Class[] getInterfaces(Class var0);

    static native Class getComponentType(Class var0);

    static native int getModifiers(Class var0, boolean var1);

    static native Class getDeclaringClass(Class var0);

    static native Class[] getDeclaredClasses(Class var0, boolean var1);

    static native Field[] getDeclaredFields(Class var0, boolean var1);

    static native Method[] getDeclaredMethods(Class var0, boolean var1);

    static native Constructor[] getDeclaredConstructors(Class var0, boolean var1);

    static native ClassLoader getClassLoader(Class var0);

    static native Class forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    static native boolean isArray(Class var0);

    static native void throwException(Throwable var0);

    static String getSimpleName(Class clazz) {
        if (VMClass.isAnonymousClass(clazz)) {
            return "";
        }
        if (VMClass.isArray(clazz)) {
            return VMClass.getComponentType(clazz).getSimpleName() + "[]";
        }
        String string = VMClass.getName(clazz);
        Class clazz2 = VMClass.getEnclosingClass(clazz);
        if (clazz2 == null) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        string = string.substring(clazz2.getName().length());
        int n = 1;
        while (Character.isDigit(string.charAt(n))) {
            ++n;
        }
        string = string.substring(n);
        return string;
    }

    static native Annotation[] getDeclaredAnnotations(Class var0);

    static String getCanonicalName(Class clazz) {
        String string;
        if (VMClass.isLocalClass(clazz) || VMClass.isAnonymousClass(clazz)) {
            return null;
        }
        if (VMClass.isArray(clazz) && (string = VMClass.getComponentType(clazz).getCanonicalName()) != null) {
            return string + "[]";
        }
        if (VMClass.isMemberClass(clazz)) {
            string = VMClass.getDeclaringClass(clazz).getCanonicalName();
            if (string != null) {
                return string + "." + VMClass.getSimpleName(clazz);
            }
            return string;
        }
        return VMClass.getName(clazz);
    }

    static native Class getEnclosingClass(Class var0);

    static native Constructor getEnclosingConstructor(Class var0);

    static native Method getEnclosingMethod(Class var0);

    static native String getClassSignature(Class var0);

    static native boolean isAnonymousClass(Class var0);

    static native boolean isLocalClass(Class var0);

    static native boolean isMemberClass(Class var0);
}

