/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private final String detailMessage;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;
    private transient VMThrowable vmState;

    public Throwable() {
        this((String)null);
    }

    public Throwable(String string) {
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this(string);
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), throwable);
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException();
        }
        if (this.cause != this) {
            throw new IllegalStateException();
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getLocalizedMessage();
        return this.getClass().getName() + (string == null ? "" : ": " + string);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.print(this.stackTraceString());
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print(this.stackTraceString());
    }

    private String stackTraceString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        Throwable.stackTraceStringBuffer(cPStringBuilder, this.toString(), stackTraceElementArray, 0);
        for (Throwable throwable = this.getCause(); throwable != null; throwable = throwable.getCause()) {
            cPStringBuilder.append("Caused by: ");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray2 == null || stackTraceElementArray2.length == 0) {
                Throwable.stackTraceStringBuffer(cPStringBuilder, throwable.toString(), stackTraceElementArray, 0);
                continue;
            }
            int n = 0;
            int n2 = stackTraceElementArray.length - 1;
            for (int i = stackTraceElementArray2.length - 1; n2 > 0 && i > 0 && stackTraceElementArray[n2].equals(stackTraceElementArray2[i]); --n2, --i) {
                ++n;
            }
            Throwable.stackTraceStringBuffer(cPStringBuilder, throwable.toString(), stackTraceElementArray, n);
        }
        return cPStringBuilder.toString();
    }

    private static void stackTraceStringBuffer(CPStringBuilder cPStringBuilder, String string, StackTraceElement[] stackTraceElementArray, int n) {
        String string2 = StaticData.nl;
        cPStringBuilder.append(string);
        cPStringBuilder.append(string2);
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            cPStringBuilder.append("   <<No stacktrace available>>");
            cPStringBuilder.append(string2);
        } else {
            for (int i = 0; i < stackTraceElementArray.length - n; ++i) {
                cPStringBuilder.append("   at ");
                cPStringBuilder.append(stackTraceElementArray[i] == null ? "<<Unknown>>" : stackTraceElementArray[i].toString());
                cPStringBuilder.append(string2);
            }
            if (n > 0) {
                cPStringBuilder.append("   ...");
                cPStringBuilder.append(n);
                cPStringBuilder.append(" more");
                cPStringBuilder.append(string2);
            }
        }
    }

    public Throwable fillInStackTrace() {
        this.vmState = VMThrowable.fillInStackTrace(this);
        this.stackTrace = null;
        return this;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.stackTrace == null) {
            if (this.vmState == null) {
                this.stackTrace = new StackTraceElement[0];
            } else {
                this.stackTrace = this.vmState.getStackTrace(this);
                this.vmState = null;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        int n = stackTraceElementArray.length;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n];
        while (--n >= 0) {
            stackTraceElementArray2[n] = stackTraceElementArray[n];
            if (stackTraceElementArray2[n] != null) continue;
            throw new NullPointerException("Element " + n + " null");
        }
        this.stackTrace = stackTraceElementArray2;
    }

    private static class StaticData {
        static final String nl = SystemProperties.getProperty("line.separator");

        private StaticData() {
        }
    }
}

