/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    private static final char[] upperExpand = String.zeroBasedStringValue("SS\u02bcNJ\u030c\u0399\u0308\u0301\u03a5\u0308\u0301\u0535\u0552H\u0331T\u0308W\u030aY\u030aA\u02be\u03a5\u0313\u03a5\u0313\u0300\u03a5\u0313\u0301\u03a5\u0313\u0342\u1f08\u0399\u1f09\u0399\u1f0a\u0399\u1f0b\u0399\u1f0c\u0399\u1f0d\u0399\u1f0e\u0399\u1f0f\u0399\u1f08\u0399\u1f09\u0399\u1f0a\u0399\u1f0b\u0399\u1f0c\u0399\u1f0d\u0399\u1f0e\u0399\u1f0f\u0399\u1f28\u0399\u1f29\u0399\u1f2a\u0399\u1f2b\u0399\u1f2c\u0399\u1f2d\u0399\u1f2e\u0399\u1f2f\u0399\u1f28\u0399\u1f29\u0399\u1f2a\u0399\u1f2b\u0399\u1f2c\u0399\u1f2d\u0399\u1f2e\u0399\u1f2f\u0399\u1f68\u0399\u1f69\u0399\u1f6a\u0399\u1f6b\u0399\u1f6c\u0399\u1f6d\u0399\u1f6e\u0399\u1f6f\u0399\u1f68\u0399\u1f69\u0399\u1f6a\u0399\u1f6b\u0399\u1f6c\u0399\u1f6d\u0399\u1f6e\u0399\u1f6f\u0399\u1fba\u0399\u0391\u0399\u0386\u0399\u0391\u0342\u0391\u0342\u0399\u0391\u0399\u1fca\u0399\u0397\u0399\u0389\u0399\u0397\u0342\u0397\u0342\u0399\u0397\u0399\u0399\u0308\u0300\u0399\u0308\u0301\u0399\u0342\u0399\u0308\u0342\u03a5\u0308\u0300\u03a5\u0308\u0301\u03a1\u0313\u03a5\u0342\u03a5\u0308\u0342\u1ffa\u0399\u03a9\u0399\u038f\u0399\u03a9\u0342\u03a9\u0342\u0399\u03a9\u0399FFFIFLFFIFFLSTST\u0544\u0546\u0544\u0535\u0544\u053b\u054e\u0546\u0544\u053d");
    private static final char[] upperSpecial = String.zeroBasedStringValue("\u00df\u0000\u0149\u0002\u01f0\u0004\u0390\u0006\u03b0\t\u0587\f\u1e96\u000e\u1e97\u0010\u1e98\u0012\u1e99\u0014\u1e9a\u0016\u1f50\u0018\u1f52\u001a\u1f54\u001d\u1f56 \u1f80#\u1f81%\u1f82'\u1f83)\u1f84+\u1f85-\u1f86/\u1f871\u1f883\u1f895\u1f8a7\u1f8b9\u1f8c;\u1f8d=\u1f8e?\u1f8fA\u1f90C\u1f91E\u1f92G\u1f93I\u1f94K\u1f95M\u1f96O\u1f97Q\u1f98S\u1f99U\u1f9aW\u1f9bY\u1f9c[\u1f9d]\u1f9e_\u1f9fa\u1fa0c\u1fa1e\u1fa2g\u1fa3i\u1fa4k\u1fa5m\u1fa6o\u1fa7q\u1fa8s\u1fa9u\u1faaw\u1faby\u1fac{\u1fad}\u1fae\u007f\u1faf\u0081\u1fb2\u0083\u1fb3\u0085\u1fb4\u0087\u1fb6\u0089\u1fb7\u008b\u1fbc\u008e\u1fc2\u0090\u1fc3\u0092\u1fc4\u0094\u1fc6\u0096\u1fc7\u0098\u1fcc\u009b\u1fd2\u009d\u1fd3\u00a0\u1fd6\u00a3\u1fd7\u00a5\u1fe2\u00a8\u1fe3\u00ab\u1fe4\u00ae\u1fe6\u00b0\u1fe7\u00b2\u1ff2\u00b5\u1ff3\u00b7\u1ff4\u00b9\u1ff6\u00bb\u1ff7\u00bd\u1ffc\u00c0\ufb00\u00c2\ufb01\u00c4\ufb02\u00c6\ufb03\u00c8\ufb04\u00cb\ufb05\u00ce\ufb06\u00d0\ufb13\u00d2\ufb14\u00d4\ufb15\u00d6\ufb16\u00d8\ufb17\u00da");
    final char[] value;
    final int count;
    private int cachedHashCode;
    final int offset;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public String() {
        this.value = "".value;
        this.offset = 0;
        this.count = 0;
    }

    public String(String string) {
        this.value = string.value;
        this.offset = string.offset;
        this.count = string.count;
        this.cachedHashCode = string.cachedHashCode;
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length, false);
    }

    public String(char[] cArray, int n, int n2) {
        this(cArray, n, n2, false);
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n3);
        }
        if (byArray.length - n2 < n3) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n2 + n3));
        }
        this.value = new char[n3];
        this.offset = 0;
        this.count = n3;
        n <<= 8;
        n2 += n3;
        while (--n3 >= 0) {
            this.value[n3] = (char)(n | byArray[--n2] & 0xFF);
        }
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this(byArray, n, n2, String.stringToCharset(string));
    }

    private static final Charset stringToCharset(String string) throws UnsupportedEncodingException {
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException("Encoding: " + string + " not found.");
        }
    }

    public String(byte[] byArray, int n, int n2, Charset charset) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n2);
        }
        if (byArray.length - n < n2) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n + n2));
        }
        try {
            CharsetDecoder charsetDecoder = charset.newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray, n, n2));
            if (charBuffer.hasArray()) {
                this.value = charBuffer.array();
                this.offset = charBuffer.position();
                this.count = charBuffer.remaining();
            } else {
                this.value = new char[charBuffer.remaining()];
                charBuffer.get(this.value);
                this.offset = 0;
                this.count = this.value.length;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw (InternalError)new InternalError().initCause(characterCodingException);
        }
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, Charset charset) {
        this(byArray, 0, byArray.length, charset);
    }

    public String(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        char[] cArray;
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n2);
        }
        if (byArray.length - n < n2) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n + n2));
        }
        try {
            String string = System.getProperty("file.encoding");
            CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray, n, n2));
            if (charBuffer.hasArray()) {
                cArray = charBuffer.array();
                n4 = charBuffer.position();
                n3 = charBuffer.remaining();
            } else {
                cArray = new char[charBuffer.remaining()];
                charBuffer.get(cArray);
                n4 = 0;
                n3 = cArray.length;
            }
        }
        catch (Exception exception) {
            cArray = new char[n2];
            n4 = 0;
            n3 = n2;
            for (int i = 0; i < n2; ++i) {
                cArray[i] = (char)byArray[n + i];
            }
        }
        this.value = cArray;
        this.offset = n4;
        this.count = n3;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            this.offset = 0;
            this.count = stringBuffer.count;
            if (this.count << 2 < stringBuffer.value.length) {
                this.value = new char[this.count];
                VMSystem.arraycopy(stringBuffer.value, 0, this.value, 0, this.count);
            } else {
                stringBuffer.shared = true;
                this.value = stringBuffer.value;
            }
        }
    }

    public String(StringBuilder stringBuilder) {
        this(stringBuilder.value, 0, stringBuilder.count);
    }

    String(char[] cArray, int n, int n2, boolean bl) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n2);
        }
        if (cArray.length - n < n2) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n + n2));
        }
        if (bl) {
            this.value = cArray;
            this.offset = n;
        } else {
            this.value = new char[n2];
            VMSystem.arraycopy(cArray, n, this.value, 0, n2);
            this.offset = 0;
        }
        this.count = n2;
    }

    public String(int[] nArray, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n + n2;
        int n4 = 0;
        char[] cArray = new char[2 * nArray.length];
        for (int i = n; i < n3; ++i) {
            n4 += Character.toChars(nArray[i], cArray, n4);
        }
        this.count = n4;
        this.value = new char[n4];
        System.arraycopy(cArray, 0, this.value, 0, n4);
        this.offset = 0;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[this.offset + n];
    }

    public synchronized int codePointAt(int n) {
        return Character.codePointAt(this, n);
    }

    public synchronized int codePointBefore(int n) {
        return Character.codePointBefore(this, n);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        VMSystem.arraycopy(this.value, n + this.offset, cArray, n3, n2 - n);
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0 || n > n2 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        n += this.offset;
        while (--n4 >= 0) {
            byArray[n3++] = (byte)this.value[n++];
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(String.stringToCharset(string));
    }

    public byte[] getBytes(Charset charset) {
        try {
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(this.value, this.offset, this.count));
            if (byteBuffer.hasArray()) {
                return byteBuffer.array();
            }
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (CharacterCodingException characterCodingException) {
            throw (InternalError)new InternalError().initCause(characterCodingException);
        }
    }

    public byte[] getBytes() {
        try {
            return this.getBytes(System.getProperty("file.encoding"));
        }
        catch (Exception exception) {
            byte[] byArray = new byte[this.count];
            for (int i = 0; i < this.count; ++i) {
                byArray[i] = (byte)(this.value[this.offset + i] <= '\u00ff' ? this.value[this.offset + i] : 63);
            }
            return byArray;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        if (this.count != string.count) {
            return false;
        }
        if (this.value == string.value && this.offset == string.offset) {
            return true;
        }
        int n = this.count;
        int n2 = this.offset;
        int n3 = string.offset;
        while (--n >= 0) {
            if (this.value[n2++] == string.value[n3++]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            if (this.count != stringBuffer.count) {
                return false;
            }
            if (this.value == stringBuffer.value) {
                return true;
            }
            int n = this.count;
            int n2 = this.offset + this.count;
            while (--n >= 0) {
                if (this.value[--n2] == stringBuffer.value[n]) continue;
                return false;
            }
            return true;
        }
    }

    public boolean contentEquals(CharSequence charSequence) {
        if (charSequence.length() != this.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.value[this.offset + i] == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.count;
        int n2 = this.offset;
        int n3 = string.offset;
        while (--n >= 0) {
            char c;
            char c2;
            if ((c2 = this.value[n2++]) == (c = string.value[n3++]) || Character.toUpperCase(c2) == Character.toUpperCase(c) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(String string) {
        int n = Math.min(this.count, string.count);
        int n2 = this.offset;
        int n3 = string.offset;
        while (--n >= 0) {
            int n4;
            if ((n4 = this.value[n2++] - string.value[n3++]) == 0) continue;
            return n4;
        }
        return this.count - string.count;
    }

    public int compareToIgnoreCase(String string) {
        int n = Math.min(this.count, string.count);
        int n2 = this.offset;
        int n3 = string.offset;
        while (--n >= 0) {
            int n4;
            if ((n4 = Character.toLowerCase(Character.toUpperCase(this.value[n2++])) - Character.toLowerCase(Character.toUpperCase(string.value[n3++]))) == 0) continue;
            return n4;
        }
        return this.count - string.count;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        return this.regionMatches(false, n, string, n2, n3);
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (n < 0 || n2 < 0 || n + n3 > this.count || n2 + n3 > string.count) {
            return false;
        }
        n += this.offset;
        n2 += string.offset;
        while (--n3 >= 0) {
            char c;
            char c2;
            if ((c2 = this.value[n++]) == (c = string.value[n2++]) || bl && (Character.toLowerCase(c2) == Character.toLowerCase(c) || Character.toUpperCase(c2) == Character.toUpperCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        return this.regionMatches(false, n, string, 0, string.count);
    }

    public boolean startsWith(String string) {
        return this.regionMatches(false, 0, string, 0, string.count);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(false, this.count - string.count, string, 0, string.count);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int n = 0;
        int n2 = this.count + this.offset;
        for (int i = this.offset; i < n2; ++i) {
            n = n * 31 + this.value[i];
        }
        this.cachedHashCode = n;
        return this.cachedHashCode;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        if ((char)n != n) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2 + this.offset;
        while (n2 < this.count) {
            if (this.value[n3++] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        if ((char)n != n) {
            return -1;
        }
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        int n3 = n2 + this.offset;
        while (n2 >= 0) {
            if (this.value[n3--] == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.count - string.count;
        while (n <= n2) {
            if (this.regionMatches(n, string, 0, string.count)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count - string.count);
    }

    public int lastIndexOf(String string, int n) {
        for (n = Math.min(n, this.count - string.count); n >= 0; --n) {
            if (!this.regionMatches(n, string, 0, string.count)) continue;
            return n;
        }
        return -1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        int n3;
        if (n < 0 || n2 > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.value, n + this.offset, n3, (n3 = n2 - n) << 2 >= this.value.length);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String concat(String string) {
        if (string.count == 0) {
            return this;
        }
        if (this.count == 0) {
            return string;
        }
        char[] cArray = new char[this.count + string.count];
        VMSystem.arraycopy(this.value, this.offset, cArray, 0, this.count);
        VMSystem.arraycopy(string.value, string.offset, cArray, this.count, string.count);
        return new String(cArray, 0, cArray.length, true);
    }

    public String replace(char c, char c2) {
        if (c == c2) {
            return this;
        }
        int n = this.count;
        int n2 = this.offset - 1;
        while (--n >= 0 && this.value[++n2] != c) {
        }
        if (n < 0) {
            return this;
        }
        char[] cArray = this.toCharArray();
        cArray[n2 - this.offset] = c2;
        while (--n >= 0) {
            if (this.value[++n2] != c) continue;
            cArray[n2 - this.offset] = c2;
        }
        return new String(cArray, 0, this.count, true);
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String[] split(String string, int n) {
        return Pattern.compile(string).split(this, n);
    }

    public String[] split(String string) {
        return Pattern.compile(string).split(this, 0);
    }

    private String toLowerCaseTurkish() {
        char c;
        int n = this.count;
        int n2 = this.offset - 1;
        while (--n >= 0 && (c = this.value[++n2]) != 'I' && c == Character.toLowerCase(c)) {
        }
        if (n < 0) {
            return this;
        }
        char[] cArray = new char[this.count];
        VMSystem.arraycopy(this.value, this.offset, cArray, 0, n2 - this.offset);
        do {
            char c2;
            cArray[n2 - this.offset] = (c2 = this.value[n2]) != 'I' ? Character.toLowerCase(c2) : (char)305;
            ++n2;
        } while (--n >= 0);
        return new String(cArray, 0, this.count, true);
    }

    public String toLowerCase(Locale locale) {
        char c;
        if ("tr" == locale.getLanguage()) {
            return this.toLowerCaseTurkish();
        }
        int n = this.count;
        int n2 = this.offset - 1;
        while (--n >= 0 && (c = this.value[++n2]) == Character.toLowerCase(c)) {
        }
        if (n < 0) {
            return this;
        }
        char[] cArray = new char[this.count];
        VMSystem.arraycopy(this.value, this.offset, cArray, 0, n2 - this.offset);
        do {
            char c2 = this.value[n2];
            cArray[n2 - this.offset] = Character.toLowerCase(c2);
            ++n2;
        } while (--n >= 0);
        return new String(cArray, 0, this.count, true);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    private String toUpperCaseTurkish() {
        int n = 0;
        boolean bl = true;
        int n2 = this.count;
        int n3 = n2 + this.offset;
        while (--n2 >= 0) {
            char c = this.value[--n3];
            bl = bl && (n += String.upperCaseExpansion(c)) == 0 && c != 'i' && c == Character.toUpperCase(c);
        }
        if (bl) {
            return this;
        }
        n2 = this.count;
        if (n == 0) {
            char[] cArray = new char[this.count];
            VMSystem.arraycopy(this.value, this.offset, cArray, 0, this.count - (n3 - this.offset));
            while (--n2 >= 0) {
                char c = this.value[n3];
                cArray[n3 - this.offset] = c != 'i' ? Character.toUpperCase(c) : (char)304;
                ++n3;
            }
            return new String(cArray, 0, this.count, true);
        }
        char[] cArray = new char[this.count + n];
        int n4 = 0;
        while (--n2 >= 0) {
            char c;
            if ((c = this.value[n3++]) == 'i') {
                cArray[n4++] = 304;
                continue;
            }
            n = String.upperCaseExpansion(c);
            if (n > 0) {
                int n5 = String.upperCaseIndex(c);
                while (n-- >= 0) {
                    cArray[n4++] = upperExpand[n5++];
                }
                continue;
            }
            cArray[n4++] = Character.toUpperCase(c);
        }
        return new String(cArray, 0, cArray.length, true);
    }

    public String toUpperCase(Locale locale) {
        if ("tr" == locale.getLanguage()) {
            return this.toUpperCaseTurkish();
        }
        int n = 0;
        boolean bl = true;
        int n2 = this.count;
        int n3 = n2 + this.offset;
        while (--n2 >= 0) {
            char c = this.value[--n3];
            bl = bl && (n += String.upperCaseExpansion(c)) == 0 && c == Character.toUpperCase(c);
        }
        if (bl) {
            return this;
        }
        n2 = this.count;
        if (n == 0) {
            char[] cArray = new char[this.count];
            VMSystem.arraycopy(this.value, this.offset, cArray, 0, this.count - (n3 - this.offset));
            while (--n2 >= 0) {
                char c = this.value[n3];
                cArray[n3 - this.offset] = Character.toUpperCase(c);
                ++n3;
            }
            return new String(cArray, 0, this.count, true);
        }
        char[] cArray = new char[this.count + n];
        int n4 = 0;
        while (--n2 >= 0) {
            char c;
            if ((n = String.upperCaseExpansion(c = this.value[n3++])) > 0) {
                int n5 = String.upperCaseIndex(c);
                while (n-- >= 0) {
                    cArray[n4++] = upperExpand[n5++];
                }
                continue;
            }
            cArray[n4++] = Character.toUpperCase(c);
        }
        return new String(cArray, 0, cArray.length, true);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n = this.count + this.offset;
        if (this.count == 0 || this.value[this.offset] > ' ' && this.value[n - 1] > ' ') {
            return this;
        }
        int n2 = this.offset;
        do {
            if (n2 != n) continue;
            return "";
        } while (this.value[n2++] <= ' ');
        int n3 = n;
        while (this.value[--n3] <= ' ') {
        }
        return this.substring(n2 - this.offset - 1, n3 - this.offset + 1);
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        VMSystem.arraycopy(this.value, this.offset, cArray, 0, this.count);
        return cArray;
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return String.valueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2, false);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2, false);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        return new String(new char[]{c}, 0, 1, true);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        Formatter formatter = new Formatter(locale);
        return formatter.format(string, objectArray).toString();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format(Locale.getDefault(), string, objectArray);
    }

    public String intern() {
        return VMString.intern(this);
    }

    public synchronized int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        n += this.offset;
        n2 += this.offset;
        int n3 = 0;
        while (n < n2) {
            char c = this.value[n];
            if (c >= '\ud800' && c <= '\udbff' && n != n2 && n != n3 && this.value[n + 1] >= '\udc00' && this.value[n + 1] <= '\udfff') {
                ++n;
            }
            ++n;
            ++n3;
        }
        return n3;
    }

    private static int upperCaseExpansion(char c) {
        return Character.direction[0][Character.readCodePoint(c) >> 7] & 3;
    }

    private static int upperCaseIndex(char c) {
        int n = 0;
        int n2 = upperSpecial.length - 2;
        int n3 = n + n2 >> 2 << 1;
        char c2 = upperSpecial[n3];
        while (c != c2) {
            if (c < c2) {
                n2 = n3 - 2;
            } else {
                n = n3 + 2;
            }
            n3 = n + n2 >> 2 << 1;
            c2 = upperSpecial[n3];
        }
        return upperSpecial[n3 + 1];
    }

    static char[] zeroBasedStringValue(String string) {
        char[] cArray;
        if (string.offset == 0 && string.count == string.value.length) {
            cArray = string.value;
        } else {
            int n = string.count;
            cArray = new char[n];
            VMSystem.arraycopy(string.value, string.offset, cArray, 0, n);
        }
        return cArray;
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(charSequence.toString()) != -1;
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        int n = charSequence.length();
        int n2 = charSequence2.length();
        int n3 = this.indexOf(string);
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this);
        while (n3 != -1) {
            cPStringBuilder.replace(n3, n3 + n, string2);
            n3 = cPStringBuilder.indexOf(string, n3 + n2);
        }
        return cPStringBuilder.toString();
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this.value, this.offset, this.count, this.offset + n, n2);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

