/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Runtime {
    private final String[] libpath;
    private Thread exitSequence;
    private Set shutdownHooks;
    private static final Runtime current = new Runtime();

    private Runtime() {
        String string;
        if (current != null) {
            throw new InternalError("Attempt to recreate Runtime");
        }
        String string2 = SystemProperties.getProperty("gnu.classpath.boot.library.path", "");
        String string3 = SystemProperties.getProperty("java.library.path", ".");
        String string4 = SystemProperties.getProperty("path.separator", ":");
        String string5 = SystemProperties.getProperty("file.separator", "/");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string4);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, string4);
        this.libpath = new String[stringTokenizer.countTokens() + stringTokenizer2.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!string.endsWith(string5)) {
                string = string + string5;
            }
            this.libpath[n] = string;
            ++n;
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string = stringTokenizer2.nextToken();
            if (!string.endsWith(string5)) {
                string = string + string5;
            }
            this.libpath[n] = string;
            ++n;
        }
    }

    public static Runtime getRuntime() {
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        if (this.runShutdownHooks()) {
            this.halt(n);
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.shutdownHooks != null) {
                this.shutdownHooks.remove(Thread.currentThread());
                this.exitSequence.interrupt();
                n = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (n != 0) {
                this.halt(n);
            }
            while (true) {
                try {
                    while (true) {
                        this.exitSequence.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean runShutdownHooks() {
        var1_1 = false;
        var2_2 = this.libpath;
        // MONITORENTER : this.libpath
        if (this.exitSequence == null) {
            var1_1 = true;
            this.exitSequence = Thread.currentThread();
            if (this.shutdownHooks != null) {
                var3_3 = this.shutdownHooks.iterator();
                while (var3_3.hasNext()) {
                    try {
                        ((Thread)var3_3.next()).start();
                    }
                    catch (IllegalThreadStateException var4_5) {
                        var3_3.remove();
                    }
                }
            }
        }
        // MONITOREXIT : var2_2
        if (var1_1 == false) return var1_1;
        if (this.shutdownHooks == null) ** GOTO lbl32
        block15: while (true) {
            block23: {
                var3_3 = this.libpath;
                // MONITORENTER : this.libpath
                var2_2 = new Thread[this.shutdownHooks.size()];
                this.shutdownHooks.toArray(var2_2);
                // MONITOREXIT : var3_3
                if (var2_2.length == 0) {
                    var2_2 = this.libpath;
                    // MONITORENTER : this.libpath
                    this.shutdownHooks = null;
                    // MONITOREXIT : var2_2
                }
                break block23;
lbl32:
                // 2 sources

                VMRuntime.runFinalizationForExit();
                return var1_1;
            }
            var3_4 = 0;
            while (true) {
                if (var3_4 >= var2_2.length) continue block15;
                try {
                    var4_6 = this.libpath;
                    // MONITORENTER : this.libpath
                    if (!this.shutdownHooks.contains(var2_2[var3_4])) {
                        // MONITOREXIT : var4_6
                    } else {
                        // MONITOREXIT : var4_6
                        var2_2[var3_4].join();
                        var4_6 = this.libpath;
                        // MONITORENTER : this.libpath
                        this.shutdownHooks.remove(var2_2[var3_4]);
                        // MONITOREXIT : var4_6
                    }
                }
                catch (InterruptedException var4_7) {
                    // empty catch block
                }
                ++var3_4;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Thread thread) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        if (thread.isAlive() || thread.getThreadGroup() == null) {
            throw new IllegalArgumentException("The hook thread " + thread + " must not have been already run or started");
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException("The Virtual Machine is exiting. It is not possible anymore to add any hooks");
            }
            if (this.shutdownHooks == null) {
                VMRuntime.enableShutdownHooks();
                this.shutdownHooks = new HashSet();
            }
            if (!this.shutdownHooks.add(thread)) {
                throw new IllegalArgumentException(thread.toString() + " had already been inserted");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeShutdownHook(Thread thread) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException();
            }
            if (this.shutdownHooks != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.shutdownHooks.remove(thread);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public void halt(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        VMRuntime.exit(n);
    }

    public static void runFinalizersOnExit(boolean bl) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(0);
        }
        VMRuntime.runFinalizersOnExit(bl);
    }

    public Process exec(String string) throws IOException {
        return this.exec(string, null, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringTokenizer.nextToken();
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExec(stringArray[0]);
        }
        return VMRuntime.exec(stringArray, stringArray2, file);
    }

    public int availableProcessors() {
        return VMRuntime.availableProcessors();
    }

    public long freeMemory() {
        return VMRuntime.freeMemory();
    }

    public long totalMemory() {
        return VMRuntime.totalMemory();
    }

    public long maxMemory() {
        return VMRuntime.maxMemory();
    }

    public void gc() {
        VMRuntime.gc();
    }

    public void runFinalization() {
        VMRuntime.runFinalization();
    }

    public void traceInstructions(boolean bl) {
        VMRuntime.traceInstructions(bl);
    }

    public void traceMethodCalls(boolean bl) {
        VMRuntime.traceMethodCalls(bl);
    }

    public void load(String string) {
        this.load(string, VMStackWalker.getCallingClassLoader());
    }

    void load(String string, ClassLoader classLoader) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (Runtime.loadLib(string, classLoader) == 0) {
            throw new UnsatisfiedLinkError("Could not load library " + string);
        }
    }

    private static int loadLib(String string, ClassLoader classLoader) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return VMRuntime.nativeLoad(string, classLoader);
    }

    public void loadLibrary(String string) {
        this.loadLibrary(string, VMStackWalker.getCallingClassLoader());
    }

    void loadLibrary(String string, ClassLoader classLoader) {
        String string2;
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            if (Runtime.loadLib(string2, classLoader) != 0) {
                return;
            }
        } else {
            string2 = VMRuntime.mapLibraryName(string);
            for (int i = 0; i < this.libpath.length; ++i) {
                if (Runtime.loadLib(this.libpath[i] + string2, classLoader) == 0) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("Native library `" + string + "' not found (as file `" + string2 + "') in gnu.classpath.boot.library.path and java.library.path");
    }

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }
}

