/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.VMStackWalker;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements AnnotatedElement {
    private final String name;
    private final String implTitle;
    private final String implVendor;
    private final String implVersion;
    private final String specTitle;
    private final String specVendor;
    private final String specVersion;
    private final URL sealed;
    private ClassLoader loader;

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        this(string, string2, string3, string4, string5, string6, string7, uRL, null);
    }

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL, ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("null Package name");
        }
        this.name = string;
        this.implTitle = string5;
        this.implVendor = string6;
        this.implVersion = string7;
        this.specTitle = string2;
        this.specVendor = string3;
        this.specVersion = string4;
        this.sealed = uRL;
        this.loader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealed != null;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealed);
    }

    public boolean isCompatibleWith(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.specVersion, ".");
        try {
            while (stringTokenizer.hasMoreElements()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n2 < n) {
                    return false;
                }
                if (n2 <= n) continue;
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return true;
    }

    public static Package getPackage(String string) {
        ClassLoader classLoader = VMStackWalker.getCallingClassLoader();
        return classLoader != null ? classLoader.getPackage(string) : VMClassLoader.getPackage(string);
    }

    public static Package[] getPackages() {
        ClassLoader classLoader = VMStackWalker.getCallingClassLoader();
        return classLoader != null ? classLoader.getPackages() : VMClassLoader.getPackages();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name + (this.specTitle == null ? "" : ", " + this.specTitle) + (this.specVersion == null ? "" : ", version " + this.specVersion);
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Annotation[] annotationArray;
        Annotation annotation = null;
        for (Annotation annotation2 : annotationArray = this.getAnnotations()) {
            if (annotation2.annotationType() != clazz) continue;
            annotation = annotation2;
        }
        return (A)annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        try {
            Class<?> clazz = Class.forName(this.name + ".package-info", false, this.loader);
            return clazz.getDeclaredAnnotations();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Annotation[0];
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation((Class)clazz) != null;
    }
}

