/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    private static Random rand;
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    private Math() {
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return -(-f - f2);
        }
        return f < f2 ? f : f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return -(-d - d2);
        }
        return d < d2 ? d : d2;
    }

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return f - -f2;
        }
        return f > f2 ? f : f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0) {
            return d - -d2;
        }
        return d > d2 ? d : d2;
    }

    public static double sin(double d) {
        return VMMath.sin(d);
    }

    public static double cos(double d) {
        return VMMath.cos(d);
    }

    public static double tan(double d) {
        return VMMath.tan(d);
    }

    public static double asin(double d) {
        return VMMath.asin(d);
    }

    public static double acos(double d) {
        return VMMath.acos(d);
    }

    public static double atan(double d) {
        return VMMath.atan(d);
    }

    public static double atan2(double d, double d2) {
        return VMMath.atan2(d, d2);
    }

    public static double exp(double d) {
        return VMMath.exp(d);
    }

    public static double log(double d) {
        return VMMath.log(d);
    }

    public static double sqrt(double d) {
        return VMMath.sqrt(d);
    }

    public static double pow(double d, double d2) {
        return VMMath.pow(d, d2);
    }

    public static double IEEEremainder(double d, double d2) {
        return VMMath.IEEEremainder(d, d2);
    }

    public static double ceil(double d) {
        return VMMath.ceil(d);
    }

    public static double floor(double d) {
        return VMMath.floor(d);
    }

    public static double rint(double d) {
        return VMMath.rint(d);
    }

    public static int round(float f) {
        if (f != f) {
            return 0;
        }
        return (int)Math.floor(f + 0.5f);
    }

    public static long round(double d) {
        if (d != d) {
            return 0L;
        }
        return (long)Math.floor(d + 0.5);
    }

    public static synchronized double random() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static double toRadians(double d) {
        return d * Math.PI / 180.0;
    }

    public static double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double cbrt(double d) {
        return VMMath.cbrt(d);
    }

    public static double cosh(double d) {
        return VMMath.cosh(d);
    }

    public static double expm1(double d) {
        return VMMath.expm1(d);
    }

    public static double hypot(double d, double d2) {
        return VMMath.hypot(d, d2);
    }

    public static double log10(double d) {
        return VMMath.log10(d);
    }

    public static double log1p(double d) {
        return VMMath.log1p(d);
    }

    public static double signum(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return d;
    }

    public static float signum(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        if (f > 0.0f) {
            return 1.0f;
        }
        if (f < 0.0f) {
            return -1.0f;
        }
        return f;
    }

    public static double sinh(double d) {
        return VMMath.sinh(d);
    }

    public static double tanh(double d) {
        return VMMath.tanh(d);
    }

    public static double ulp(double d) {
        long l;
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return Double.MIN_VALUE;
        }
        long l2 = Double.doubleToLongBits(d);
        long l3 = l2 & 0xFFFFFFFFFFFFFL;
        long l4 = l2 >>> 52 & 0x7FFL;
        if (l4 == 0L) {
            long l5 = l4 << 52 | 1L;
            return Double.longBitsToDouble(l5);
        }
        long l6 = l4 - 52L;
        if (l6 > 0L) {
            l = 0L;
        } else {
            l = 1L << (int)(-(l6 - 1L));
            l6 = 0L;
        }
        return Double.longBitsToDouble(l6 << 52 | l);
    }

    public static float ulp(float f) {
        int n;
        if (Float.isNaN(f)) {
            return f;
        }
        if (Float.isInfinite(f)) {
            return Float.POSITIVE_INFINITY;
        }
        if ((double)f == 0.0) {
            return Float.MIN_VALUE;
        }
        int n2 = Float.floatToIntBits(f);
        int n3 = n2 & 0x7FFFFF;
        int n4 = n2 >>> 23 & 0xFF;
        if (n4 == 0) {
            int n5 = n4 << 23 | 1;
            return Float.intBitsToFloat(n5);
        }
        int n6 = n4 - 23;
        if (n6 > 0) {
            n = 0;
        } else {
            n = 1 << -(n6 - 1);
            n6 = 0;
        }
        return Float.intBitsToFloat(n6 << 23 | n);
    }

    static {
        System.loadLibrary("javalang");
    }
}

