/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Long
extends Number
implements Comparable<Long> {
    private static final long serialVersionUID = 4290774380558885855L;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = VMClassLoader.getPrimitiveClass('J');
    public static final int SIZE = 64;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static final Long[] longCache = new Long[256];
    private final long value;

    public Long(long l) {
        this.value = l;
    }

    public Long(String string) {
        this.value = Long.parseLong(string, 10, false);
    }

    private static int stringSize(long l, int n) {
        int n2 = n < 4 ? 1 : (n < 8 ? 2 : (n < 16 ? 3 : (n < 32 ? 4 : 5)));
        int n3 = 0;
        do {
            ++n3;
        } while ((l >>>= n2) != 0L);
        return n3;
    }

    public static String toString(long l, int n) {
        char[] cArray;
        int n2;
        int n3;
        boolean bl;
        if (n < 2 || n > 36) {
            n = 10;
        }
        boolean bl2 = bl = l < 0L;
        if (!bl && l < (long)n) {
            return new String(digits, (int)l, 1, true);
        }
        if (bl) {
            if ((l = -l) < 0L) {
                n2 = n3 = Long.stringSize(Long.MAX_VALUE, n) + 2;
                cArray = new char[n3];
                cArray[--n2] = digits[(int)(-(l + (long)n) % (long)n)];
                l = -(l / (long)n);
            } else {
                n2 = n3 = Long.stringSize(l, n) + 1;
                cArray = new char[n3];
            }
        } else {
            n2 = n3 = Long.stringSize(l, n);
            cArray = new char[n3];
        }
        do {
            cArray[--n2] = digits[(int)(l % (long)n)];
        } while ((l /= (long)n) > 0L);
        if (bl) {
            cArray[--n2] = 45;
        }
        return new String(cArray, n2, n3 - n2, true);
    }

    public static String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static String toString(long l) {
        return Long.toString(l, 10);
    }

    public static long parseLong(String string, int n) {
        return Long.parseLong(string, n, false);
    }

    public static long parseLong(String string) {
        return Long.parseLong(string, 10, false);
    }

    public static Long valueOf(String string, int n) {
        return Long.parseLong(string, n, false);
    }

    public static Long valueOf(String string) {
        return Long.parseLong(string, 10, false);
    }

    public static Long valueOf(long l) {
        if (l < -128L || l > 127L) {
            return new Long(l);
        }
        return longCache[(int)l - -128];
    }

    public static Long decode(String string) {
        return Long.parseLong(string, 10, true);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value, 10);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Long && this.value == ((Long)object).value;
    }

    public static Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static Long getLong(String string, long l) {
        Long l2 = Long.getLong(string, null);
        return l2 == null ? Long.valueOf(l) : l2;
    }

    public static Long getLong(String string, Long l) {
        if (string == null || "".equals(string)) {
            return l;
        }
        if ((string = System.getProperty(string)) == null) {
            return l;
        }
        try {
            return Long.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    @Override
    public int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        return this.value > l.value ? 1 : -1;
    }

    public static int bitCount(long l) {
        l = (l >> 1 & 0x5555555555555555L) + (l & 0x5555555555555555L);
        l = (l >> 2 & 0x3333333333333333L) + (l & 0x3333333333333333L);
        int n = (int)((l >>> 32) + l);
        n = (n >> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
        n = (n >> 8 & 0xFF00FF) + (n & 0xFF00FF);
        return (n >> 16 & 0xFFFF) + (n & 0xFFFF);
    }

    public static long rotateLeft(long l, int n) {
        return l << n | l >>> -n;
    }

    public static long rotateRight(long l, int n) {
        return l << -n | l >>> n;
    }

    public static long highestOneBit(long l) {
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return l ^ l >>> 1;
    }

    public static int numberOfLeadingZeros(long l) {
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return Long.bitCount(l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long lowestOneBit(long l) {
        return l & -l;
    }

    public static int numberOfTrailingZeros(long l) {
        return Long.bitCount((l & -l) - 1L);
    }

    public static int signum(long l) {
        return (int)(l >> 63 | -l >>> 63);
    }

    public static long reverseBytes(long l) {
        int n = Integer.reverseBytes((int)l);
        int n2 = Integer.reverseBytes((int)(l >>> 32));
        return (long)n << 32 | (long)n2;
    }

    public static long reverse(long l) {
        long l2 = (long)Integer.reverse((int)l) & 0xFFFFFFFFL;
        long l3 = (long)Integer.reverse((int)(l >>> 32)) & 0xFFFFFFFFL;
        return l2 << 32 | l3;
    }

    private static String toUnsignedString(long l, int n) {
        int n2 = 1;
        for (long i = l >>> n; i != 0L; i >>>= n) {
            ++n2;
        }
        if (n2 == 1) {
            return new String(digits, (int)l, 1, true);
        }
        int n3 = (1 << n) - 1;
        char[] cArray = new char[n2];
        int n4 = n2;
        do {
            cArray[--n4] = digits[(int)l & n3];
        } while ((l >>>= n) != 0L);
        return new String(cArray, n4, n2 - n4, true);
    }

    private static long parseLong(String string, int n, boolean bl) {
        if (!bl && string == null) {
            throw new NumberFormatException();
        }
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = false;
        if (n3 == 0) {
            throw new NumberFormatException();
        }
        int n4 = string.charAt(n2);
        if (n4 == 45) {
            if (n3 == 1) {
                throw new NumberFormatException();
            }
            bl2 = true;
            n4 = string.charAt(++n2);
        }
        if (bl) {
            if (n4 == 48) {
                if (++n2 == n3) {
                    return 0L;
                }
                if ((string.charAt(n2) & 0xFFFFFFDF) == 88) {
                    n = 16;
                    ++n2;
                } else {
                    n = 8;
                }
            } else if (n4 == 35) {
                n = 16;
                ++n2;
            }
        }
        if (n2 == n3) {
            throw new NumberFormatException();
        }
        long l = Long.MAX_VALUE / (long)n;
        if (bl2 && Long.MAX_VALUE % (long)n == (long)(n - 1)) {
            ++l;
        }
        long l2 = 0L;
        while (n2 < n3) {
            if (l2 < 0L || l2 > l) {
                throw new NumberFormatException();
            }
            n4 = Character.digit(string.charAt(n2++), n);
            l2 = l2 * (long)n + (long)n4;
            if (n4 >= 0 && (l2 >= 0L || bl2 && l2 == Long.MIN_VALUE)) continue;
            throw new NumberFormatException();
        }
        return bl2 ? -l2 : l2;
    }

    static {
        for (int i = -128; i <= 127; ++i) {
            Long.longCache[i - -128] = new Long(i);
        }
    }
}

