/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Integer
extends Number
implements Comparable<Integer> {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = VMClassLoader.getPrimitiveClass('I');
    public static final int SIZE = 32;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static final Integer[] intCache = new Integer[256];
    private final int value;

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) {
        this.value = Integer.parseInt(string, 10, false);
    }

    private static int stringSize(int n, int n2) {
        int n3 = n2 < 4 ? 1 : (n2 < 8 ? 2 : (n2 < 16 ? 3 : (n2 < 32 ? 4 : 5)));
        int n4 = 0;
        do {
            ++n4;
        } while ((n >>>= n3) != 0);
        return n4;
    }

    public static String toString(int n, int n2) {
        char[] cArray;
        int n3;
        int n4;
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        boolean bl2 = bl = n < 0;
        if (!bl && n < n2) {
            return new String(digits, n, 1, true);
        }
        if (bl) {
            if ((n = -n) < 0) {
                n3 = n4 = Integer.stringSize(Integer.MAX_VALUE, n2) + 2;
                cArray = new char[n4];
                cArray[--n3] = digits[-(n + n2) % n2];
                n = -(n / n2);
            } else {
                n3 = n4 = Integer.stringSize(n, n2) + 1;
                cArray = new char[n4];
            }
        } else {
            n3 = n4 = Integer.stringSize(n, n2);
            cArray = new char[n4];
        }
        do {
            cArray[--n3] = digits[n % n2];
        } while ((n /= n2) > 0);
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, n4 - n3, true);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    public static String toString(int n) {
        return String.valueOf(n);
    }

    public static int parseInt(String string, int n) {
        return Integer.parseInt(string, n, false);
    }

    public static int parseInt(String string) {
        return Integer.parseInt(string, 10, false);
    }

    public static Integer valueOf(String string, int n) {
        return Integer.parseInt(string, n, false);
    }

    public static Integer valueOf(String string) {
        return Integer.parseInt(string, 10, false);
    }

    public static Integer valueOf(int n) {
        if (n < -128 || n > 127) {
            return new Integer(n);
        }
        return intCache[n - -128];
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Integer && this.value == ((Integer)object).value;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        return n2 == null ? Integer.valueOf(n) : n2;
    }

    public static Integer getInteger(String string, Integer n) {
        if (string == null || "".equals(string)) {
            return n;
        }
        if ((string = System.getProperty(string)) == null) {
            return n;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static Integer decode(String string) {
        return Integer.parseInt(string, 10, true);
    }

    @Override
    public int compareTo(Integer n) {
        if (this.value == n.value) {
            return 0;
        }
        return this.value > n.value ? 1 : -1;
    }

    public static int bitCount(int n) {
        n = (n >> 1 & 0x55555555) + (n & 0x55555555);
        n = (n >> 2 & 0x33333333) + (n & 0x33333333);
        n = (n >> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
        n = (n >> 8 & 0xFF00FF) + (n & 0xFF00FF);
        return (n >> 16 & 0xFFFF) + (n & 0xFFFF);
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n << -n2 | n >>> n2;
    }

    public static int highestOneBit(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n ^ n >>> 1;
    }

    public static int numberOfLeadingZeros(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return Integer.bitCount(~n);
    }

    public static int lowestOneBit(int n) {
        return n & -n;
    }

    public static int numberOfTrailingZeros(int n) {
        return Integer.bitCount((n & -n) - 1);
    }

    public static int signum(int n) {
        return n >> 31 | -n >>> 31;
    }

    public static int reverseBytes(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    public static int reverse(int n) {
        n = (n >> 1 & 0x55555555) + (n << 1 & 0xAAAAAAAA);
        n = (n >> 2 & 0x33333333) + (n << 2 & 0xCCCCCCCC);
        n = (n >> 4 & 0xF0F0F0F) + (n << 4 & 0xF0F0F0F0);
        n = (n >> 8 & 0xFF00FF) + (n << 8 & 0xFF00FF00);
        return (n >> 16 & 0xFFFF) + (n << 16 & 0xFFFF0000);
    }

    static String toUnsignedString(int n, int n2) {
        int n3 = 1;
        for (int i = n >>> n2; i != 0; i >>>= n2) {
            ++n3;
        }
        if (n3 == 1) {
            return new String(digits, n, 1, true);
        }
        int n4 = (1 << n2) - 1;
        char[] cArray = new char[n3];
        int n5 = n3;
        do {
            cArray[--n5] = digits[n & n4];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n5, n3 - n5, true);
    }

    static int parseInt(String string, int n, boolean bl) {
        if (!bl && string == null) {
            throw new NumberFormatException();
        }
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = false;
        if (n3 == 0) {
            throw new NumberFormatException("string length is null");
        }
        int n4 = string.charAt(n2);
        if (n4 == 45) {
            if (n3 == 1) {
                throw new NumberFormatException("pure '-'");
            }
            bl2 = true;
            n4 = string.charAt(++n2);
        } else if (n4 == 43) {
            if (n3 == 1) {
                throw new NumberFormatException("pure '+'");
            }
            n4 = string.charAt(++n2);
        }
        if (bl) {
            if (n4 == 48) {
                if (++n2 == n3) {
                    return 0;
                }
                if ((string.charAt(n2) & 0xFFFFFFDF) == 88) {
                    n = 16;
                    ++n2;
                } else {
                    n = 8;
                }
            } else if (n4 == 35) {
                n = 16;
                ++n2;
            }
        }
        if (n2 == n3) {
            throw new NumberFormatException("non terminated number: " + string);
        }
        int n5 = Integer.MAX_VALUE / n;
        if (bl2 && Integer.MAX_VALUE % n == n - 1) {
            ++n5;
        }
        int n6 = 0;
        while (n2 < n3) {
            if (n6 < 0 || n6 > n5) {
                throw new NumberFormatException("number overflow (pos=" + n2 + ") : " + string);
            }
            n4 = Character.digit(string.charAt(n2++), n);
            n6 = n6 * n + n4;
            if (n4 >= 0 && (n6 >= 0 || bl2 && n6 == Integer.MIN_VALUE)) continue;
            throw new NumberFormatException("invalid character at position " + n2 + " in " + string);
        }
        return bl2 ? -n6 : n6;
    }

    static {
        for (int i = -128; i <= 127; ++i) {
            Integer.intCache[i - -128] = new Integer(i);
        }
    }
}

