/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.lang.CPStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Float
extends Number
implements Comparable<Float> {
    private static final long serialVersionUID = -2671257302660747028L;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class<Float> TYPE = VMClassLoader.getPrimitiveClass('F');
    public static final int SIZE = 32;
    private static final Float ZERO = new Float(0.0f);
    private static final Float ONE = new Float(1.0f);
    private final float value;

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) {
        this.value = Float.parseFloat(string);
    }

    public static String toString(float f) {
        return VMFloat.toString(f);
    }

    public static String toHexString(float f) {
        int n;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-Infinity" : "Infinity";
        }
        int n2 = Float.floatToIntBits(f);
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        if (n2 < 0) {
            cPStringBuilder.append('-');
        }
        cPStringBuilder.append("0x");
        int n3 = 0x7FFFFF;
        int n4 = n2 & n3;
        int n5 = 255;
        int n6 = n2 >>> 23 & n5;
        cPStringBuilder.append(n6 == 0 ? (char)'0' : '1');
        cPStringBuilder.append('.');
        cPStringBuilder.append(Integer.toHexString(n4 <<= 1));
        if (n6 == 0 && n4 != 0) {
            n = 4 + (n2 < 0 ? 1 : 0);
            int n7 = n + 6;
            while (cPStringBuilder.length() < n7) {
                cPStringBuilder.insert(n, '0');
            }
        }
        cPStringBuilder.append('p');
        if (n6 != 0 || n4 != 0) {
            n = n6 == 0 ? 1 : 0;
            n6 -= 127;
            if (n != 0) {
                ++n6;
            }
        }
        cPStringBuilder.append(Integer.toString(n6));
        return cPStringBuilder.toString();
    }

    public static Float valueOf(String string) {
        return Float.valueOf(Float.parseFloat(string));
    }

    public static Float valueOf(float f) {
        if ((double)f == 0.0 && Float.floatToRawIntBits(f) == 0) {
            return ZERO;
        }
        if ((double)f == 1.0) {
            return ONE;
        }
        return new Float(f);
    }

    public static float parseFloat(String string) {
        return VMFloat.parseFloat(string);
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        if (object instanceof Float) {
            float f = ((Float)object).value;
            return Float.floatToRawIntBits(this.value) == Float.floatToRawIntBits(f) || Float.isNaN(this.value) && Float.isNaN(f);
        }
        return false;
    }

    public static int floatToIntBits(float f) {
        if (Float.isNaN(f)) {
            return 2143289344;
        }
        return VMFloat.floatToRawIntBits(f);
    }

    public static int floatToRawIntBits(float f) {
        return VMFloat.floatToRawIntBits(f);
    }

    public static float intBitsToFloat(int n) {
        return VMFloat.intBitsToFloat(n);
    }

    @Override
    public int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public static int compare(float f, float f2) {
        int n;
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        int n2 = Float.floatToRawIntBits(f);
        if (n2 == (n = Float.floatToRawIntBits(f2))) {
            return 0;
        }
        if (f != f) {
            return f2 != f2 ? 0 : 1;
        }
        if (f2 != f2) {
            return -1;
        }
        return n2 < n ? -1 : 1;
    }
}

