/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Enum<T extends Enum<T>>
implements Comparable<T>,
Serializable {
    private static final long serialVersionUID = -4300926546619394005L;
    final String name;
    final int ordinal;

    protected Enum(String string, int n) {
        this.name = string;
        this.ordinal = n;
    }

    public static <S extends Enum<S>> S valueOf(Class<S> clazz, String string) {
        if (clazz == null || string == null) {
            throw new NullPointerException();
        }
        try {
            Field field = clazz.getDeclaredField(string);
            if (!field.isEnumConstant()) {
                throw new IllegalArgumentException(string);
            }
            Class.setAccessible(field);
            Enum enum_ = (Enum)field.get(null);
            return (S)enum_;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unable to access Enum class");
        }
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public final int compareTo(T t) {
        if (this.getDeclaringClass() != ((Enum)t).getDeclaringClass()) {
            throw new ClassCastException();
        }
        return this.ordinal - ((Enum)t).ordinal;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("can't clone an enum constant");
    }

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    public final Class<T> getDeclaringClass() {
        Class<? extends Object> clazz = this.getClass();
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    protected final void finalize() {
    }
}

