/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.lang.CPStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Double
extends Number
implements Comparable<Double> {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = VMClassLoader.getPrimitiveClass('D');
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private final double value;

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) {
        this.value = Double.parseDouble(string);
    }

    public static String toString(double d) {
        return VMDouble.toString(d, false);
    }

    public static String toHexString(double d) {
        int n;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-Infinity" : "Infinity";
        }
        long l = Double.doubleToLongBits(d);
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        if (l < 0L) {
            cPStringBuilder.append('-');
        }
        cPStringBuilder.append("0x");
        long l2 = 0xFFFFFFFFFFFFFL;
        long l3 = l & l2;
        long l4 = 2047L;
        long l5 = l >>> 52 & l4;
        cPStringBuilder.append(l5 == 0L ? (char)'0' : '1');
        cPStringBuilder.append('.');
        cPStringBuilder.append(Long.toHexString(l3));
        if (l5 == 0L && l3 != 0L) {
            n = 4 + (l < 0L ? 1 : 0);
            int n2 = n + 13;
            while (cPStringBuilder.length() < n2) {
                cPStringBuilder.insert(n, '0');
            }
        }
        cPStringBuilder.append('p');
        if (l5 != 0L || l3 != 0L) {
            n = l5 == 0L ? 1 : 0;
            l5 -= 1023L;
            if (n != 0) {
                ++l5;
            }
        }
        cPStringBuilder.append(Long.toString(l5));
        return cPStringBuilder.toString();
    }

    public static Double valueOf(double d) {
        if (d == 0.0 && Double.doubleToRawLongBits(d) == 0L) {
            return ZERO;
        }
        if (d == 1.0) {
            return ONE;
        }
        return new Double(d);
    }

    public static Double valueOf(String string) {
        return Double.parseDouble(string);
    }

    public static double parseDouble(String string) {
        return VMDouble.parseDouble(string);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Double) {
            double d = ((Double)object).value;
            return Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(d) || Double.isNaN(this.value) && Double.isNaN(d);
        }
        return false;
    }

    public static long doubleToLongBits(double d) {
        if (Double.isNaN(d)) {
            return 9221120237041090560L;
        }
        return VMDouble.doubleToRawLongBits(d);
    }

    public static long doubleToRawLongBits(double d) {
        return VMDouble.doubleToRawLongBits(d);
    }

    public static double longBitsToDouble(long l) {
        return VMDouble.longBitsToDouble(l);
    }

    @Override
    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToRawLongBits(d);
        if (l2 == (l = Double.doubleToRawLongBits(d2))) {
            return 0;
        }
        if (d != d) {
            return d2 != d2 ? 0 : 1;
        }
        if (d2 != d2) {
            return -1;
        }
        return l2 < l ? -1 : 1;
    }
}

