/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import gnu.java.util.DoubleEnumeration;
import gnu.java.util.EmptyEnumeration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    final HashMap<String, Package> definedPackages = new HashMap();
    private final ClassLoader parent;
    private final boolean initialized;
    boolean defaultAssertionStatus = VMClassLoader.defaultAssertionStatus();
    Map<String, Boolean> packageAssertionStatus;
    Map<String, Boolean> classAssertionStatus;
    transient Object vmdata;

    protected ClassLoader() throws SecurityException {
        this(StaticData.systemClassLoader);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            block6: {
                try {
                    if (this.parent == null) {
                        clazz = VMClassLoader.loadClass(string, bl);
                        if (clazz != null) {
                            return clazz;
                        }
                        break block6;
                    }
                    return this.parent.loadClass(string, bl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            clazz = this.findClass(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    protected final synchronized Class<?> defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.checkInitialized();
        if (protectionDomain == null) {
            protectionDomain = StaticData.defaultProtectionDomain;
        }
        return VMClassLoader.defineClassWithTransformers(this, string, byArray, n, n2, protectionDomain);
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return this.defineClass(string, byArray, 0, byArray.length, protectionDomain);
    }

    protected final void resolveClass(Class<?> clazz) {
        this.checkInitialized();
        VMClassLoader.resolveClass(clazz);
    }

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        this.checkInitialized();
        return Class.forName(string, false, StaticData.systemClassLoader);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null && (classLoader = VMStackWalker.getCallingClassLoader()) != null && !classLoader.isAncestorOf(this)) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.parent;
    }

    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        this.checkInitialized();
        clazz.setSigners(objectArray);
    }

    protected final synchronized Class<?> findLoadedClass(String string) {
        this.checkInitialized();
        return VMClassLoader.findLoadedClass(this, string);
    }

    public URL getResource(String string) {
        URL uRL = this.parent == null ? VMClassLoader.getResource(string) : this.parent.getResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration<URL> enumeration = this.parent == null ? VMClassLoader.getResources(string) : this.parent.getResources(string);
        return new DoubleEnumeration<URL>(enumeration, this.findResources(string));
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return new EmptyEnumeration<URL>();
    }

    protected URL findResource(String string) {
        return null;
    }

    public static final URL getSystemResource(String string) {
        return StaticData.systemClassLoader.getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        return StaticData.systemClassLoader.getResources(string);
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final InputStream getSystemResourceAsStream(String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null && (classLoader = VMStackWalker.getCallingClassLoader()) != null && classLoader != StaticData.systemClassLoader) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return StaticData.systemClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        if (this.getPackage(string) != null) {
            throw new IllegalArgumentException("Package " + string + " already defined");
        }
        Package package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
        HashMap<String, Package> hashMap = this.definedPackages;
        synchronized (hashMap) {
            this.definedPackages.put(string, package_);
        }
        return package_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        Package package_ = this.parent == null ? VMClassLoader.getPackage(string) : this.parent.getPackage(string);
        if (package_ == null) {
            HashMap<String, Package> hashMap = this.definedPackages;
            synchronized (hashMap) {
                package_ = this.definedPackages.get(string);
            }
        }
        return package_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.definedPackages;
        synchronized (this.definedPackages) {
            Package[] packageArray2 = new Package[this.definedPackages.size()];
            this.definedPackages.values().toArray(packageArray2);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent == null ? VMClassLoader.getPackages() : this.parent.getPackages();
            Package[] packageArray3 = new Package[packageArray.length + packageArray2.length];
            System.arraycopy(packageArray, 0, packageArray3, 0, packageArray.length);
            System.arraycopy(packageArray2, 0, packageArray3, packageArray.length, packageArray2.length);
            return packageArray3;
        }
    }

    protected String findLibrary(String string) {
        return null;
    }

    public void setDefaultAssertionStatus(boolean bl) {
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap<String, Boolean>(StaticData.systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap<String, Boolean>(StaticData.systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(string.toString(), bl);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = null;
        this.classAssertionStatus = null;
    }

    final boolean isAncestorOf(ClassLoader classLoader) {
        while (classLoader != null) {
            if (this == classLoader) {
                return true;
            }
            classLoader = classLoader.parent;
        }
        return false;
    }

    private static URL[] getExtClassLoaderUrls() {
        Object object;
        String string = SystemProperties.getProperty("java.ext.dirs", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object = new File(stringTokenizer.nextToken());
                File[] fileArray = ((File)object).listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    arrayList.add(fileArray[i].toURL());
                }
            }
            catch (Exception exception) {
            }
        }
        object = new URL[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private static void addFileURL(ArrayList arrayList, String string) {
        try {
            arrayList.add(new File(string).toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static URL[] getSystemClassLoaderUrls() {
        URL[] uRLArray;
        String string = SystemProperties.getProperty("java.class.path", ".");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, true);
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = stringTokenizer.nextToken();
            if (uRLArray.equals(File.pathSeparator)) {
                ClassLoader.addFileURL(arrayList, ".");
                continue;
            }
            ClassLoader.addFileURL(arrayList, (String)uRLArray);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) continue;
            ClassLoader.addFileURL(arrayList, ".");
        }
        uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        return uRLArray;
    }

    static ClassLoader defaultGetSystemClassLoader() {
        return ClassLoader.createAuxiliarySystemClassLoader(ClassLoader.createSystemClassLoader(ClassLoader.getSystemClassLoaderUrls(), ClassLoader.createExtClassLoader(ClassLoader.getExtClassLoaderUrls(), null)));
    }

    static ClassLoader createExtClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        if (uRLArray.length > 0) {
            return new URLClassLoader(uRLArray, classLoader);
        }
        return classLoader;
    }

    static ClassLoader createSystemClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        return new URLClassLoader(uRLArray, classLoader){

            protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
                int n;
                SecurityManager securityManager = SecurityManager.current;
                if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                    securityManager.checkPackageAccess(string.substring(0, n));
                }
                return super.loadClass(string, bl);
            }
        };
    }

    static ClassLoader createAuxiliarySystemClassLoader(ClassLoader classLoader) {
        String string = SystemProperties.getProperty("java.system.class.loader", null);
        if (string == null) {
            return classLoader;
        }
        try {
            Constructor<?> constructor = Class.forName(string, false, classLoader).getConstructor(ClassLoader.class);
            return (ClassLoader)constructor.newInstance(classLoader);
        }
        catch (Exception exception) {
            System.err.println("Requested system classloader " + string + " failed.");
            throw (Error)new Error("Requested system classloader " + string + " failed.").initCause(exception);
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new SecurityException("attempt to use uninitialized class loader");
        }
    }

    static class StaticData {
        static final ClassLoader systemClassLoader;
        static final ProtectionDomain defaultProtectionDomain;
        static final Map systemPackageAssertionStatus;
        static final Map systemClassAssertionStatus;

        StaticData() {
        }

        static {
            Serializable serializable;
            systemClassLoader = VMClassLoader.getSystemClassLoader();
            Object object = SystemProperties.getProperty("java.security.manager");
            if (object != null && SecurityManager.current == null) {
                if (((String)object).equals("") || ((String)object).equals("default")) {
                    SecurityManager.current = new SecurityManager();
                } else {
                    try {
                        serializable = Class.forName((String)object, false, systemClassLoader);
                        SecurityManager.current = (SecurityManager)((Class)serializable).newInstance();
                    }
                    catch (Exception exception) {
                        throw (InternalError)new InternalError("Unable to create SecurityManager").initCause(exception);
                    }
                }
            }
            object = new CodeSource(null, null);
            serializable = Policy.getPolicy().getPermissions((CodeSource)object);
            defaultProtectionDomain = new ProtectionDomain((CodeSource)object, (PermissionCollection)serializable);
            systemPackageAssertionStatus = VMClassLoader.packageAssertionStatus();
            systemClassAssertionStatus = VMClassLoader.classAssertionStatus();
        }
    }
}

