/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Byte
extends Number
implements Comparable<Byte> {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = VMClassLoader.getPrimitiveClass('B');
    public static final int SIZE = 8;
    private static Byte[] byteCache = new Byte[256];
    private final byte value;

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) {
        this.value = Byte.parseByte(string, 10);
    }

    public static String toString(byte by) {
        return String.valueOf(by);
    }

    public static byte parseByte(String string) {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) {
        int n2 = Integer.parseInt(string, n, false);
        if ((byte)n2 != n2) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    public static Byte valueOf(String string, int n) {
        return Byte.parseByte(string, n);
    }

    public static Byte valueOf(String string) {
        return Byte.parseByte(string, 10);
    }

    public static Byte valueOf(byte by) {
        return byteCache[by - -128];
    }

    public static Byte decode(String string) {
        int n = Integer.parseInt(string, 10, true);
        if ((byte)n != n) {
            throw new NumberFormatException();
        }
        return (byte)n;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Byte && this.value == ((Byte)object).value;
    }

    @Override
    public int compareTo(Byte by) {
        return this.value - by.value;
    }

    static {
        for (int i = -128; i <= 127; ++i) {
            Byte.byteCache[i - -128] = new Byte((byte)i);
        }
    }
}

