/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Boolean
implements Serializable,
Comparable<Boolean> {
    private static final long serialVersionUID = -3665804199014368530L;
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = VMClassLoader.getPrimitiveClass('Z');
    private final boolean value;

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(String string) {
        this.value = "true".equalsIgnoreCase(string);
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Boolean valueOf(String string) {
        return "true".equalsIgnoreCase(string) ? TRUE : FALSE;
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object object) {
        return object instanceof Boolean && this.value == ((Boolean)object).value;
    }

    public static boolean getBoolean(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return "true".equalsIgnoreCase(System.getProperty(string));
    }

    @Override
    public int compareTo(Boolean bl) {
        return this.value == bl.value ? 0 : (this.value ? 1 : -1);
    }

    public static boolean parseBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }
}

