/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.VMObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClass
implements Serializable {
    static final ObjectStreamField[] INVALID_FIELDS = new ObjectStreamField[0];
    private ObjectStreamClass[] hierarchy = null;
    static final Class[] noArgs = new Class[0];
    static Hashtable methodCache = new Hashtable();
    static final Class[] readObjectSignature = new Class[]{ObjectInputStream.class};
    static final Class[] writeObjectSignature = new Class[]{ObjectOutputStream.class};
    static Hashtable uidCache = new Hashtable();
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable<Class, ObjectStreamClass> classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes = new Class[]{ObjectOutputStream.class};
    private ObjectStreamClass superClass;
    private Class<?> clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize = -1;
    int objectFieldCount;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    Method writeObjectMethod;
    boolean realClassIsSerializable;
    boolean realClassIsExternalizable;
    ObjectStreamField[] fieldMapping;
    Constructor firstNonSerializableParentConstructor;
    private Constructor constructor;
    boolean isProxyClass = false;
    private static final long serialVersionUID = -6120832682080437368L;

    public static ObjectStreamClass lookup(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        return ObjectStreamClass.lookupForClassObject(clazz);
    }

    static ObjectStreamClass lookupForClassObject(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = classLookupTable.get(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass;
        }
        objectStreamClass = new ObjectStreamClass(clazz);
        classLookupTable.put(clazz, objectStreamClass);
        return objectStreamClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
        return objectStreamFieldArray;
    }

    public ObjectStreamField getField(String string) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equals(string)) continue;
            return this.fields[i];
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        return (this.flags & 1) != 0;
    }

    boolean isSerializable() {
        return (this.flags & 2) != 0;
    }

    boolean isExternalizable() {
        return (this.flags & 4) != 0;
    }

    boolean isEnum() {
        return (this.flags & 0x10) != 0;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    ObjectStreamClass[] hierarchy() {
        ObjectStreamClass[] objectStreamClassArray = this.hierarchy;
        if (objectStreamClassArray == null) {
            ObjectStreamClass objectStreamClass;
            int n = 0;
            for (objectStreamClass = this; objectStreamClass != null; objectStreamClass = objectStreamClass.getSuper()) {
                ++n;
            }
            objectStreamClassArray = new ObjectStreamClass[n];
            for (objectStreamClass = this; objectStreamClass != null; objectStreamClass = objectStreamClass.getSuper()) {
                objectStreamClassArray[--n] = objectStreamClass;
            }
            this.hierarchy = objectStreamClassArray;
        }
        return objectStreamClassArray;
    }

    int getFlags() {
        return this.flags;
    }

    ObjectStreamClass(String string, long l, byte by, ObjectStreamField[] objectStreamFieldArray) {
        this.name = string;
        this.uid = l;
        this.flags = by;
        this.fields = objectStreamFieldArray;
    }

    void setClass(Class clazz, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.hierarchy = null;
        this.clazz = clazz;
        this.cacheMethods();
        long l = this.getClassUID(clazz);
        if (this.uid == 0L) {
            this.uid = l;
        } else if (!clazz.isArray() && this.uid != l) {
            String string = clazz + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + l;
            throw new InvalidClassException(string);
        }
        this.isProxyClass = this.clazz != null && Proxy.isProxyClass(this.clazz);
        this.superClass = objectStreamClass;
        this.calculateOffsets();
        try {
            Object[] objectArray = this.getSerialPersistentFields(this.clazz);
            if (objectArray == null) {
                return;
            }
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[objectArray.length + this.fields.length];
            Arrays.sort(objectArray);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this.fields.length && n2 < objectArray.length) {
                int n4 = this.fields[n].compareTo(objectArray[n2]);
                if (n4 < 0) {
                    objectStreamFieldArray[n3] = this.fields[n];
                    this.fields[n].setPersistent(false);
                    this.fields[n].setToSet(false);
                    ++n;
                } else if (n4 > 0) {
                    objectStreamFieldArray[n3] = objectArray[n2];
                    objectStreamFieldArray[n3].setPersistent(true);
                    objectStreamFieldArray[n3].setToSet(false);
                    try {
                        objectStreamFieldArray[n3].lookupField(this.clazz);
                        objectStreamFieldArray[n3].checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    ++n2;
                } else {
                    try {
                        ((ObjectStreamField)objectArray[n2]).lookupField(this.clazz);
                        ((ObjectStreamField)objectArray[n2]).checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (!this.fields[n].getType().equals(((ObjectStreamField)objectArray[n2]).getType())) {
                        throw new InvalidClassException("serialPersistentFields must be compatible with imported fields (about " + this.fields[n].getName() + ")");
                    }
                    objectStreamFieldArray[n3] = this.fields[n];
                    this.fields[n].setPersistent(true);
                    ++n;
                    ++n2;
                }
                ++n3;
            }
            if (n < this.fields.length) {
                while (n < this.fields.length) {
                    this.fields[n].setPersistent(false);
                    this.fields[n].setToSet(false);
                    objectStreamFieldArray[n3] = this.fields[n];
                    ++n;
                    ++n3;
                }
            } else if (n2 < objectArray.length) {
                while (n2 < objectArray.length) {
                    ((ObjectStreamField)objectArray[n2]).setPersistent(true);
                    ((ObjectStreamField)objectArray[n2]).setToSet(false);
                    objectStreamFieldArray[n3] = objectArray[n2];
                    ++n2;
                    ++n3;
                }
            }
            this.fields = new ObjectStreamField[n3];
            System.arraycopy(objectStreamFieldArray, 0, this.fields, 0, n3);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superClass = objectStreamClass;
        this.hierarchy = null;
    }

    void calculateOffsets() {
        ObjectStreamField objectStreamField;
        int n;
        this.primFieldSize = 0;
        int n2 = this.fields.length;
        block6: for (n = 0; n < n2 && (objectStreamField = this.fields[n]).isPrimitive(); ++n) {
            objectStreamField.setOffset(this.primFieldSize);
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    continue block6;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    continue block6;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                }
            }
        }
        this.objectFieldCount = 0;
        while (n < n2) {
            this.fields[n].setOffset(this.objectFieldCount++);
            ++n;
        }
    }

    private Method findMethod(Method[] methodArray, String string, Class[] classArray, Class clazz, boolean bl) {
        block0: for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray2;
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (Modifier.isStatic(n) || bl && !Modifier.isPrivate(n) || !method.getName().equals(string) || method.getReturnType() != clazz || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            for (int j = 0; j < classArray2.length; ++j) {
                if (classArray2[j] != classArray[j]) continue block0;
            }
            AccessController.doPrivileged(new SetAccessibleAction(method));
            return method;
        }
        return null;
    }

    private static boolean inSamePackage(Class clazz, Class clazz2) {
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        int n2 = string2.lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return n == n2;
        }
        String string3 = string.substring(0, n);
        String string4 = string2.substring(0, n2);
        return string3.equals(string4);
    }

    private static Method findAccessibleMethod(String string, Class clazz) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                Method method = clazz2.getDeclaredMethod(string, noArgs);
                int n = method.getModifiers();
                if (clazz2 != clazz && !Modifier.isProtected(n) && !Modifier.isPublic(n) && (Modifier.isPrivate(n) || !ObjectStreamClass.inSamePackage(clazz2, clazz))) continue;
                AccessController.doPrivileged(new SetAccessibleAction(method));
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean loadedByBootOrApplicationClassLoader(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader == null || classLoader == ClassLoader.getSystemClassLoader();
    }

    private void cacheMethods() {
        Class<?> clazz = this.forClass();
        Method[] methodArray = (Method[])methodCache.get(clazz);
        if (methodArray == null) {
            methodArray = new Method[4];
            Method[] methodArray2 = clazz.getDeclaredMethods();
            methodArray[0] = this.findMethod(methodArray2, "readObject", readObjectSignature, Void.TYPE, true);
            methodArray[1] = this.findMethod(methodArray2, "writeObject", writeObjectSignature, Void.TYPE, true);
            methodArray[2] = ObjectStreamClass.findAccessibleMethod("readResolve", clazz);
            methodArray[3] = ObjectStreamClass.findAccessibleMethod("writeReplace", clazz);
            if (ObjectStreamClass.loadedByBootOrApplicationClassLoader(clazz)) {
                methodCache.put(clazz, methodArray);
            }
        }
        this.readObjectMethod = methodArray[0];
        this.writeObjectMethod = methodArray[1];
        this.readResolveMethod = methodArray[2];
        this.writeReplaceMethod = methodArray[3];
    }

    private ObjectStreamClass(Class clazz) {
        this.uid = 0L;
        this.flags = 0;
        this.isProxyClass = Proxy.isProxyClass(clazz);
        this.clazz = clazz;
        this.cacheMethods();
        this.name = clazz.getName();
        this.setFlags(clazz);
        this.setFields(clazz);
        if (Serializable.class.isAssignableFrom(clazz) && !this.isProxyClass) {
            this.uid = this.getClassUID(clazz);
        }
        this.superClass = ObjectStreamClass.lookup(clazz.getSuperclass());
    }

    private void setFlags(Class clazz) {
        if (Externalizable.class.isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 4);
        } else if (Serializable.class.isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 2);
        }
        if (this.writeObjectMethod != null) {
            this.flags = (byte)(this.flags | 1);
        }
        if (clazz.isEnum() || clazz == Enum.class) {
            this.flags = (byte)(this.flags | 0x10);
        }
    }

    private void setFields(Class clazz) {
        int n;
        SetAccessibleAction setAccessibleAction = new SetAccessibleAction();
        if (!this.isSerializable() || this.isExternalizable() || this.isEnum()) {
            this.fields = NO_FIELDS;
            return;
        }
        try {
            Field field = clazz.getDeclaredField("serialPersistentFields");
            setAccessibleAction.setMember(field);
            AccessController.doPrivileged(setAccessibleAction);
            int n2 = field.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2)) {
                this.fields = this.getSerialPersistentFields(clazz);
                if (this.fields != null) {
                    int n3;
                    ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
                    System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
                    Arrays.sort(objectStreamFieldArray, new Comparator(){

                        public int compare(Object object, Object object2) {
                            ObjectStreamField objectStreamField = (ObjectStreamField)object;
                            ObjectStreamField objectStreamField2 = (ObjectStreamField)object2;
                            return objectStreamField.getName().compareTo(objectStreamField2.getName());
                        }
                    });
                    for (n3 = 1; n3 < this.fields.length; ++n3) {
                        if (!objectStreamFieldArray[n3 - 1].getName().equals(objectStreamFieldArray[n3].getName())) continue;
                        this.fields = INVALID_FIELDS;
                        return;
                    }
                    Arrays.sort(this.fields);
                    for (n3 = 0; n3 < this.fields.length; ++n3) {
                        try {
                            this.fields[n3].lookupField(clazz);
                            continue;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            this.fields[n3].setToSet(false);
                        }
                    }
                    this.calculateOffsets();
                    return;
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        int n4 = 0;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            int n5 = fieldArray[n].getModifiers();
            if (Modifier.isTransient(n5) || Modifier.isStatic(n5)) {
                fieldArray[n] = null;
                continue;
            }
            ++n4;
        }
        this.fields = new ObjectStreamField[n4];
        int n6 = 0;
        for (n = 0; n < fieldArray.length; ++n) {
            if (fieldArray[n] == null) continue;
            Field field = fieldArray[n];
            setAccessibleAction.setMember(field);
            AccessController.doPrivileged(setAccessibleAction);
            this.fields[n6] = new ObjectStreamField(fieldArray[n]);
            ++n6;
        }
        Arrays.sort(this.fields);
        for (n = 1; n < this.fields.length; ++n) {
            if (!this.fields[n - 1].getName().equals(this.fields[n].getName())) continue;
            throw new InternalError("Duplicate field " + this.fields[n].getName() + " in class " + clazz.getName());
        }
        this.calculateOffsets();
    }

    private long getClassUID(Class clazz) {
        long l = 0L;
        Long l2 = (Long)uidCache.get(clazz);
        if (l2 != null) {
            l = l2;
        } else {
            if (Enum.class.isAssignableFrom(clazz) || Proxy.isProxyClass(clazz)) {
                return 0L;
            }
            try {
                l = this.getClassUIDFromField(clazz);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    l = this.calculateClassUID(clazz);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + clazz.getName(), noSuchAlgorithmException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            if (ObjectStreamClass.loadedByBootOrApplicationClassLoader(clazz)) {
                uidCache.put(clazz, l);
            }
        }
        return l;
    }

    long getClassUIDFromField(Class clazz) throws NoSuchFieldException {
        long l;
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            SetAccessibleAction setAccessibleAction = new SetAccessibleAction(field);
            AccessController.doPrivileged(setAccessibleAction);
            int n = field.getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isFinal(n) || field.getType() != Long.TYPE) {
                throw new NoSuchFieldException();
            }
            l = field.getLong(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchFieldException();
        }
        return l;
    }

    long calculateClassUID(Class clazz) throws NoSuchAlgorithmException, IOException {
        Object object;
        Object object2;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object2 = new Gnu();
            Security.addProvider((Provider)object2);
            messageDigest = MessageDigest.getInstance("SHA");
        }
        DigestOutputStream digestOutputStream = new DigestOutputStream(nullOutputStream, messageDigest);
        object2 = new DataOutputStream(digestOutputStream);
        ((DataOutputStream)object2).writeUTF(clazz.getName());
        int n = clazz.getModifiers();
        ((DataOutputStream)object2).writeInt(n &= 0x611);
        if (!clazz.isArray()) {
            object = clazz.getInterfaces();
            Arrays.sort(object, interfaceComparator);
            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                ((DataOutputStream)object2).writeUTF(object[i].getName());
            }
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        Arrays.sort(fieldArray, memberComparator);
        for (int i = 0; i < fieldArray.length; ++i) {
            object = fieldArray[i];
            n = ((Field)object).getModifiers();
            if (Modifier.isPrivate(n) && (Modifier.isStatic(n) || Modifier.isTransient(n))) continue;
            ((DataOutputStream)object2).writeUTF(((Field)object).getName());
            ((DataOutputStream)object2).writeInt(n);
            ((DataOutputStream)object2).writeUTF(TypeSignature.getEncodingOfClass(((Field)object).getType()));
        }
        if (VMObjectStreamClass.hasClassInitializer(clazz)) {
            ((DataOutputStream)object2).writeUTF("<clinit>");
            ((DataOutputStream)object2).writeInt(8);
            ((DataOutputStream)object2).writeUTF("()V");
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        Arrays.sort(constructorArray, memberComparator);
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            n = constructor.getModifiers();
            if (Modifier.isPrivate(n)) continue;
            ((DataOutputStream)object2).writeUTF("<init>");
            ((DataOutputStream)object2).writeInt(n);
            ((DataOutputStream)object2).writeUTF(TypeSignature.getEncodingOfConstructor(constructor).replace('/', '.'));
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        Arrays.sort(methodArray, memberComparator);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            n = method.getModifiers();
            if (Modifier.isPrivate(n)) continue;
            ((DataOutputStream)object2).writeUTF(method.getName());
            ((DataOutputStream)object2).writeInt(n);
            ((DataOutputStream)object2).writeUTF(TypeSignature.getEncodingOfMethod(method).replace('/', '.'));
        }
        ((FilterOutputStream)object2).close();
        byte[] byArray = messageDigest.digest();
        long l = 0L;
        int n2 = byArray.length < 8 ? byArray.length : 8;
        for (int i = 0; i < n2; ++i) {
            l += (long)(byArray[i] & 0xFF) << 8 * i;
        }
        return l;
    }

    private ObjectStreamField[] getSerialPersistentFields(Class clazz) throws NoSuchFieldException, IllegalAccessException {
        ObjectStreamField[] objectStreamFieldArray = null;
        Field field = clazz.getDeclaredField("serialPersistentFields");
        field.setAccessible(true);
        int n = field.getModifiers();
        if (!(Modifier.isStatic(n) && Modifier.isFinal(n) && Modifier.isPrivate(n))) {
            return null;
        }
        ObjectStreamField[] objectStreamFieldArray2 = (ObjectStreamField[])field.get(null);
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        System.arraycopy(objectStreamFieldArray2, 0, objectStreamFieldArray, 0, objectStreamFieldArray2.length);
        return objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Externalizable newInstance() throws InvalidClassException {
        ObjectStreamClass objectStreamClass = this;
        synchronized (objectStreamClass) {
            if (this.constructor == null) {
                try {
                    final Constructor<?> constructor = this.clazz.getConstructor(new Class[0]);
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            constructor.setAccessible(true);
                            return null;
                        }
                    });
                    this.constructor = constructor;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InvalidClassException(this.clazz.getName(), "No public zero-argument constructor");
                }
            }
        }
        try {
            return (Externalizable)this.constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw (InvalidClassException)new InvalidClassException(this.clazz.getName(), "Unable to instantiate").initCause(exception);
        }
    }

    private static final class MemberComparator
    implements Comparator {
        private MemberComparator() {
        }

        public int compare(Object object, Object object2) {
            Member member = (Member)object;
            Member member2 = (Member)object2;
            int n = member.getName().compareTo(member2.getName());
            if (n == 0) {
                return TypeSignature.getEncodingOfMember(member).compareTo(TypeSignature.getEncodingOfMember(member2));
            }
            return n;
        }
    }

    private static final class InterfaceComparator
    implements Comparator {
        private InterfaceComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Class)object).getName().compareTo(((Class)object2).getName());
        }
    }
}

