/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityMap2Int;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static int defaultProtocolVersion = 2;
    private DataOutputStream dataOutput;
    private boolean writeDataAsBlocks;
    private DataOutputStream realOutput;
    private DataOutputStream blockDataOutput;
    private byte[] blockData;
    private int blockDataCount;
    private Object currentObject;
    ObjectStreamClass currentObjectStreamClass;
    private PutField currentPutField;
    private boolean fieldsAlreadyWritten;
    private boolean replacementEnabled;
    private boolean isSerializing;
    private int nextOID;
    private ObjectIdentityMap2Int OIDLookupTable;
    private int protocolVersion;
    private boolean useSubclassMethod;
    private SetAccessibleAction setAccessible = new SetAccessibleAction();
    private int depth = 0;
    private boolean dump = false;
    private static final boolean DEBUG = false;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && ObjectOutputStream.overridesMethods(this.getClass())) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.realOutput = new DataOutputStream(outputStream);
        this.blockData = new byte[1024];
        this.blockDataCount = 0;
        this.blockDataOutput = new DataOutputStream(this);
        this.setBlockDataMode(true);
        this.replacementEnabled = false;
        this.isSerializing = false;
        this.nextOID = 0x7E0000;
        this.OIDLookupTable = new ObjectIdentityMap2Int();
        this.protocolVersion = defaultProtocolVersion;
        this.useSubclassMethod = false;
        this.writeStreamHeader();
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        this.writeObject(object, true);
    }

    public void writeUnshared(Object object) throws IOException {
        this.writeObject(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeObject(Object object, boolean bl) throws IOException {
        if (this.useSubclassMethod) {
            if (this.dump) {
                this.dumpElementln("WRITE OVERRIDE: " + object);
            }
            this.writeObjectOverride(object);
            return;
        }
        if (this.dump) {
            this.dumpElementln("WRITE: ", object);
        }
        this.depth += 2;
        boolean bl2 = this.isSerializing;
        boolean bl3 = this.setBlockDataMode(false);
        try {
            try {
                block49: {
                    Object object2;
                    ObjectStreamClass objectStreamClass;
                    Class<? extends Object> clazz;
                    this.isSerializing = true;
                    boolean bl4 = false;
                    Object object3 = null;
                    while (true) {
                        if (object == null) {
                            this.realOutput.writeByte(112);
                            break block49;
                        }
                        int n = this.findHandle(object);
                        if (n >= 0 && bl) {
                            this.realOutput.writeByte(113);
                            this.realOutput.writeInt(n);
                            break block49;
                        }
                        if (object instanceof Class) {
                            clazz = (Class<? extends Object>)object;
                            objectStreamClass = ObjectStreamClass.lookupForClassObject(clazz);
                            this.realOutput.writeByte(118);
                            if (!objectStreamClass.isProxyClass) {
                                this.writeObject(objectStreamClass);
                            } else {
                                boolean bl5;
                                System.err.println("1");
                                this.realOutput.writeByte(125);
                                object2 = clazz.getInterfaces();
                                this.realOutput.writeInt(((Class<?>[])object2).length);
                                for (bl5 = false; bl5 < ((Class<?>[])object2).length; bl5 += 1) {
                                    this.realOutput.writeUTF(((Class)object2[bl5]).getName());
                                }
                                bl5 = this.setBlockDataMode(true);
                                this.annotateProxyClass(clazz);
                                this.setBlockDataMode(bl5);
                                this.realOutput.writeByte(120);
                                this.writeObject(objectStreamClass.getSuper());
                            }
                            if (bl) {
                                this.assignNewHandle(object);
                            }
                            break block49;
                        }
                        if (object instanceof ObjectStreamClass) {
                            this.writeClassDescriptor((ObjectStreamClass)object);
                            break block49;
                        }
                        clazz = object.getClass();
                        objectStreamClass = ObjectStreamClass.lookupForClassObject(clazz);
                        if (objectStreamClass == null) {
                            throw new NotSerializableException(clazz.getName());
                        }
                        if (objectStreamClass.isEnum()) {
                            this.realOutput.writeByte(126);
                            this.writeObject(objectStreamClass);
                            if (bl) {
                                this.assignNewHandle(object);
                            }
                            this.writeObject(((Enum)object).name());
                            break block49;
                        }
                        if (!this.replacementEnabled && !(object instanceof Serializable) || bl4) break;
                        object3 = object;
                        if (object instanceof Serializable) {
                            try {
                                object2 = objectStreamClass.writeReplaceMethod;
                                if (object2 != null) {
                                    object = ((Method)object2).invoke(object, new Object[0]);
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                        }
                        if (this.replacementEnabled) {
                            object = this.replaceObject(object);
                        }
                        bl4 = true;
                    }
                    if (object instanceof String) {
                        object2 = (String)object;
                        long l = this.realOutput.getUTFlength((String)object2, 0, 0L);
                        if (l <= 65535L) {
                            this.realOutput.writeByte(116);
                            if (bl) {
                                this.assignNewHandle(object);
                            }
                            this.realOutput.writeUTFShort((String)object2, (int)l);
                        } else {
                            this.realOutput.writeByte(124);
                            if (bl) {
                                this.assignNewHandle(object);
                            }
                            this.realOutput.writeUTFLong((String)object2, l);
                        }
                    } else if (clazz.isArray()) {
                        this.realOutput.writeByte(117);
                        this.writeObject(objectStreamClass);
                        if (bl) {
                            this.assignNewHandle(object);
                        }
                        this.writeArraySizeAndElements(object, clazz.getComponentType());
                    } else {
                        this.realOutput.writeByte(115);
                        this.writeObject(objectStreamClass);
                        if (bl) {
                            if (bl4) {
                                this.assignNewHandle(object3);
                            } else {
                                this.assignNewHandle(object);
                            }
                        }
                        if (object instanceof Externalizable) {
                            if (this.protocolVersion == 2) {
                                this.setBlockDataMode(true);
                            }
                            ((Externalizable)object).writeExternal(this);
                            if (this.protocolVersion == 2) {
                                this.setBlockDataMode(false);
                                this.realOutput.writeByte(120);
                            }
                        } else {
                            if (!(object instanceof Serializable)) throw new NotSerializableException(clazz.getName() + " in " + object.getClass());
                            object2 = this.currentObject;
                            ObjectStreamClass objectStreamClass2 = this.currentObjectStreamClass;
                            this.currentObject = object;
                            ObjectStreamClass[] objectStreamClassArray = objectStreamClass.hierarchy();
                            for (int i = 0; i < objectStreamClassArray.length; ++i) {
                                this.currentObjectStreamClass = objectStreamClassArray[i];
                                this.fieldsAlreadyWritten = false;
                                if (this.currentObjectStreamClass.hasWriteMethod()) {
                                    if (this.dump) {
                                        this.dumpElementln("WRITE METHOD CALLED FOR: ", object);
                                    }
                                    this.setBlockDataMode(true);
                                    this.callWriteMethod(object, this.currentObjectStreamClass);
                                    this.setBlockDataMode(false);
                                    this.realOutput.writeByte(120);
                                    if (!this.dump) continue;
                                    this.dumpElementln("WRITE ENDBLOCKDATA FOR: ", object);
                                    continue;
                                }
                                if (this.dump) {
                                    this.dumpElementln("WRITE FIELDS CALLED FOR: ", object);
                                }
                                this.writeFields(object, this.currentObjectStreamClass);
                            }
                            this.currentObject = object2;
                            this.currentObjectStreamClass = objectStreamClass2;
                            this.currentPutField = null;
                        }
                    }
                }
                Object var15_22 = null;
                this.isSerializing = bl2;
            }
            catch (ObjectStreamException objectStreamException) {
                throw objectStreamException;
            }
            catch (IOException iOException) {
                this.realOutput.writeByte(123);
                this.reset(true);
                this.setBlockDataMode(false);
                try {
                    this.writeObject(iOException);
                }
                catch (IOException iOException2) {
                    StreamCorruptedException streamCorruptedException = new StreamCorruptedException(iOException2 + " thrown while exception was being written to stream.");
                    throw streamCorruptedException;
                }
                this.reset(true);
                Object var15_23 = null;
                this.isSerializing = bl2;
                this.setBlockDataMode(bl3);
                this.depth -= 2;
                if (!this.dump) return;
                this.dumpElementln("END: ", object);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            this.isSerializing = bl2;
            this.setBlockDataMode(bl3);
            this.depth -= 2;
            if (!this.dump) throw throwable;
            this.dumpElementln("END: ", object);
            throw throwable;
        }
        this.setBlockDataMode(bl3);
        this.depth -= 2;
        if (!this.dump) return;
        this.dumpElementln("END: ", object);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        if (objectStreamClass.isProxyClass) {
            boolean bl;
            this.realOutput.writeByte(125);
            Class<?>[] classArray = objectStreamClass.forClass().getInterfaces();
            this.realOutput.writeInt(classArray.length);
            for (bl = false; bl < classArray.length; bl += 1) {
                this.realOutput.writeUTF(classArray[bl].getName());
            }
            this.assignNewHandle(objectStreamClass);
            bl = this.setBlockDataMode(true);
            this.annotateProxyClass(objectStreamClass.forClass());
            this.setBlockDataMode(bl);
            this.realOutput.writeByte(120);
        } else {
            int n;
            this.realOutput.writeByte(114);
            this.realOutput.writeUTF(objectStreamClass.getName());
            if (objectStreamClass.isEnum()) {
                this.realOutput.writeLong(0L);
            } else {
                this.realOutput.writeLong(objectStreamClass.getSerialVersionUID());
            }
            this.assignNewHandle(objectStreamClass);
            int n2 = objectStreamClass.getFlags();
            if (this.protocolVersion == 2 && objectStreamClass.isExternalizable()) {
                n2 |= 8;
            }
            this.realOutput.writeByte(n2);
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fields;
            if (objectStreamFieldArray == ObjectStreamClass.INVALID_FIELDS) {
                throw new InvalidClassException(objectStreamClass.getName(), "serialPersistentFields is invalid");
            }
            this.realOutput.writeShort(objectStreamFieldArray.length);
            for (n = 0; n < objectStreamFieldArray.length; ++n) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[n];
                this.realOutput.writeByte(objectStreamField.getTypeCode());
                this.realOutput.writeUTF(objectStreamField.getName());
                if (objectStreamField.isPrimitive()) continue;
                this.writeObject(objectStreamField.getTypeString());
            }
            n = this.setBlockDataMode(true) ? 1 : 0;
            this.annotateClass(objectStreamClass.forClass());
            this.setBlockDataMode(n != 0);
            this.realOutput.writeByte(120);
        }
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            this.writeObject(objectStreamClass.getSuper());
        } else {
            this.writeObject(null);
        }
    }

    public void defaultWriteObject() throws IOException, NotActiveException {
        this.markFieldsWritten();
        this.writeFields(this.currentObject, this.currentObjectStreamClass);
    }

    private void markFieldsWritten() throws IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultWriteObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyWritten) {
            throw new IOException("Only one of writeFields and defaultWriteObject may be called, and it may only be called once");
        }
        this.fieldsAlreadyWritten = true;
    }

    public void reset() throws IOException {
        this.reset(false);
    }

    private void reset(boolean bl) throws IOException {
        if (!bl) {
            if (this.isSerializing) {
                throw new IOException("Reset called while serialization in progress");
            }
            this.realOutput.writeByte(121);
        }
        this.clearHandles();
    }

    public void useProtocolVersion(int n) throws IOException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid protocol version requested.");
        }
        if (this.nextOID != 0x7E0000) {
            throw new IllegalStateException("Protocol version cannot be changed after serialization started.");
        }
        this.protocolVersion = n;
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean bl2 = this.replacementEnabled;
        this.replacementEnabled = bl;
        return bl2;
    }

    protected void writeStreamHeader() throws IOException {
        this.realOutput.writeShort(-21267);
        this.realOutput.writeShort(5);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected void writeObjectOverride(Object object) throws NotActiveException, IOException {
        throw new NotActiveException("Subclass of ObjectOutputStream must implement writeObjectOverride");
    }

    @Override
    public void write(int n) throws IOException {
        if (this.writeDataAsBlocks) {
            if (this.blockDataCount == 1024) {
                this.drain();
            }
            this.blockData[this.blockDataCount++] = (byte)n;
        } else {
            this.realOutput.write(n);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.writeDataAsBlocks) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.blockDataCount + n2 < 1024) {
                System.arraycopy(byArray, n, this.blockData, this.blockDataCount, n2);
                this.blockDataCount += n2;
            } else {
                this.drain();
                this.writeBlockDataHeader(n2);
                this.realOutput.write(byArray, n, n2);
            }
        } else {
            this.realOutput.write(byArray, n, n2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.realOutput.flush();
    }

    protected void drain() throws IOException {
        if (this.blockDataCount == 0) {
            return;
        }
        if (this.writeDataAsBlocks) {
            this.writeBlockDataHeader(this.blockDataCount);
        }
        this.realOutput.write(this.blockData, 0, this.blockDataCount);
        this.blockDataCount = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.realOutput.close();
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.blockDataOutput.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.blockDataOutput.writeByte(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.blockDataOutput.writeShort(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.blockDataOutput.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.blockDataOutput.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.blockDataOutput.writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.blockDataOutput.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.blockDataOutput.writeDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.blockDataOutput.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.dataOutput.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.dataOutput.writeUTF(string);
    }

    public PutField putFields() throws IOException {
        if (this.currentPutField != null) {
            return this.currentPutField;
        }
        this.currentPutField = new PutField(){
            private byte[] prim_field_data;
            private Object[] objs;
            {
                this.prim_field_data = new byte[ObjectOutputStream.this.currentObjectStreamClass.primFieldSize];
                this.objs = new Object[ObjectOutputStream.this.currentObjectStreamClass.objectFieldCount];
            }

            private ObjectStreamField getField(String string) {
                ObjectStreamField objectStreamField = ObjectOutputStream.this.currentObjectStreamClass.getField(string);
                if (objectStreamField == null) {
                    throw new IllegalArgumentException("no such serializable field " + string);
                }
                return objectStreamField;
            }

            public void put(String string, boolean bl) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'Z');
                this.prim_field_data[objectStreamField.getOffset()] = (byte)(bl ? 1 : 0);
            }

            public void put(String string, byte by) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'B');
                this.prim_field_data[objectStreamField.getOffset()] = by;
            }

            public void put(String string, char c) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'C');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(c >>> 8);
                this.prim_field_data[n] = (byte)c;
            }

            public void put(String string, double d) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'D');
                int n = objectStreamField.getOffset();
                long l = Double.doubleToLongBits(d);
                this.prim_field_data[n++] = (byte)(l >>> 52);
                this.prim_field_data[n++] = (byte)(l >>> 48);
                this.prim_field_data[n++] = (byte)(l >>> 40);
                this.prim_field_data[n++] = (byte)(l >>> 32);
                this.prim_field_data[n++] = (byte)(l >>> 24);
                this.prim_field_data[n++] = (byte)(l >>> 16);
                this.prim_field_data[n++] = (byte)(l >>> 8);
                this.prim_field_data[n] = (byte)l;
            }

            public void put(String string, float f) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'F');
                int n = objectStreamField.getOffset();
                int n2 = Float.floatToIntBits(f);
                this.prim_field_data[n++] = (byte)(n2 >>> 24);
                this.prim_field_data[n++] = (byte)(n2 >>> 16);
                this.prim_field_data[n++] = (byte)(n2 >>> 8);
                this.prim_field_data[n] = (byte)n2;
            }

            public void put(String string, int n) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'I');
                int n2 = objectStreamField.getOffset();
                this.prim_field_data[n2++] = (byte)(n >>> 24);
                this.prim_field_data[n2++] = (byte)(n >>> 16);
                this.prim_field_data[n2++] = (byte)(n >>> 8);
                this.prim_field_data[n2] = (byte)n;
            }

            public void put(String string, long l) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'J');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(l >>> 52);
                this.prim_field_data[n++] = (byte)(l >>> 48);
                this.prim_field_data[n++] = (byte)(l >>> 40);
                this.prim_field_data[n++] = (byte)(l >>> 32);
                this.prim_field_data[n++] = (byte)(l >>> 24);
                this.prim_field_data[n++] = (byte)(l >>> 16);
                this.prim_field_data[n++] = (byte)(l >>> 8);
                this.prim_field_data[n] = (byte)l;
            }

            public void put(String string, short s) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'S');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(s >>> 8);
                this.prim_field_data[n] = (byte)s;
            }

            public void put(String string, Object object) {
                ObjectStreamField objectStreamField = this.getField(string);
                if (object != null && !objectStreamField.getType().isAssignableFrom(object.getClass())) {
                    throw new IllegalArgumentException("Class " + object.getClass() + " cannot be cast to " + objectStreamField.getType());
                }
                this.objs[objectStreamField.getOffset()] = object;
            }

            public void write(ObjectOutput objectOutput) throws IOException {
                boolean bl = ObjectOutputStream.this.setBlockDataMode(false);
                objectOutput.write(this.prim_field_data);
                for (int i = 0; i < this.objs.length; ++i) {
                    objectOutput.writeObject(this.objs[i]);
                }
                ObjectOutputStream.this.setBlockDataMode(bl);
            }

            private void checkType(ObjectStreamField objectStreamField, char c) throws IllegalArgumentException {
                if (TypeSignature.getEncodingOfClass(objectStreamField.getType()).charAt(0) != c) {
                    throw new IllegalArgumentException();
                }
            }
        };
        return this.currentPutField;
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException("writeFields can only be called after putFields has been called");
        }
        this.markFieldsWritten();
        this.currentPutField.write(this);
    }

    private void writeBlockDataHeader(int n) throws IOException {
        if (n < 256) {
            this.realOutput.writeByte(119);
            this.realOutput.write(n);
        } else {
            this.realOutput.writeByte(122);
            this.realOutput.writeInt(n);
        }
    }

    private int findHandle(Object object) {
        return this.OIDLookupTable.get(object);
    }

    private int assignNewHandle(Object object) {
        this.OIDLookupTable.put(object, this.nextOID);
        return this.nextOID++;
    }

    private void clearHandles() {
        this.nextOID = 0x7E0000;
        this.OIDLookupTable.clear();
    }

    private void writeArraySizeAndElements(Object object, Class clazz) throws IOException {
        int n = Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeBoolean(blArray[i]);
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.realOutput.writeInt(n);
                this.realOutput.write(byArray, 0, n);
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeChar(cArray[i]);
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeDouble(dArray[i]);
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeFloat(fArray[i]);
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeInt(nArray[i]);
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeLong(lArray[i]);
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeShort(sArray[i]);
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            this.realOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeObject(objectArray[i]);
            }
        }
    }

    private void writeFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fields;
        boolean bl = this.setBlockDataMode(false);
        try {
            this.writeFields(object, objectStreamFieldArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidClassException invalidClassException = new InvalidClassException("writing fields of class " + objectStreamClass.forClass().getName());
            invalidClassException.initCause(illegalArgumentException);
            throw invalidClassException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unexpected exception " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        this.setBlockDataMode(bl);
    }

    private void writeFields(Object object, ObjectStreamField[] objectStreamFieldArray) throws IllegalArgumentException, IllegalAccessException, IOException {
        block11: for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            Field field = objectStreamField.field;
            switch (objectStreamField.getTypeCode()) {
                case 'Z': {
                    this.realOutput.writeBoolean(field.getBoolean(object));
                    continue block11;
                }
                case 'B': {
                    this.realOutput.writeByte(field.getByte(object));
                    continue block11;
                }
                case 'S': {
                    this.realOutput.writeShort(field.getShort(object));
                    continue block11;
                }
                case 'C': {
                    this.realOutput.writeChar(field.getChar(object));
                    continue block11;
                }
                case 'I': {
                    this.realOutput.writeInt(field.getInt(object));
                    continue block11;
                }
                case 'F': {
                    this.realOutput.writeFloat(field.getFloat(object));
                    continue block11;
                }
                case 'J': {
                    this.realOutput.writeLong(field.getLong(object));
                    continue block11;
                }
                case 'D': {
                    this.realOutput.writeDouble(field.getDouble(object));
                    continue block11;
                }
                case 'L': 
                case '[': {
                    this.writeObject(field.get(object));
                    continue block11;
                }
                default: {
                    throw new IOException("Unexpected type code " + objectStreamField.getTypeCode());
                }
            }
        }
    }

    boolean setBlockDataMode(boolean bl) throws IOException {
        if (bl == this.writeDataAsBlocks) {
            return bl;
        }
        this.drain();
        boolean bl2 = this.writeDataAsBlocks;
        this.writeDataAsBlocks = bl;
        this.dataOutput = bl ? this.blockDataOutput : this.realOutput;
        return bl2;
    }

    private void callWriteMethod(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        this.currentPutField = null;
        try {
            Object[] objectArray = new Object[]{this};
            objectStreamClass.writeObjectMethod.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            IOException iOException = new IOException("Exception thrown from writeObject() on " + objectStreamClass.forClass().getName() + ": " + throwable.getClass().getName());
            iOException.initCause(throwable);
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failure invoking writeObject() on " + objectStreamClass.forClass().getName() + ": " + exception.getClass().getName());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpElementln(String string, Object object) {
        try {
            block6: {
                try {
                    for (int i = 0; i < this.depth; ++i) {
                        System.out.print(" ");
                    }
                    System.out.print(Thread.currentThread() + ": ");
                    System.out.print(string);
                    if (Proxy.isProxyClass(object.getClass())) {
                        System.out.print(object.getClass());
                        break block6;
                    }
                    System.out.print(object);
                }
                catch (Exception exception) {
                    Object var5_6 = null;
                    System.out.println();
                }
            }
            Object var5_5 = null;
            System.out.println();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            System.out.println();
            throw throwable;
        }
    }

    private void dumpElementln(String string) {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(" ");
        }
        System.out.print(Thread.currentThread() + ": ");
        System.out.println(string);
    }

    private static boolean overridesMethods(final Class<?> clazz) {
        if (clazz == ObjectOutputStream.class) {
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Method[] methodArray = clazz.getDeclaredMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Class<?>[] classArray;
                    String string = methodArray[i].getName();
                    if (!(string.equals("writeUnshared") ? (classArray = methodArray[i].getParameterTypes()).length == 1 && classArray[0] == Object.class && methodArray[i].getReturnType() == Void.class : string.equals("putFields") && methodArray[i].getParameterTypes().length == 0 && methodArray[i].getReturnType() == PutField.class)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

