/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.FileChannelImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private final FileChannelImpl ch;

    public FileOutputStream(String string, boolean bl) throws SecurityException, FileNotFoundException {
        this(new File(string), bl);
    }

    public FileOutputStream(String string) throws SecurityException, FileNotFoundException {
        this(string, false);
    }

    public FileOutputStream(File file) throws SecurityException, FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(file.getPath());
        }
        try {
            this.ch = FileChannelImpl.create(file, bl ? 6 : 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getPath());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    public FileOutputStream(FileDescriptor fileDescriptor) throws SecurityException {
        if (!fileDescriptor.valid()) {
            throw new SecurityException("Invalid FileDescriptor");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.ch = (FileChannelImpl)fileDescriptor.channel;
    }

    FileOutputStream(FileChannelImpl fileChannelImpl) {
        this.ch = fileChannelImpl;
    }

    protected void finalize() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileDescriptor getFD() throws IOException {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.fd == null) {
                this.fd = new FileDescriptor(this.ch);
            }
            return this.fd;
        }
    }

    public void write(int n) throws IOException {
        this.ch.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ch.write(ByteBuffer.wrap(byArray, n, n2));
    }

    public void close() throws IOException {
        this.ch.close();
    }

    public synchronized FileChannel getChannel() {
        return this.ch;
    }
}

