/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.lang.CPStringBuilder;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    byte[] buf = new byte[8];

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        return DataInputStream.convertToBoolean(this.in.read());
    }

    public final byte readByte() throws IOException {
        return DataInputStream.convertToByte(this.in.read());
    }

    public final char readChar() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToChar(this.buf);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative length: " + n2);
        }
        while (n2 > 0) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    public final int readInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return DataInputStream.convertToInt(this.buf);
    }

    public final String readLine() throws IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (true) {
            int n;
            if ((n = this.in.read()) == -1) {
                return cPStringBuilder.length() > 0 ? cPStringBuilder.toString() : null;
            }
            if (n == 13) {
                int n2 = this.in.read();
                if (n2 == 10 || n2 == -1) break;
                if (!(this.in instanceof PushbackInputStream)) {
                    this.in = new PushbackInputStream(this.in);
                }
                ((PushbackInputStream)this.in).unread(n2);
                break;
            }
            if (n == 10) break;
            cPStringBuilder.append((char)n);
        }
        return cPStringBuilder.length() > 0 ? cPStringBuilder.toString() : "";
    }

    public final long readLong() throws IOException {
        this.readFully(this.buf, 0, 8);
        return DataInputStream.convertToLong(this.buf);
    }

    public final short readShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToShort(this.buf);
    }

    public final int readUnsignedByte() throws IOException {
        return DataInputStream.convertToUnsignedByte(this.in.read());
    }

    public final int readUnsignedShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToUnsignedShort(this.buf);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        return DataInputStream.readUTF(dataInput, n);
    }

    final String readUTFLong() throws IOException {
        long l = this.readLong();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("The string length > Integer.MAX_VALUE");
        }
        int n = (int)l;
        return DataInputStream.readUTF(this, n);
    }

    private static final String readUTF(DataInput dataInput, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        return DataInputStream.convertFromUTF(byArray);
    }

    public final int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }

    static boolean convertToBoolean(int n) throws EOFException {
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    static byte convertToByte(int n) throws EOFException {
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    static int convertToUnsignedByte(int n) throws EOFException {
        if (n < 0) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    static char convertToChar(byte[] byArray) {
        return (char)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    static short convertToShort(byte[] byArray) {
        return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    static int convertToUnsignedShort(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    static int convertToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    static long convertToLong(byte[] byArray) {
        return (long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[4] & 0xFF) << 24 | (long)(byArray[5] & 0xFF) << 16 | (long)(byArray[6] & 0xFF) << 8 | (long)(byArray[7] & 0xFF);
    }

    static String convertFromUTF(byte[] byArray) throws EOFException, UTFDataFormatException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(byArray.length / 2 + 2);
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0x80) == 0) {
                cPStringBuilder.append((char)(byArray[n++] & 0xFF));
                continue;
            }
            if ((byArray[n] & 0xE0) == 192) {
                if (n + 1 >= byArray.length || (byArray[n + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cPStringBuilder.append((char)((byArray[n++] & 0x1F) << 6 | byArray[n++] & 0x3F));
                continue;
            }
            if ((byArray[n] & 0xF0) == 224) {
                if (n + 2 >= byArray.length || (byArray[n + 1] & 0xC0) != 128 || (byArray[n + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cPStringBuilder.append((char)((byArray[n++] & 0xF) << 12 | (byArray[n++] & 0x3F) << 6 | byArray[n++] & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        return cPStringBuilder.toString();
    }
}

