/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.VMConsole;

public final class Console
implements Flushable {
    private static Console console = new Console();

    public static Console console() {
        return console;
    }

    private Console() {
    }

    public PrintWriter writer() {
        return new PrintWriter(new OutputStreamWriter(System.out));
    }

    public Reader reader() {
        return new InputStreamReader(System.in);
    }

    public Console format(String string, Object ... objectArray) {
        System.out.printf(string, objectArray);
        return this;
    }

    public Console printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    public String readLine(String string, Object ... objectArray) {
        this.format(string, objectArray);
        return this.readLine();
    }

    public String readLine() {
        String string = null;
        try {
            string = new BufferedReader(this.reader()).readLine();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return string;
    }

    public char[] readPassword(String string, Object ... objectArray) {
        this.format(string, objectArray);
        return this.readPassword();
    }

    public char[] readPassword() {
        String string = VMConsole.readPassword(this);
        System.out.println();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public void flush() throws IOException {
        System.out.flush();
    }
}

