/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int n) {
        this.buf = new char[n];
    }

    public void close() {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
        }
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            return cArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.resize(1);
            this.buf[this.count++] = (char)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            if (n2 >= 0) {
                this.resize(n2);
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            if (n2 >= 0) {
                this.resize(n2);
            }
            string.getChars(n, n + n2, this.buf, this.count);
            this.count += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            writer.write(this.buf, 0, this.count);
        }
    }

    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public CharArrayWriter append(CharSequence charSequence) {
        try {
            this.write(charSequence == null ? "null" : charSequence.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public CharArrayWriter append(CharSequence charSequence, int n, int n2) {
        try {
            this.write(charSequence == null ? "null" : charSequence.subSequence(n, n2).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    private void resize(int n) {
        if (this.count + n >= this.buf.length) {
            int n2 = this.buf.length * 2;
            if (this.count + n > n2) {
                n2 = this.count + n;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            this.buf = cArray;
        }
    }
}

