/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > cArray.length) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.count = n + n2;
        if (this.count > this.buf.length) {
            this.count = this.buf.length;
        }
        this.markedPos = this.pos = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.markedPos = this.pos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (this.pos < 0) {
                throw new ArrayIndexOutOfBoundsException(this.pos);
            }
            if (this.pos < this.count) {
                return this.buf[this.pos++] & 0xFFFF;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.count) {
                return -1;
            }
            int n3 = Math.min(this.count - this.pos, n2);
            System.arraycopy(this.buf, this.pos, cArray, n, n3);
            this.pos += n3;
            return n3;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return this.pos < this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.pos = this.markedPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            long l2 = Math.min((long)(this.count - this.pos), l < 0L ? 0L : l);
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }
    }
}

