/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.Visibility;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class BeanContextSupport
extends BeanContextChildSupport
implements BeanContext,
Serializable,
PropertyChangeListener,
VetoableChangeListener {
    private static final long serialVersionUID = -4879613978649577204L;
    protected transient ArrayList bcmListeners;
    protected transient HashMap children;
    protected transient boolean designTime;
    protected transient Locale locale;
    protected transient boolean okToUseGui;
    private transient boolean serializing;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.bcsPreDeserializationHook(objectInputStream);
        BeanContext beanContext = this.getBeanContextPeer();
        if (beanContext == null || beanContext == this) {
            this.readChildren(objectInputStream);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        this.serializing = true;
        objectOutputStream.defaultWriteObject();
        this.bcsPreSerializationHook(objectOutputStream);
        BeanContext beanContext = this.getBeanContextPeer();
        if (beanContext == null || beanContext == this) {
            this.writeChildren(objectOutputStream);
        }
        this.serializing = false;
    }

    public BeanContextSupport() {
        this(null, null, false, true);
    }

    public BeanContextSupport(BeanContext beanContext) {
        this(beanContext, null, false, true);
    }

    public BeanContextSupport(BeanContext beanContext, Locale locale) {
        this(beanContext, locale, false, true);
    }

    public BeanContextSupport(BeanContext beanContext, Locale locale, boolean bl) {
        this(beanContext, locale, bl, true);
    }

    public BeanContextSupport(BeanContext beanContext, Locale locale, boolean bl, boolean bl2) {
        super(beanContext);
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.designTime = bl;
        this.okToUseGui = bl2;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = globalHierarchyLock;
        synchronized (object2) {
            BCSChild bCSChild;
            if (object == null) {
                throw new IllegalArgumentException();
            }
            Object object3 = this.children;
            synchronized (object3) {
                if (this.children.containsKey(object) || !this.validatePendingAdd(object)) {
                    return false;
                }
                bCSChild = this.createBCSChild(object, this.beanContextChildPeer);
                this.children.put(object, bCSChild);
            }
            object3 = object;
            synchronized (object3) {
                BeanContextChild beanContextChild = null;
                if (object instanceof BeanContextChild) {
                    beanContextChild = (BeanContextChild)object;
                }
                if (object instanceof BeanContextProxy) {
                    beanContextChild = ((BeanContextProxy)object).getBeanContextProxy();
                }
                if (beanContextChild != null) {
                    try {
                        beanContextChild.setBeanContext(this);
                        beanContextChild.addVetoableChangeListener("beanContext", this);
                        beanContextChild.addPropertyChangeListener("beanContext", this);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        HashMap hashMap = this.children;
                        synchronized (hashMap) {
                            this.children.remove(object);
                        }
                        throw new IllegalStateException("The child refused to associate itself with this context.", propertyVetoException);
                    }
                }
                if (object instanceof Visibility) {
                    Visibility visibility = (Visibility)object;
                    if (this.okToUseGui) {
                        visibility.okToUseGui();
                    } else {
                        visibility.dontUseGui();
                    }
                }
                this.childJustAddedHook(object, bCSChild);
            }
            this.fireChildrenAdded(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
            return true;
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(beanContextMembershipListener)) {
                this.bcmListeners.add(beanContextMembershipListener);
            }
        }
    }

    public boolean avoidingGui() {
        return this.needsGui() && !this.okToUseGui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator bcsChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return new BCSIterator(this.children.values().iterator());
        }
    }

    protected void bcsPreDeserializationHook(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    protected void bcsPreSerializationHook(ObjectOutputStream objectOutputStream) throws IOException {
    }

    protected void childDeserializedHook(Object object, BCSChild bCSChild) {
    }

    protected void childJustAddedHook(Object object, BCSChild bCSChild) {
    }

    protected void childJustRemovedHook(Object object, BCSChild bCSChild) {
    }

    protected static final boolean classEquals(Class clazz, Class clazz2) {
        return clazz == clazz2 || clazz.getName().equals(clazz2.getName());
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.children.containsKey(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object[] copyChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray();
        }
    }

    protected BCSChild createBCSChild(Object object, Object object2) {
        return new BCSChild(object, object2);
    }

    protected final void deserialize(ObjectInputStream objectInputStream, Collection collection) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            collection.add(objectInputStream.readObject());
        }
    }

    public void dontUseGui() {
        this.okToUseGui = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            for (BeanContextMembershipListener beanContextMembershipListener : this.bcmListeners) {
                beanContextMembershipListener.childrenAdded(beanContextMembershipEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChildrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            for (BeanContextMembershipListener beanContextMembershipListener : this.bcmListeners) {
                beanContextMembershipListener.childrenRemoved(beanContextMembershipEvent);
            }
        }
    }

    public BeanContext getBeanContextPeer() {
        return (BeanContext)this.beanContextChildPeer;
    }

    protected static final BeanContextChild getChildBeanContextChild(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BeanContextChild && object instanceof BeanContextProxy) {
            throw new IllegalArgumentException("Child cannot implement BeanContextChild and BeanContextProxy simultaneously.");
        }
        if (object instanceof BeanContextChild) {
            return (BeanContextChild)object;
        }
        if (object instanceof BeanContextProxy) {
            return ((BeanContextProxy)object).getBeanContextProxy();
        }
        return null;
    }

    protected static final BeanContextMembershipListener getChildBeanContextMembershipListener(Object object) {
        if (object instanceof BeanContextMembershipListener) {
            return (BeanContextMembershipListener)object;
        }
        return null;
    }

    protected static final PropertyChangeListener getChildPropertyChangeListener(Object object) {
        if (object instanceof PropertyChangeListener) {
            return (PropertyChangeListener)object;
        }
        return null;
    }

    protected static final Serializable getChildSerializable(Object object) {
        if (object instanceof Serializable) {
            return (Serializable)object;
        }
        return null;
    }

    protected static final VetoableChangeListener getChildVetoableChangeListener(Object object) {
        if (object instanceof VetoableChangeListener) {
            return (VetoableChangeListener)object;
        }
        return null;
    }

    protected static final Visibility getChildVisibility(Object object) {
        if (object instanceof Visibility) {
            return (Visibility)object;
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public URL getResource(String string, BeanContextChild beanContextChild) {
        if (!this.contains(beanContextChild)) {
            throw new IllegalArgumentException("argument not a child");
        }
        ClassLoader classLoader = beanContextChild.getClass().getClassLoader();
        return classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
    }

    public InputStream getResourceAsStream(String string, BeanContextChild beanContextChild) {
        if (!this.contains(beanContextChild)) {
            throw new IllegalArgumentException("argument not a child");
        }
        ClassLoader classLoader = beanContextChild.getClass().getClassLoader();
        return classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
    }

    protected void initialize() {
        this.bcmListeners = new ArrayList();
        this.children = new HashMap();
    }

    public Object instantiateChild(String string) throws IOException, ClassNotFoundException {
        return Beans.instantiate(this.getClass().getClassLoader(), string, this);
    }

    public boolean isDesignTime() {
        return this.designTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.isEmpty();
        }
    }

    public boolean isSerializing() {
        return this.serializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().iterator();
        }
    }

    public boolean needsGui() {
        return false;
    }

    public void okToUseGui() {
        this.okToUseGui = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() != this) {
            this.remove(propertyChangeEvent.getSource(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readChildren(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        this.deserialize(objectInputStream, arrayList);
        Iterator iterator = arrayList.iterator();
        Object object = globalHierarchyLock;
        synchronized (object) {
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                while (iterator.hasNext()) {
                    BCSChild bCSChild = (BCSChild)iterator.next();
                    this.childDeserializedHook(bCSChild.getTargetChild(), bCSChild);
                    this.children.put(bCSChild.getTargetChild(), bCSChild);
                }
            }
        }
    }

    public boolean remove(Object object) {
        return this.remove(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Object object, boolean bl) {
        Object object2 = globalHierarchyLock;
        synchronized (object2) {
            BCSChild bCSChild;
            if (object == null) {
                throw new IllegalArgumentException();
            }
            Object object3 = this.children;
            synchronized (object3) {
                if (!this.children.containsKey(object) || !this.validatePendingRemove(object)) {
                    return false;
                }
                bCSChild = (BCSChild)this.children.remove(object);
            }
            object3 = object;
            synchronized (object3) {
                BeanContextChild beanContextChild = null;
                if (object instanceof BeanContextChild) {
                    beanContextChild = (BeanContextChild)object;
                }
                if (object instanceof BeanContextProxy) {
                    beanContextChild = ((BeanContextProxy)object).getBeanContextProxy();
                }
                if (beanContextChild != null) {
                    try {
                        if (bl) {
                            beanContextChild.setBeanContext(null);
                        }
                        beanContextChild.removeVetoableChangeListener("beanContext", this);
                        beanContextChild.removePropertyChangeListener("beanContext", this);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        HashMap hashMap = this.children;
                        synchronized (hashMap) {
                            this.children.put(object, bCSChild);
                        }
                        throw new IllegalStateException("The child refused to disassociate itself with this context.", propertyVetoException);
                    }
                }
                this.childJustRemovedHook(object, bCSChild);
            }
            this.fireChildrenRemoved(new BeanContextMembershipEvent((BeanContext)this, new Object[]{object}));
            return true;
        }
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            this.bcmListeners.remove(beanContextMembershipListener);
        }
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    protected final void serialize(ObjectOutputStream objectOutputStream, Collection collection) throws IOException {
        int n;
        Object[] objectArray = collection.toArray();
        int n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (!(objectArray[n] instanceof Serializable)) continue;
            ++n2;
        }
        objectOutputStream.writeInt(n2);
        for (n = 0; n < objectArray.length; ++n) {
            if (!(objectArray[n] instanceof Serializable)) continue;
            objectOutputStream.writeObject(objectArray[n]);
        }
    }

    public void setDesignTime(boolean bl) {
        boolean bl2 = this.designTime;
        this.designTime = bl;
        this.firePropertyChange("designMode", bl2, bl);
    }

    public void setLocale(Locale locale) throws PropertyVetoException {
        if (locale == null || this.locale == locale) {
            return;
        }
        this.fireVetoableChange("locale", this.locale, locale);
        Locale locale2 = this.locale;
        this.locale = locale;
        this.firePropertyChange("locale", locale2, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.keySet().toArray(objectArray);
        }
    }

    protected boolean validatePendingAdd(Object object) {
        return true;
    }

    protected boolean validatePendingRemove(Object object) {
        return true;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeChildren(ObjectOutputStream objectOutputStream) throws IOException {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            this.serialize(objectOutputStream, this.children.values());
        }
    }

    protected static final class BCSIterator
    implements Iterator {
        private Iterator child;

        BCSIterator(Iterator iterator) {
            this.child = iterator;
        }

        public boolean hasNext() {
            return this.child.hasNext();
        }

        public Object next() {
            return this.child.next();
        }

        public void remove() {
        }
    }

    protected class BCSChild
    implements Serializable {
        private static final long serialVersionUID = -5815286101609939109L;
        private Object targetChild;
        private Object peer;

        BCSChild(Object object, Object object2) {
            this.targetChild = object;
            this.peer = object2;
        }

        private Object getTargetChild() {
            return this.targetChild;
        }
    }
}

