/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptor
extends FeatureDescriptor {
    Class<?> propertyType;
    Method getMethod;
    Method setMethod;
    Class<?> propertyEditorClass;
    boolean bound;
    boolean constrained;

    PropertyDescriptor(String string) {
        this.setName(string);
    }

    public PropertyDescriptor(String string, Class<?> clazz) throws IntrospectionException {
        this.setName(string);
        if (string.length() == 0) {
            throw new IntrospectionException("empty property name");
        }
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.findMethods(clazz, "is" + string2, "get" + string2, "set" + string2);
        if (this.getMethod == null) {
            throw new IntrospectionException("Cannot find a is" + string2 + " or get" + string2 + " method");
        }
        if (this.setMethod == null) {
            throw new IntrospectionException("Cannot find a " + string2 + " method");
        }
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public PropertyDescriptor(String string, Class<?> clazz, String string2, String string3) throws IntrospectionException {
        this.setName(string);
        this.findMethods(clazz, string2, null, string3);
        if (this.getMethod == null && string2 != null) {
            throw new IntrospectionException("Cannot find a getter method called " + string2);
        }
        if (this.setMethod == null && string3 != null) {
            throw new IntrospectionException("Cannot find a setter method called " + string3);
        }
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public PropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        this.setName(string);
        this.getMethod = method;
        this.setMethod = method2;
        this.propertyType = this.checkMethods(this.getMethod, this.setMethod);
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.getMethod;
    }

    public void setReadMethod(Method method) throws IntrospectionException {
        this.propertyType = this.checkMethods(method, this.setMethod);
        this.getMethod = method;
    }

    public Method getWriteMethod() {
        return this.setMethod;
    }

    public void setWriteMethod(Method method) throws IntrospectionException {
        this.propertyType = this.checkMethods(this.getMethod, method);
        this.setMethod = method;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bl) {
        this.bound = bl;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean bl) {
        this.constrained = bl;
    }

    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setPropertyEditorClass(Class<?> clazz) {
        this.propertyEditorClass = clazz;
    }

    public PropertyEditor createPropertyEditor(Object object) {
        if (this.propertyEditorClass == null) {
            return null;
        }
        Constructor constructor = this.findConstructor(this.propertyEditorClass, new Class[]{Object.class});
        if (constructor != null) {
            return this.instantiateClass(constructor, new Object[]{object});
        }
        constructor = this.findConstructor(this.propertyEditorClass, null);
        if (constructor != null) {
            return this.instantiateClass(constructor, null);
        }
        return null;
    }

    private Constructor findConstructor(Class clazz, Class[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private PropertyEditor instantiateClass(Constructor constructor, Object[] objectArray) {
        try {
            return (PropertyEditor)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private void findMethods(Class clazz, String string, String string2, String string3) throws IntrospectionException {
        block13: {
            try {
                Method[] methodArray;
                if (string != null) {
                    try {
                        this.getMethod = clazz.getMethod(string, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (this.getMethod == null && string2 != null) {
                    try {
                        this.getMethod = clazz.getMethod(string2, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (string3 == null) break block13;
                if (this.getMethod != null) {
                    methodArray = this.getMethod.getReturnType();
                    if (methodArray == Void.TYPE) {
                        String string4 = "The property's read method has return type 'void'";
                        throw new IntrospectionException(string4);
                    }
                    Class[] classArray = new Class[]{methodArray};
                    try {
                        this.setMethod = clazz.getMethod(string3, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    break block13;
                }
                if (string != null || string2 != null) break block13;
                methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (!methodArray[i].getName().equals(string3) || methodArray[i].getParameterTypes().length != 1 || methodArray[i].getReturnType() != Void.TYPE) continue;
                    this.setMethod = methodArray[i];
                    break;
                }
            }
            catch (SecurityException securityException) {
                String string5 = "SecurityException thrown on attempt to access methods.";
                throw new IntrospectionException(string5);
            }
        }
    }

    private Class<?> checkMethods(Method method, Method method2) throws IntrospectionException {
        Class<?> clazz = this.propertyType;
        if (method != null) {
            if (method.getParameterTypes().length > 0) {
                throw new IntrospectionException("read method has unexpected parameters");
            }
            clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                throw new IntrospectionException("read method return type is void");
            }
        }
        if (method2 != null) {
            if (method2.getParameterTypes().length != 1) {
                String string = "write method does not have exactly one parameter";
                throw new IntrospectionException(string);
            }
            if (method == null) {
                clazz = method2.getParameterTypes()[0];
            } else if (clazz != null && !clazz.isAssignableFrom(method2.getParameterTypes()[0])) {
                throw new IntrospectionException("read and write method are not compatible");
            }
        }
        return clazz;
    }

    public int hashCode() {
        return (this.propertyType == null ? 0 : this.propertyType.hashCode()) | (this.propertyEditorClass == null ? 0 : this.propertyEditorClass.hashCode()) | (this.bound ? Boolean.TRUE : Boolean.FALSE).hashCode() | (this.constrained ? Boolean.TRUE : Boolean.FALSE).hashCode() | (this.getMethod == null ? 0 : this.getMethod.hashCode()) | (this.setMethod == null ? 0 : this.setMethod.hashCode());
    }

    public boolean equals(Object object) {
        if (object instanceof PropertyDescriptor) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
            boolean bl4 = this.propertyType == null ? propertyDescriptor.propertyType == null : (bl3 = this.propertyType.equals(propertyDescriptor.propertyType));
            boolean bl5 = this.propertyEditorClass == null ? propertyDescriptor.propertyEditorClass == null : this.propertyEditorClass.equals(propertyDescriptor.propertyEditorClass);
            boolean bl6 = bl2 = this.bound == propertyDescriptor.bound && this.constrained == propertyDescriptor.constrained;
            boolean bl7 = this.getMethod == null ? propertyDescriptor.getMethod == null : (bl = this.getMethod.equals(propertyDescriptor.getMethod));
            boolean bl8 = this.setMethod == null ? propertyDescriptor.setMethod == null : this.setMethod.equals(propertyDescriptor.setMethod);
            return bl3 && bl2 && bl && bl8 && bl5;
        }
        return false;
    }
}

