/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Class<?> indexedPropertyType;
    private Method setIndex;
    private Method getIndex;

    public IndexedPropertyDescriptor(String string, Class<?> clazz) throws IntrospectionException {
        super(string);
        String string2;
        try {
            string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string2 = "";
        }
        this.findMethods(clazz, "get" + string2, "set" + string2, "get" + string2, "set" + string2);
    }

    public IndexedPropertyDescriptor(String string, Class<?> clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string);
        this.findMethods(clazz, string2, string3, string4, string5);
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string);
        if (method != null && method.getParameterTypes().length > 0) {
            throw new IntrospectionException("get method has parameters");
        }
        if (method != null && method2.getParameterTypes().length != 1) {
            throw new IntrospectionException("set method does not have exactly one parameter");
        }
        if (method != null && method2 != null) {
            if (!method.getReturnType().equals(method2.getParameterTypes()[0])) {
                throw new IntrospectionException("set and get methods do not share the same type");
            }
            if (!method.getDeclaringClass().isAssignableFrom(method2.getDeclaringClass()) && !method2.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
                throw new IntrospectionException("set and get methods are not in the same class.");
            }
        }
        if (!(method3 == null || method3.getParameterTypes().length == 1 && method3.getParameterTypes()[0].equals(Integer.TYPE))) {
            throw new IntrospectionException("get index method has wrong parameters");
        }
        if (!(method4 == null || method4.getParameterTypes().length == 2 && method4.getParameterTypes()[0].equals(Integer.TYPE))) {
            throw new IntrospectionException("set index method has wrong parameters");
        }
        if (method3 != null && method4 != null) {
            if (!method3.getReturnType().equals(method4.getParameterTypes()[1])) {
                throw new IntrospectionException("set index methods do not share the same type");
            }
            if (!method3.getDeclaringClass().isAssignableFrom(method4.getDeclaringClass()) && !method4.getDeclaringClass().isAssignableFrom(method3.getDeclaringClass())) {
                throw new IntrospectionException("get and set index methods are not in the same class.");
            }
        }
        if (method3 != null && method != null && !method3.getDeclaringClass().isAssignableFrom(method.getDeclaringClass()) && !method.getDeclaringClass().isAssignableFrom(method3.getDeclaringClass())) {
            throw new IntrospectionException("methods are not in the same class.");
        }
        if (method3 != null && method != null && !Array.newInstance(method3.getReturnType(), 0).getClass().equals(method.getReturnType())) {
            throw new IntrospectionException("array methods do not match index methods.");
        }
        this.getMethod = method;
        this.setMethod = method2;
        this.getIndex = method3;
        this.setIndex = method4;
        Class<?> clazz = this.indexedPropertyType = method3 != null ? method3.getReturnType() : method4.getParameterTypes()[1];
        this.propertyType = method != null ? method.getReturnType() : (method2 != null ? method2.getParameterTypes()[0] : Array.newInstance(this.indexedPropertyType, 0).getClass());
    }

    public Class<?> getIndexedPropertyType() {
        return this.indexedPropertyType;
    }

    public Method getIndexedReadMethod() {
        return this.getIndex;
    }

    public void setIndexedReadMethod(Method method) throws IntrospectionException {
        this.getIndex = method;
    }

    public Method getIndexedWriteMethod() {
        return this.setIndex;
    }

    public void setIndexedWriteMethod(Method method) throws IntrospectionException {
        this.setIndex = method;
    }

    private void findMethods(Class clazz, String string, String string2, String string3, String string4) throws IntrospectionException {
        try {
            Class[] classArray;
            Object object;
            if (string3 != null) {
                try {
                    object = new Class[]{Integer.TYPE};
                    this.getIndex = clazz.getMethod(string3, (Class<?>[])object);
                    this.indexedPropertyType = this.getIndex.getReturnType();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (this.getIndex != null) {
                if (string4 != null) {
                    try {
                        object = new Class[]{Integer.TYPE, this.indexedPropertyType};
                        this.setIndex = clazz.getMethod(string4, (Class<?>[])object);
                        if (!this.setIndex.getReturnType().equals(Void.TYPE)) {
                            throw new IntrospectionException(string4 + " has non-void return type");
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            } else if (string4 != null) {
                object = clazz.getMethods();
                for (int i = 0; i < ((AnnotatedElement[])object).length; ++i) {
                    classArray = object[i];
                    if (!classArray.getName().equals(string4) || classArray.getParameterTypes().length != 2 || !classArray.getParameterTypes()[0].equals(Integer.TYPE) || !classArray.getReturnType().equals(Void.TYPE)) continue;
                    if (this.setIndex != null) {
                        throw new IntrospectionException("Multiple, different set methods found that fit the bill!");
                    }
                    this.setIndex = classArray;
                    this.indexedPropertyType = classArray.getParameterTypes()[1];
                }
                if (this.setIndex == null) {
                    throw new IntrospectionException("Cannot find get or set methods.");
                }
            } else {
                throw new IntrospectionException("Cannot find get or set methods.");
            }
            object = Array.newInstance(this.indexedPropertyType, 0).getClass();
            Class[] classArray2 = new Class[]{object};
            try {
                this.setMethod = clazz.getMethod(string2, classArray2);
                if (!this.setMethod.getReturnType().equals(Void.TYPE)) {
                    this.setMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            classArray = new Class[]{};
            try {
                this.getMethod = clazz.getMethod(string, classArray);
                if (!this.getMethod.getReturnType().equals(object)) {
                    this.getMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException("SecurityException while trying to find methods.");
        }
    }
}

