/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.DefaultExceptionListener;
import gnu.java.beans.encoder.ArrayPersistenceDelegate;
import gnu.java.beans.encoder.ClassPersistenceDelegate;
import gnu.java.beans.encoder.CollectionPersistenceDelegate;
import gnu.java.beans.encoder.MapPersistenceDelegate;
import gnu.java.beans.encoder.PrimitivePersistenceDelegate;
import java.beans.DefaultPersistenceDelegate;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoder {
    private static PersistenceDelegate defaultPersistenceDelegate;
    private static PersistenceDelegate fakePersistenceDelegate;
    private static HashMap delegates;
    private IdentityHashMap candidates = new IdentityHashMap();
    private ExceptionListener exceptionListener;
    private int accessCounter = 0;

    public Encoder() {
        Encoder.setupDefaultPersistenceDelegates();
        this.setExceptionListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupDefaultPersistenceDelegates() {
        HashMap hashMap = delegates;
        synchronized (hashMap) {
            if (defaultPersistenceDelegate != null) {
                return;
            }
            delegates.put(Class.class, new ClassPersistenceDelegate());
            PersistenceDelegate persistenceDelegate = new PrimitivePersistenceDelegate();
            delegates.put(Boolean.class, persistenceDelegate);
            delegates.put(Byte.class, persistenceDelegate);
            delegates.put(Short.class, persistenceDelegate);
            delegates.put(Integer.class, persistenceDelegate);
            delegates.put(Long.class, persistenceDelegate);
            delegates.put(Float.class, persistenceDelegate);
            delegates.put(Double.class, persistenceDelegate);
            delegates.put(Object[].class, new ArrayPersistenceDelegate());
            persistenceDelegate = new CollectionPersistenceDelegate();
            delegates.put(AbstractCollection.class, persistenceDelegate);
            persistenceDelegate = new MapPersistenceDelegate();
            delegates.put(AbstractMap.class, persistenceDelegate);
            delegates.put(Hashtable.class, persistenceDelegate);
            defaultPersistenceDelegate = new DefaultPersistenceDelegate();
            delegates.put(Object.class, defaultPersistenceDelegate);
            fakePersistenceDelegate = new PersistenceDelegate(){

                protected Expression instantiate(Object object, Encoder encoder) {
                    return null;
                }
            };
        }
    }

    protected void writeObject(Object object) {
        if (object == null) {
            return;
        }
        PersistenceDelegate persistenceDelegate = this.getPersistenceDelegate(object.getClass());
        ++this.accessCounter;
        persistenceDelegate.writeObject(object, this);
        --this.accessCounter;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener != null ? exceptionListener : DefaultExceptionListener.INSTANCE;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public PersistenceDelegate getPersistenceDelegate(Class<?> clazz) {
        if (clazz == null) {
            return fakePersistenceDelegate;
        }
        if (clazz.isArray()) {
            return (PersistenceDelegate)delegates.get(Object[].class);
        }
        PersistenceDelegate persistenceDelegate = (PersistenceDelegate)delegates.get(clazz);
        return persistenceDelegate != null ? persistenceDelegate : defaultPersistenceDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceDelegate(Class<?> clazz, PersistenceDelegate persistenceDelegate) {
        if (clazz.isArray() || clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class) {
            return;
        }
        HashMap hashMap = delegates;
        synchronized (hashMap) {
            delegates.put(clazz, persistenceDelegate);
        }
    }

    public Object remove(Object object) {
        return this.candidates.remove(object);
    }

    public Object get(Object object) {
        return object == null ? null : (object.getClass() == String.class ? object : this.candidates.get(object));
    }

    public void writeStatement(Statement statement) {
        if (this.accessCounter <= 0) {
            return;
        }
        Object object = statement.getTarget();
        Object object2 = this.get(object);
        if (object2 == null) {
            this.writeObject(object);
            object2 = this.get(object);
        }
        Object[] objectArray = statement.getArguments();
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.get(objectArray[i]);
            if (objectArray2[i] != null && !this.isImmutableType(objectArray[i].getClass())) continue;
            this.writeObject(objectArray[i]);
            objectArray2[i] = this.get(objectArray[i]);
        }
        Statement statement2 = new Statement(object2, statement.getMethodName(), objectArray2);
        try {
            statement2.execute();
        }
        catch (Exception exception) {
            this.exceptionListener.exceptionThrown(exception);
        }
    }

    public void writeExpression(Expression expression) {
        if (this.accessCounter <= 0) {
            return;
        }
        Object object = expression.getTarget();
        Object object2 = null;
        Object object3 = null;
        try {
            object2 = expression.getValue();
        }
        catch (Exception exception) {
            this.exceptionListener.exceptionThrown(exception);
            return;
        }
        object3 = this.get(object2);
        if (object3 == null) {
            Object object4 = this.get(object);
            if (object4 == null) {
                this.writeObject(object);
                object4 = this.get(object);
                if (object4 == null) {
                    return;
                }
            }
            Object[] objectArray = expression.getArguments();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.get(objectArray[i]);
                if (objectArray2[i] != null && !this.isImmutableType(objectArray[i].getClass())) continue;
                this.writeObject(objectArray[i]);
                objectArray2[i] = this.get(objectArray[i]);
            }
            Expression expression2 = new Expression(object4, expression.getMethodName(), objectArray2);
            if (object2 instanceof Class && ((Class)object2).isPrimitive()) {
                expression2.setValue(object2);
            }
            try {
                object3 = expression2.getValue();
                this.candidates.put(object2, object3);
            }
            catch (Exception exception) {
                this.exceptionListener.exceptionThrown(exception);
                return;
            }
            this.writeObject(object2);
        } else if (object2.getClass() == String.class || object2.getClass() == Class.class) {
            this.writeObject(object2);
        }
    }

    boolean isImmutableType(Class clazz) {
        return clazz == String.class || clazz == Class.class || clazz == Integer.class || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    void putCandidate(Object object, Object object2) {
        this.candidates.put(object, object2);
    }

    static {
        delegates = new HashMap();
    }
}

