/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableImageOp
implements RenderableImage {
    private final ContextualRenderedImageFactory crif;
    private ParameterBlock block;

    public RenderableImageOp(ContextualRenderedImageFactory contextualRenderedImageFactory, ParameterBlock parameterBlock) {
        this.crif = contextualRenderedImageFactory;
        this.block = (ParameterBlock)parameterBlock.clone();
    }

    @Override
    public Vector<RenderableImage> getSources() {
        if (this.block.sources == null) {
            return null;
        }
        int n = this.block.sources.size();
        Vector<RenderableImage> vector = new Vector<RenderableImage>();
        for (int i = 0; i < n; ++i) {
            Object object = this.block.sources.get(i);
            if (!(object instanceof RenderableImage)) continue;
            vector.add((RenderableImage)object);
        }
        return vector;
    }

    @Override
    public Object getProperty(String string) {
        return this.crif.getProperty(this.block, string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.crif.getPropertyNames();
    }

    @Override
    public boolean isDynamic() {
        return this.crif.isDynamic();
    }

    @Override
    public float getWidth() {
        return (float)this.crif.getBounds2D(this.block).getWidth();
    }

    @Override
    public float getHeight() {
        return (float)this.crif.getBounds2D(this.block).getHeight();
    }

    @Override
    public float getMinX() {
        return (float)this.crif.getBounds2D(this.block).getX();
    }

    @Override
    public float getMinY() {
        return (float)this.crif.getBounds2D(this.block).getY();
    }

    public ParameterBlock setParameterBlock(ParameterBlock parameterBlock) {
        ParameterBlock parameterBlock2 = this.block;
        this.block = (ParameterBlock)parameterBlock.clone();
        return parameterBlock2;
    }

    public ParameterBlock getParameterBlock() {
        return this.block;
    }

    @Override
    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        if (n == 0) {
            if (n2 == 0) {
                throw new IllegalArgumentException();
            }
            n = Math.round((float)n2 * this.getWidth() / this.getHeight());
        }
        if (n2 == 0) {
            n2 = Math.round((float)n * this.getHeight() / this.getWidth());
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance((float)n * this.getWidth(), (float)n2 * this.getHeight());
        return this.createRendering(new RenderContext(affineTransform, renderingHints));
    }

    @Override
    public RenderedImage createDefaultRendering() {
        return this.createRendering(new RenderContext(new AffineTransform()));
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        ParameterBlock parameterBlock = (ParameterBlock)this.block.clone();
        int n = this.block.sources.size();
        while (--n >= 0) {
            Object object = this.block.sources.get(n);
            if (!(object instanceof RenderableImage)) continue;
            RenderableImage renderableImage = (RenderableImage)object;
            RenderContext renderContext2 = this.crif.mapRenderContext(n, renderContext, this.block, renderableImage);
            parameterBlock.sources.set(n, renderableImage.createRendering(renderContext2));
        }
        return this.crif.create(renderContext, parameterBlock);
    }
}

