/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterBlock
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7577115551785240750L;
    protected Vector<Object> sources;
    protected Vector<Object> parameters;

    public ParameterBlock() {
        this(new Vector<Object>(), new Vector<Object>());
    }

    public ParameterBlock(Vector<Object> vector) {
        this(vector, new Vector<Object>());
    }

    public ParameterBlock(Vector<Object> vector, Vector<Object> vector2) {
        this.sources = vector;
        this.parameters = vector2;
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public Object clone() {
        ParameterBlock parameterBlock = (ParameterBlock)this.shallowClone();
        if (this.sources != null) {
            parameterBlock.sources = (Vector)this.sources.clone();
        }
        if (this.parameters != null) {
            parameterBlock.parameters = (Vector)this.parameters.clone();
        }
        return parameterBlock;
    }

    public ParameterBlock addSource(Object object) {
        this.sources.add(object);
        return this;
    }

    public Object getSource(int n) {
        return this.sources.get(n);
    }

    public ParameterBlock setSource(Object object, int n) {
        this.sources.ensureCapacity(n);
        this.sources.set(n, object);
        return this;
    }

    public RenderedImage getRenderedSource(int n) {
        return (RenderedImage)this.sources.get(n);
    }

    public RenderableImage getRenderableSource(int n) {
        return (RenderableImage)this.sources.get(n);
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public Vector<Object> getSources() {
        return this.sources;
    }

    public void setSources(Vector<Object> vector) {
        this.sources = vector;
    }

    public void removeSources() {
        if (this.sources != null) {
            this.sources.clear();
        }
    }

    public int getNumParameters() {
        return this.parameters.size();
    }

    public Vector<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector<Object> vector) {
        this.parameters = vector;
    }

    public void removeParameters() {
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    public ParameterBlock add(Object object) {
        this.parameters.add(object);
        return this;
    }

    public ParameterBlock add(byte by) {
        return this.add(new Byte(by));
    }

    public ParameterBlock add(char c) {
        return this.add(new Character(c));
    }

    public ParameterBlock add(short s) {
        return this.add(new Short(s));
    }

    public ParameterBlock add(int n) {
        return this.add(new Integer(n));
    }

    public ParameterBlock add(long l) {
        return this.add(new Long(l));
    }

    public ParameterBlock add(float f) {
        return this.add(new Float(f));
    }

    public ParameterBlock add(double d) {
        return this.add(new Double(d));
    }

    public ParameterBlock set(Object object, int n) {
        this.parameters.ensureCapacity(n);
        this.parameters.set(n, object);
        return this;
    }

    public ParameterBlock set(byte by, int n) {
        return this.set(new Byte(by), n);
    }

    public ParameterBlock set(char c, int n) {
        return this.set(new Character(c), n);
    }

    public ParameterBlock set(short s, int n) {
        return this.set(new Short(s), n);
    }

    public ParameterBlock set(int n, int n2) {
        return this.set(new Integer(n), n2);
    }

    public ParameterBlock set(long l, int n) {
        return this.set(new Long(l), n);
    }

    public ParameterBlock set(float f, int n) {
        return this.set(new Float(f), n);
    }

    public ParameterBlock set(double d, int n) {
        return this.set(new Double(d), n);
    }

    public Object getObjectParameter(int n) {
        return this.parameters.get(n);
    }

    public byte getByteParameter(int n) {
        return (Byte)this.parameters.get(n);
    }

    public char getCharParameter(int n) {
        return ((Character)this.parameters.get(n)).charValue();
    }

    public short getShortParameter(int n) {
        return (Short)this.parameters.get(n);
    }

    public int getIntParameter(int n) {
        return (Integer)this.parameters.get(n);
    }

    public long getLongParameter(int n) {
        return (Long)this.parameters.get(n);
    }

    public float getFloatParameter(int n) {
        return ((Float)this.parameters.get(n)).floatValue();
    }

    public double getDoubleParameter(int n) {
        return (Double)this.parameters.get(n);
    }

    public Class[] getParamClasses() {
        int n = this.parameters.size();
        Class[] classArray = new Class[n];
        while (--n >= 0) {
            Class<? extends Object> clazz = this.parameters.get(n).getClass();
            if (clazz == Byte.class) {
                classArray[n] = Byte.TYPE;
                continue;
            }
            if (clazz == Character.class) {
                classArray[n] = Character.TYPE;
                continue;
            }
            if (clazz == Short.class) {
                classArray[n] = Short.TYPE;
                continue;
            }
            if (clazz == Integer.class) {
                classArray[n] = Integer.TYPE;
                continue;
            }
            if (clazz == Long.class) {
                classArray[n] = Long.TYPE;
                continue;
            }
            if (clazz == Float.class) {
                classArray[n] = Float.TYPE;
                continue;
            }
            if (clazz == Double.class) {
                classArray[n] = Double.TYPE;
                continue;
            }
            classArray[n] = clazz;
        }
        return classArray;
    }
}

